/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientTickHandler {
    private static int ticksElapsed = 0;
    public static final List<GainEntry> xpGains = new ArrayList<GainEntry>();

    public static void tickGUI() {
        ++ticksElapsed;
    }

    public static boolean isRefreshTick() {
        return ticksElapsed >= 15;
    }

    public static void resetTicks() {
        ticksElapsed = 0;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++ticksElapsed;
        ClientTickHandler.tickDownGainList();
    }

    public static void tickDownGainList() {
        for (GainEntry gain : xpGains) {
            gain.downTick();
        }
    }

    public static void addToGainList(String skill, long amount) {
        SkillData skillData = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault());
        if (((List)Config.GAIN_BLACKLIST.get()).contains(skill) || skillData.isSkillGroup() && skillData.getGroup().containsKey(skill)) {
            return;
        }
        if (xpGains.size() >= (Integer)Config.GAIN_LIST_SIZE.get()) {
            xpGains.remove(0);
        }
        xpGains.add(new GainEntry(skill, amount));
    }

    public static class GainEntry {
        public int duration = MsLoggy.DEBUG.logAndReturn((Integer)Config.GAIN_LIST_LINGER_DURATION.get(), MsLoggy.LOG_CODE.GUI, "Gain Duration Set as: {}", new Object[0]);
        public final Component display;

        public GainEntry(String skill, long value) {
            this.display = new TextComponent((value >= 0L ? "+" : "") + value + " ").m_7220_((Component)new TranslatableComponent("pmmo." + skill)).m_6270_(CoreUtils.getSkillStyle(skill));
        }

        public void downTick() {
            --this.duration;
        }

        public String toString() {
            return "Duration:" + this.duration + "|" + this.display.toString();
        }
    }
}

