/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SelectionWidget<T extends SelectionEntry<?>>
extends AbstractWidget {
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/resource_packs.png");
    private static final int ENTRY_HEIGHT = 20;
    private final Component title;
    private final Consumer<T> selectCallback;
    private List<T> entries = new ArrayList<T>();
    private T selected = null;
    private boolean extended = false;
    private int scrollOffset = 0;
    private Font font;

    public SelectionWidget(int x, int y, int width, Component title, Consumer<T> selectCallback) {
        super(x, y, width, 20, (Component)new TextComponent(""));
        this.font = Minecraft.m_91087_().f_91062_;
        this.title = title;
        this.selectCallback = selectCallback;
    }

    public void m_6303_(PoseStack pstack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(pstack, mouseX, mouseY, partialTicks);
        if (this.selected != null) {
            ((SelectionEntry)this.selected).render(pstack, this.f_93620_, this.f_93621_, this.f_93618_, false, this.getFGColor(), this.f_93625_);
        } else {
            SelectionWidget.m_93243_((PoseStack)pstack, (Font)this.font, (Component)this.title, (int)(this.f_93620_ + 6), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }
        if (this.extended) {
            pstack.m_85836_();
            pstack.m_85837_(0.0, 0.0, 500.0);
            int boxHeight = Math.max(1, 20 * Math.min(this.entries.size(), 4)) + 2;
            SelectionWidget.m_93172_((PoseStack)pstack, (int)this.f_93620_, (int)(this.f_93621_ + 20 - 1), (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + 20 + boxHeight - 1), (int)-1);
            SelectionWidget.m_93172_((PoseStack)pstack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 20), (int)(this.f_93620_ + this.f_93618_ - 1), (int)(this.f_93621_ + 20 + boxHeight - 2), (int)-16777216);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
            this.m_93228_(pstack, this.f_93620_ + this.f_93618_ - 17, this.f_93621_ + 6, 114, 5, 11, 7);
            T hoverEntry = this.getEntryAtPosition(mouseX, mouseY);
            for (int i = 0; i < 4; ++i) {
                SelectionEntry entry;
                int idx = i + this.scrollOffset;
                if (idx >= this.entries.size()) continue;
                int entryY = this.f_93621_ + (i + 1) * 20;
                entry.render(pstack, this.f_93620_ + 1, entryY, this.f_93618_ - 2, (entry = (SelectionEntry)this.entries.get(idx)) == hoverEntry, this.getFGColor(), this.f_93625_);
            }
            if (this.entries.size() > 4) {
                float scale = 4.0f / (float)this.entries.size();
                int scrollY = this.f_93621_ + (int)((float)(20 * this.scrollOffset) * scale) + 20;
                int barHeight = (int)(80.0f * scale + 1.0f);
                int scrollBotY = Math.min(scrollY + barHeight, this.f_93621_ + 20 + boxHeight - 2);
                SelectionWidget.m_93172_((PoseStack)pstack, (int)(this.f_93620_ + this.f_93618_ - 5), (int)scrollY, (int)(this.f_93620_ + this.f_93618_ - 1), (int)scrollBotY, (int)-10066330);
                SelectionWidget.m_93172_((PoseStack)pstack, (int)(this.f_93620_ + this.f_93618_ - 4), (int)(scrollY + 1), (int)(this.f_93620_ + this.f_93618_ - 2), (int)(scrollBotY - 1), (int)-5592406);
            }
            pstack.m_85849_();
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
            this.m_93228_(pstack, this.f_93620_ + this.f_93618_ - 17, this.f_93621_ + 6, 82, 20, 11, 7);
        }
    }

    public int m_93694_() {
        if (this.extended) {
            return 20 * (Math.min(this.entries.size(), 4) + 1) + 1;
        }
        return 20;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && mouseX >= (double)this.f_93620_ && mouseX <= (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY <= (double)(this.f_93621_ + this.m_93694_())) {
            int maxX = this.f_93620_ + this.f_93618_ - (this.entries.size() > 4 ? 5 : 0);
            int maxY = this.f_93621_ + 20 * Math.min(this.entries.size() + 1, 5);
            if (this.extended && mouseX < (double)maxX && mouseY > (double)(this.f_93621_ + 20) && mouseY < (double)maxY) {
                this.setSelected(this.getEntryAtPosition(mouseX, mouseY), true);
            }
            if (mouseY < (double)(this.f_93621_ + 20) && mouseX < (double)(this.f_93620_ + this.f_93618_) || mouseX < (double)maxX) {
                this.extended = !this.extended;
                this.scrollOffset = 0;
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        this.extended = false;
        this.scrollOffset = 0;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxY = this.f_93621_ + 20 * Math.min(this.entries.size() + 1, 5);
        if (this.extended && mouseX >= (double)this.f_93620_ && mouseX <= (double)(this.f_93620_ + this.f_93618_) && mouseY > (double)(this.f_93621_ + 20) && mouseY < (double)maxY) {
            if (delta < 0.0 && this.scrollOffset < this.entries.size() - 4) {
                ++this.scrollOffset;
            } else if (delta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        return pMouseX >= (double)this.f_93620_ && pMouseY >= (double)this.f_93621_ && pMouseX < (double)(this.f_93620_ + this.f_93618_) && pMouseY < (double)(this.f_93621_ + this.m_93694_());
    }

    private T getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.f_93620_ || mouseX > (double)(this.f_93620_ + this.f_93618_) || mouseY < (double)(this.f_93621_ + 20) || mouseY > (double)(this.f_93621_ + 100)) {
            return null;
        }
        double posY = mouseY - (double)(this.f_93621_ + 20);
        int idx = (int)(posY / 20.0) + this.scrollOffset;
        return (T)(idx < this.entries.size() ? (SelectionEntry)this.entries.get(idx) : null);
    }

    public void setEntries(Collection<T> entry) {
        this.entries = new ArrayList<T>(entry);
    }

    public void setSelected(T selected, boolean notify) {
        this.selected = selected;
        if (notify && this.selectCallback != null) {
            this.selectCallback.accept(selected);
        }
    }

    public T getSelected() {
        return this.selected;
    }

    public Stream<T> stream() {
        return this.entries.stream();
    }

    public void m_142291_(NarrationElementOutput output) {
    }

    public static class SelectionEntry<T>
    implements GuiEventListener {
        private Font font;
        public final Component message;
        public T reference;

        public SelectionEntry(Component message, T reference) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.message = message;
            this.reference = reference;
        }

        public void render(PoseStack pstack, int x, int y, int width, boolean hovered, int fgColor, float alpha) {
            if (hovered) {
                GuiComponent.m_93172_((PoseStack)pstack, (int)x, (int)y, (int)(x + width), (int)(y + 20), (int)-6250336);
            }
            FormattedCharSequence text = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.font.m_92854_((FormattedText)this.message, width - 12)}));
            this.font.m_92744_(pstack, text, (float)(x + 6), (float)(y + 6), fgColor | Mth.m_14167_((float)(alpha * 255.0f)) << 24);
        }
    }
}

