/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.GlossarySelectScreen;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import harmonised.pmmo.util.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class StatScrollWidget
extends ScrollPanel {
    Minecraft mc = Minecraft.m_91087_();
    Core core = Core.get(LogicalSide.CLIENT);
    ItemRenderer itemRenderer = null;
    private final List<Element> content = new ArrayList<Element>();
    private static final String PREDICATE_KEY = "usesPredicate";
    private final CompoundTag internalDefaults = TagBuilder.start().withInt("min_level", 0).withInt("max_level", (Integer)Config.MAX_LEVEL.get()).build();

    private StatScrollWidget(int width, int height, int top, int left) {
        super(Minecraft.m_91087_(), width, height, top, left, 4);
    }

    public StatScrollWidget(int width, int height, int top, int left, int pointless) {
        this(width, height, top, left);
        this.populateLocation(List.of(this.mc.f_91073_.m_46472_().m_135782_()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.DIMENSION}, "", false, true, true);
        this.populateLocation(List.of(((ResourceKey)this.mc.f_91073_.m_204166_(this.mc.f_91074_.m_142538_()).m_203543_().get()).m_135782_()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.BIOME}, "", true, true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, ItemStack stack, ItemRenderer itemRenderer) {
        this(width, height, top, left);
        this.itemRenderer = itemRenderer;
        EventType[] events = stack.m_41720_() instanceof BlockItem ? EventType.BLOCKITEM_APPLICABLE_EVENTS : EventType.ITEM_APPLICABLE_EVENTS;
        ReqType[] reqs = stack.m_41720_() instanceof BlockItem ? ReqType.BLOCKITEM_APPLICABLE_EVENTS : ReqType.ITEM_APPLICABLE_EVENTS;
        this.populateItems(List.of(stack), events, reqs, ModifierDataType.values(), "", true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, Entity entity) {
        this(width, height, top, left);
        this.populateEntity(List.of(entity), EventType.ENTITY_APPLICABLE_EVENTS, ReqType.ENTITY_APPLICABLE_EVENTS, entity instanceof Player, "");
    }

    public StatScrollWidget(int width, int height, int top, int left, BlockPos pos, ItemRenderer itemRenderer) {
        this(width, height, top, left);
        this.itemRenderer = itemRenderer;
        this.populateBlockFromWorld(pos, EventType.BLOCK_APPLICABLE_EVENTS, ReqType.BLOCK_APPLICABLE_EVENTS);
    }

    public StatScrollWidget(int width, int height, int top, int left, GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type, ItemRenderer itemRenderer) {
        this(width, height, top, left);
        this.itemRenderer = itemRenderer;
        this.generateGlossary(selection, object, skill, type);
    }

    private int step(int level) {
        return level * 10;
    }

    public void generateGlossary(GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type) {
        block0 : switch (selection) {
            case REQS: {
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        ReqType[] reqTypeArray;
                        List<ItemStack> list = ForgeRegistries.ITEMS.getValues().stream().flatMap(item -> {
                            NonNullList list = NonNullList.m_122779_();
                            item.m_6787_(CreativeModeTab.f_40754_, list);
                            return list.stream();
                        }).toList();
                        if (type == null) {
                            reqTypeArray = ReqType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray2 = new ReqType[1];
                            reqTypeArray = reqTypeArray2;
                            reqTypeArray2[0] = (ReqType)type;
                        }
                        this.populateItems(list, events, reqTypeArray, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        ReqType[] reqTypeArray;
                        Collection collection = ForgeRegistries.BLOCKS.getValues();
                        if (type == null) {
                            reqTypeArray = ReqType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray3 = new ReqType[1];
                            reqTypeArray = reqTypeArray3;
                            reqTypeArray3[0] = (ReqType)type;
                        }
                        this.populateBlocks(collection, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        ReqType[] reqTypeArray;
                        List<Entity> list = ForgeRegistries.ENTITIES.getValues().stream().map(entityType -> entityType.m_20615_((Level)this.mc.f_91073_)).filter(entity -> entity != null).toList();
                        if (type == null) {
                            reqTypeArray = ReqType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray4 = new ReqType[1];
                            reqTypeArray = reqTypeArray4;
                            reqTypeArray4[0] = (ReqType)type;
                        }
                        this.populateEntity(list, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(ForgeRegistries.BIOMES.getKeys().stream().toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, true, false, false);
                        break block0;
                    }
                    case ENCHANTS: {
                        this.populateEnchants(ForgeRegistries.ENCHANTMENTS.getValues().stream().map(ench -> RegistryUtil.getId(ench)).toList(), skill);
                        break block0;
                    }
                }
                break;
            }
            case XP: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        EventType[] eventTypeArray;
                        List<ItemStack> list = ForgeRegistries.ITEMS.getValues().stream().flatMap(item -> {
                            NonNullList list = NonNullList.m_122779_();
                            item.m_6787_(CreativeModeTab.f_40754_, list);
                            return list.stream();
                        }).toList();
                        if (type == null) {
                            eventTypeArray = EventType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray2 = new EventType[1];
                            eventTypeArray = eventTypeArray2;
                            eventTypeArray2[0] = (EventType)type;
                        }
                        this.populateItems(list, eventTypeArray, reqs, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        EventType[] eventTypeArray;
                        Collection collection = ForgeRegistries.BLOCKS.getValues();
                        if (type == null) {
                            eventTypeArray = EventType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray3 = new EventType[1];
                            eventTypeArray = eventTypeArray3;
                            eventTypeArray3[0] = (EventType)type;
                        }
                        this.populateBlocks(collection, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        EventType[] eventTypeArray;
                        List<Entity> list = ForgeRegistries.ENTITIES.getValues().stream().map(entityType -> entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_)).filter(entity -> entity != null).toList();
                        if (type == null) {
                            eventTypeArray = EventType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray4 = new EventType[1];
                            eventTypeArray = eventTypeArray4;
                            eventTypeArray4[0] = (EventType)type;
                        }
                        this.populateEntity(list, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case EFFECTS: {
                        this.populateEffects(ForgeRegistries.MOB_EFFECTS.getValues(), new EventType[]{EventType.EFFECT}, reqs, skill);
                        break block0;
                    }
                }
                break;
            }
            case BONUS: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                switch (object) {
                    case ITEMS: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ItemStack> list = ForgeRegistries.ITEMS.getValues().stream().flatMap(item -> {
                            NonNullList list = NonNullList.m_122779_();
                            item.m_6787_(CreativeModeTab.f_40754_, list);
                            return list.stream();
                        }).toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray2 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray2;
                            modifierDataTypeArray2[0] = (ModifierDataType)type;
                        }
                        this.populateItems(list, events, reqs, modifierDataTypeArray, skill, false, false);
                        break block0;
                    }
                    case DIMENSIONS: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray3 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray3;
                            modifierDataTypeArray3[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = ForgeRegistries.BIOMES.getKeys().stream().toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray4 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray4;
                            modifierDataTypeArray4[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, true, false, false);
                        break block0;
                    }
                }
                break;
            }
            case SALVAGE: {
                if (object != GlossarySelectScreen.OBJECT.ITEMS) break;
                this.populateItems(ForgeRegistries.ITEMS.getValues().stream().map(item -> new ItemStack((ItemLike)item)).toList(), new EventType[0], new ReqType[0], new ModifierDataType[0], skill, true, false);
                break;
            }
            case VEIN: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        this.populateItems(ForgeRegistries.ITEMS.getValues().stream().flatMap(item -> {
                            NonNullList list = NonNullList.m_122779_();
                            item.m_6787_(CreativeModeTab.f_40754_, list);
                            return list.stream();
                        }).toList(), events, reqs, bonuses, skill, false, true);
                        break block0;
                    }
                    case BLOCKS: {
                        this.populateBlocks(ForgeRegistries.BLOCKS.getValues(), events, reqs, true, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), reqs, bonuses, skill, false, true, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(ForgeRegistries.BIOMES.getKeys().stream().toList(), reqs, bonuses, skill, true, true, false);
                        break block0;
                    }
                }
                break;
            }
            case MOB_SCALING: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), reqs, bonuses, skill, false, false, true);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(ForgeRegistries.BIOMES.getKeys().stream().toList(), reqs, bonuses, skill, true, false, true);
                        break block0;
                    }
                }
                break;
            }
            case PERKS: {
                this.populatePerks(skill);
                break;
            }
        }
    }

    private void populateItems(List<ItemStack> items, EventType[] events, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean includeSalvage, boolean includeVein) {
        for (ItemStack stack : items) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (items.size() > 1) {
                this.content.add(new RenderableElement(stack.m_41611_(), 1, (int)stack.m_41791_().f_43022_.m_126665_(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), stack));
            }
            this.addEventSection(event -> {
                Map<String, Long> map = this.core.getExperienceAwards((EventType)event, stack, (Player)this.mc.f_91074_, new CompoundTag());
                if (stack.m_41720_() instanceof BlockItem) {
                    map = this.core.getCommonXpAwardData((Map<String, Long>)new HashMap<String, Long>(), (EventType)event, RegistryUtil.getId(stack), (Player)this.mc.f_91074_, ObjectType.BLOCK, TagUtils.stackTag(stack));
                }
                return map;
            }, events, skillFilter);
            this.addReqSection(reqType -> {
                Map<String, Integer> reqMap = this.core.getReqMap((ReqType)reqType, stack);
                if (reqType == ReqType.USE_ENCHANTMENT) {
                    this.core.getEnchantReqs(stack).forEach((skill, level) -> reqMap.merge((String)skill, (Integer)level, (o, n) -> o > n ? o : n));
                }
                if (stack.m_41720_() instanceof BlockItem) {
                    reqMap.putAll(this.core.getCommonReqData((Map<String, Integer>)new HashMap<String, Integer>(), ObjectType.BLOCK, RegistryUtil.getId(stack), (ReqType)reqType, TagUtils.stackTag(stack)));
                }
                return reqMap;
            }, CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.ITEM).getData(RegistryUtil.getId(stack)).getNegativeEffect(), true), reqs, skillFilter);
            this.addModifierSection(mod -> this.core.getTooltipRegistry().bonusTooltipExists(RegistryUtil.getId(stack), (ModifierDataType)mod) ? this.core.getTooltipRegistry().getBonusTooltipData(RegistryUtil.getId(stack), (ModifierDataType)mod, stack) : this.core.getObjectModifierMap(ObjectType.ITEM, RegistryUtil.getId(stack), (ModifierDataType)mod, TagUtils.stackTag(stack)), modifiers, skillFilter);
            if (includeSalvage) {
                this.addSalvageSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).salvage());
            }
            if (includeVein) {
                this.addItemVeinSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).veinData(), stack.m_41720_() instanceof BlockItem);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateBlockFromWorld(BlockPos block, EventType[] events, ReqType[] reqs) {
        this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, block, (Level)Minecraft.m_91087_().f_91073_, null, new CompoundTag()), events, "");
        this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, block, (Level)Minecraft.m_91087_().f_91073_), new ArrayList<MobEffectInstance>(), reqs, "");
        this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(Minecraft.m_91087_().f_91073_.m_8055_(block))).veinData());
    }

    private void populateBlocks(Collection<Block> blocks, EventType[] events, ReqType[] reqs, boolean includeVein, String skillFilter) {
        for (Block block : blocks) {
            int lengthBeforeProcessing = this.content.size() + 1;
            ItemStack stack = new ItemStack((ItemLike)block.m_5456_());
            ResourceLocation id = RegistryUtil.getId(block);
            this.content.add(new RenderableElement(stack.m_41611_(), 1, (int)stack.m_41791_().f_43022_.m_126665_(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), block));
            this.addEventSection(event -> this.core.getTooltipRegistry().xpGainTooltipExists(id, (EventType)event) ? Collections.singletonMap(PREDICATE_KEY, 0L) : this.core.getObjectExperienceMap(ObjectType.BLOCK, id, (EventType)event, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getPredicateRegistry().predicateExists(id, (ReqType)reqType) ? Collections.singletonMap(PREDICATE_KEY, 0) : this.core.getObjectSkillMap(ObjectType.BLOCK, id, (ReqType)reqType, new CompoundTag()), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (includeVein) {
                this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(block)).veinData());
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEntity(List<? extends Entity> entities, EventType[] events, ReqType[] reqs, boolean isPlayer, String skillFilter) {
        for (Entity entity : entities) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (entities.size() > 1) {
                this.content.add(new RenderableElement(entity.m_5446_(), 1, 0xEEEEEE, (int)((Integer)Config.SECTION_HEADER_COLOR.get()), entity));
            }
            this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, entity, null, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, entity), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (isPlayer) {
                this.addPlayerSection(entity);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEffects(Collection<MobEffect> effects, EventType[] events, ReqType[] reqs, String skillFilter) {
        for (MobEffect effect : effects) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (effects.size() > 1) {
                this.content.add(new TextElement(effect.m_19482_(), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int lvl = 0; lvl <= this.getEffectHighestConfiguration(effect); ++lvl) {
                Map<String, Long> xpMap = this.core.getExperienceAwards(new MobEffectInstance(effect, 30, lvl), null, new CompoundTag());
                if (xpMap.isEmpty() || xpMap.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 0L)) continue;
                holder.add(new TextElement((Component)new TextComponent(String.valueOf(lvl)), 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpMap.entrySet()) {
                    if (map.getValue() == 0L) continue;
                    holder.add(new TextElement(map.getKey(), map.getValue(), this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.add(new TextElement((Component)LangProvider.EVENT_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private int getEffectHighestConfiguration(MobEffect effect) {
        DataSource data = (DataSource)this.core.getLoader().getLoader(ObjectType.EFFECT).getData().get(RegistryUtil.getId(effect));
        return data == null ? 0 : ((EnhancementsData)data).skillArray().keySet().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void populateLocation(List<ResourceLocation> locations, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean isBiome, boolean includeVein, boolean includeScaling) {
        locations.forEach(loc -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (locations.size() > 1) {
                this.content.add(new TextElement((Component)new TextComponent(loc.toString()).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            this.addReqSection(reqType -> this.core.getObjectSkillMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ReqType)reqType, new CompoundTag()), isBiome ? CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getNegativeEffect(), true) : new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (reqs.length > 0 && isBiome) {
                this.addReqEffectSection(CoreUtils.getEffects(isBiome ? this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getPositiveEffect() : this.core.getLoader().getLoader(ObjectType.DIMENSION).getData((ResourceLocation)loc).getPositiveEffect(), false), false);
            }
            this.addModifierSection(mod -> this.core.getObjectModifierMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ModifierDataType)mod, new CompoundTag()), modifiers, skillFilter);
            if (includeVein) {
                this.addVeinBlacklistSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (includeScaling) {
                this.addMobModifierSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populateEnchants(List<ResourceLocation> enchants, String skillFilter) {
        enchants.forEach(ench -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (enchants.size() > 1) {
                this.content.add(new TextElement((Component)new TextComponent(ench.toString()).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int i = 0; i <= ((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ench)).m_6586_(); ++i) {
                Map<String, Integer> reqMap = this.core.getEnchantmentReqs((ResourceLocation)ench, i).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue()));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == 0)) continue;
                holder.add(new TextElement((Component)new TextComponent(String.valueOf(i)), 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Integer> map : reqMap.entrySet()) {
                    if (map.getValue() == 0) continue;
                    holder.add(new TextElement(map.getKey(), map.getValue(), this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.add(new TextElement((Component)LangProvider.REQ_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populatePerks(String skillFilter) {
        for (EventType cause : EventType.values()) {
            ArrayList holder = new ArrayList();
            ((Map)PerksConfig.PERK_SETTINGS.get().getOrDefault(cause, new HashMap())).forEach((skill, list) -> {
                if (!skill.contains(skillFilter)) {
                    return;
                }
                holder.add(new TextElement((Component)new TranslatableComponent("pmmo." + skill).m_130940_(ChatFormatting.UNDERLINE), this.step(1), CoreUtils.getSkillStyle(skill).m_131135_().m_131265_(), false, 0));
                list.forEach(src -> {
                    ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
                    holder.add(new TextElement((Component)new TranslatableComponent("pmmo." + perkID.m_135827_() + "." + perkID.m_135815_()), this.step(1), 0xFFFFFF, false, 0));
                    CompoundTag newsrc = this.internalDefaults.m_6426_().m_128391_(this.core.getPerkRegistry().getProperties(perkID).m_128391_(src));
                    newsrc.m_128431_().forEach(key -> {
                        if (key.equals("perk")) {
                            return;
                        }
                        if (newsrc.m_128423_(key) instanceof ListTag) {
                            ListTag innerList = newsrc.m_128437_(key, (int)((ListTag)newsrc.m_128423_(key)).m_7264_());
                            holder.add(new TextElement((Component)new TextComponent(key + " = "), this.step(2), 0xAAFFFF, false, 0));
                            innerList.forEach(tag -> holder.add(new TextElement((Component)new TextComponent(tag.m_7916_()), this.step(3), 8160188, false, 0)));
                        } else {
                            holder.add(new TextElement((Component)new TextComponent(key + " = " + newsrc.m_128423_(key).m_7916_()), this.step(2), 0xAAFFFF, false, 0));
                        }
                    });
                });
            });
            if (holder.size() <= 0) continue;
            this.content.add(new TextElement(cause, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(holder);
        }
    }

    private void addEventSection(Function<EventType, Map<String, Long>> xpSrc, EventType[] events, String skillFilter) {
        if (events.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (EventType event : events) {
                Map<String, Long> xpAwards = CoreUtils.processSkillGroupXP(xpSrc.apply(event)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
                if (xpAwards.containsKey(PREDICATE_KEY)) {
                    holder.add(new TextElement((Component)LangProvider.ADDON_AFFECTED_ATTRIBUTE.asComponent(), 5, 16751619, false, 0));
                    continue;
                }
                if (xpAwards.isEmpty()) continue;
                holder.add(new TextElement(event, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpAwards.entrySet()) {
                    holder.add(new TextElement(map.getKey(), map.getValue(), 5, CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.add(new TextElement((Component)LangProvider.EVENT_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addReqSection(Function<ReqType, Map<String, Integer>> reqSrc, List<MobEffectInstance> reqEffects, ReqType[] reqs, String skillFilter) {
        if (reqs.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (ReqType reqType : reqs) {
                Map<String, Integer> reqMap = CoreUtils.processSkillGroupReqs(reqSrc.apply(reqType)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue()));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == 0)) continue;
                holder.add(new TextElement(reqType, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Integer> map : reqMap.entrySet()) {
                    if (map.getValue() == 0) continue;
                    holder.add(new TextElement(map.getKey(), map.getValue(), this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.add(new TextElement((Component)LangProvider.REQ_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
                this.addReqEffectSection(reqEffects, true);
            }
        }
    }

    private void addReqEffectSection(List<MobEffectInstance> reqEffects, boolean isNegative) {
        if (reqEffects.size() > 0) {
            this.content.add(new TextElement((Component)(isNegative ? LangProvider.REQ_EFFECTS_HEADER.asComponent() : LangProvider.BIOME_EFFECT_POS.asComponent()), 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (MobEffectInstance mei : reqEffects) {
                this.content.add(new TextElement(mei.m_19544_().m_19482_(), this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addModifierSection(Function<ModifierDataType, Map<String, Double>> bonusSrc, ModifierDataType[] mods, String skillFilter) {
        if (mods.length > 0) {
            ArrayList holder = new ArrayList();
            for (ModifierDataType mod : mods) {
                Map<String, Double> modifiers = bonusSrc.apply(mod).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Double)e.getValue()));
                if (modifiers.isEmpty()) continue;
                this.content.add(new TextElement(mod, 1, 0xFFFFFF, false, 0));
                modifiers.forEach((key, value) -> this.content.add(new TextElement((String)key, (double)value, this.step(1), CoreUtils.getSkillColor(key))));
            }
            if (holder.size() > 0) {
                this.content.add(new TextElement((Component)LangProvider.MODIFIER_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addSalvageSection(Map<ResourceLocation, CodecTypes.SalvageData> salvage) {
        if (!salvage.isEmpty()) {
            this.content.add(new TextElement((Component)LangProvider.SALVAGE_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> salvageEntry : salvage.entrySet()) {
                CodecTypes.SalvageData data = salvageEntry.getValue();
                ItemStack resultStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(salvageEntry.getKey()));
                this.content.add(new TextElement(resultStack.m_41611_(), this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
                if (!data.levelReq().isEmpty()) {
                    this.content.add(new TextElement((Component)LangProvider.SALVAGE_LEVEL_REQ.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Integer> entry : data.levelReq().entrySet()) {
                        this.content.add(new TextElement(entry.getKey(), entry.getValue(), this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                this.content.add(new TextElement((Component)LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).m_130940_(ChatFormatting.UNDERLINE), this.step(1), 0xFFFFFF, false, 0));
                this.content.add(new TextElement((Component)LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).m_130940_(ChatFormatting.UNDERLINE), this.step(1), 0xFFFFFF, false, 0));
                if (!data.chancePerLevel().isEmpty()) {
                    this.content.add(new TextElement((Component)LangProvider.SALVAGE_CHANCE_MOD.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Number> entry : data.chancePerLevel().entrySet()) {
                        this.content.add(new TextElement(entry.getKey(), (Double)entry.getValue(), this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                if (data.xpAward().isEmpty()) continue;
                this.content.add(new TextElement((Component)LangProvider.SALVAGE_XP_AWARD.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.step(1), 0xFFFFFF, false, 0));
                for (Map.Entry<String, Number> entry : data.xpAward().entrySet()) {
                    this.content.add(new TextElement(entry.getKey(), (Long)entry.getValue(), this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                }
            }
        }
    }

    private void addItemVeinSection(VeinData veinData, boolean isBlockItem) {
        if (!veinData.equals(VeinData.EMPTY)) {
            this.content.add(new TextElement((Component)LangProvider.VEIN_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.add(new TextElement((Component)LangProvider.VEIN_RATE.asComponent(veinData.chargeRate.orElse(0.0) * 2.0), this.step(1), 0xFFFFFF, false, 0));
            this.content.add(new TextElement((Component)LangProvider.VEIN_CAP.asComponent(veinData.chargeCap.orElse(0)), this.step(1), 0xFFFFFF, false, 0));
            if (isBlockItem) {
                this.content.add(new TextElement((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addBlockVeinSection(VeinData veinData) {
        if (veinData.consumeAmount != VeinData.EMPTY.consumeAmount) {
            this.content.add(new TextElement((Component)LangProvider.VEIN_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.add(new TextElement((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.step(1), 0xFFFFFF, false, 0));
        }
    }

    private void addPlayerSection(Entity entity) {
        this.content.add(new TextElement((Component)LangProvider.PLAYER_HEADER.asComponent(), this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        PlayerData data = this.core.getLoader().PLAYER_LOADER.getData(new ResourceLocation(entity.m_142081_().toString()));
        this.content.add(new TextElement((Component)LangProvider.PLAYER_IGNORE_REQ.asComponent(data.ignoreReq()), this.step(2), 0xFFFFFF, false, 0));
        if (!data.bonuses().isEmpty()) {
            this.content.add(new TextElement((Component)LangProvider.PLAYER_BONUSES.asComponent(), this.step(2), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
            for (Map.Entry<String, Double> bonus : data.bonuses().entrySet()) {
                this.content.add(new TextElement(bonus.getKey(), bonus.getValue(), this.step(3), CoreUtils.getSkillColor(bonus.getKey())));
            }
        }
        Map<String, Long> rawXp = this.core.getData().getXpMap(entity.m_142081_());
        LinkedHashMap orderedMap = new LinkedHashMap();
        ArrayList<String> skillKeys = new ArrayList<String>(rawXp.keySet().stream().toList());
        skillKeys.sort(Comparator.comparingLong(a -> (Long)rawXp.get(a)).reversed());
        skillKeys.forEach(skill -> orderedMap.put(skill, this.core.getData().getLevelFromXP((Long)rawXp.get(skill))));
        this.content.add(new TextElement((Component)LangProvider.SKILL_LIST_HEADER.asComponent(), this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        for (Map.Entry rawMap : orderedMap.entrySet()) {
            this.content.add(new TextElement((String)rawMap.getKey(), (Integer)rawMap.getValue(), this.step(2), CoreUtils.getSkillColor((String)rawMap.getKey())));
        }
    }

    private void addVeinBlacklistSection(ObjectType type, ResourceLocation location) {
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.veinBlacklist().isEmpty()) {
            this.content.add(new TextElement((Component)LangProvider.VEIN_BLACKLIST_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.step(1), 0xFFFFFF, false, 0));
            for (ResourceLocation blockID : loader.veinBlacklist()) {
                this.content.add(new TextElement((Component)new TextComponent(blockID.toString()), this.step(2), 0xEEEEEE, false, 0));
            }
        }
    }

    private void addMobModifierSection(ObjectType type, ResourceLocation location) {
        if (type != ObjectType.BIOME && type != ObjectType.DIMENSION) {
            return;
        }
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.mobModifiers().isEmpty()) {
            this.content.add(new TextElement((Component)LangProvider.MOB_MODIFIER_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.step(1), 0xFFFFFF, false, 0));
            for (Map.Entry<ResourceLocation, Map<String, Double>> mobMap : loader.mobModifiers().entrySet()) {
                Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(mobMap.getKey())).m_20615_((Level)this.mc.f_91073_);
                this.content.add(new RenderableElement(entity.m_7755_(), this.step(1), 0xFFFFFF, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get()), entity));
                for (Map.Entry<String, Double> map : mobMap.getValue().entrySet()) {
                    Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(map.getKey()));
                    TextComponent text = attribute == null ? new TextComponent(map.getKey()) : new TranslatableComponent(attribute.m_22087_());
                    text.m_7220_((Component)new TextComponent(": " + map.getValue()));
                    this.content.add(new TextElement((Component)text, this.step(2), 0xFFFFFF, false, 0xFFFFFF));
                }
            }
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    protected int getContentHeight() {
        return this.content.size() * 12;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTicks) {
        return super.m_6375_(mouseX, mouseY, partialTicks);
    }

    protected void drawPanel(PoseStack poseStack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        for (int i = 0; i < this.content.size(); ++i) {
            this.content.get(i).render(poseStack, this.left, (int)((float)(relativeY + i * 12) - this.scrollDistance), this.width, this.itemRenderer);
        }
    }

    private record RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack, Block block, Entity entity) implements Element
    {
        RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack) {
            this(text, xOffset, color, headerColor, stack, null, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Block block) {
            this(text, xOffset, color, headerColor, null, block, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Entity entity) {
            this(text, xOffset, color, headerColor, null, null, entity);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y, int width, ItemRenderer itemRenderer) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)this.headerColor());
            Font font = Minecraft.m_91087_().f_91062_;
            if (this.stack() != null || this.block() != null) {
                ItemStack renderStack = this.stack() == null ? new ItemStack((ItemLike)this.block().m_5456_()) : this.stack();
                itemRenderer.m_115203_(renderStack, x + width - 25, y);
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)font, (Component)renderStack.m_41611_(), (int)(x + 10), (int)y, (int)0xFFFFFF);
            } else if (this.entity != null && this.entity instanceof LivingEntity) {
                int scale = Math.max(1, 10 / Math.max(1, (int)this.entity.m_142469_().m_82309_()));
                InventoryScreen.m_98850_((int)(x + width - 20), (int)(y + 12), (int)scale, (float)((float)(x + 51) - 100.0f), (float)((float)(y + 75 - 50) - 100.0f), (LivingEntity)((LivingEntity)this.entity));
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.entity.m_5446_(), (int)x, (int)y, (int)0xFFFFFF);
            }
        }
    }

    private record TextElement(Component text, int xOffset, int color, boolean isHeader, int headerColor) implements Element
    {
        public TextElement(String key, int value, int xOffset, int color) {
            this((Component)new TranslatableComponent("pmmo." + key).m_7220_((Component)new TextComponent(": " + value)), xOffset, color, false, 0);
        }

        public TextElement(String key, long value, int xOffset, int color) {
            this((Component)new TranslatableComponent("pmmo." + key).m_7220_((Component)new TextComponent(": " + value)), xOffset, color, false, 0);
        }

        public TextElement(String key, double value, int xOffset, int color) {
            this((Component)new TranslatableComponent("pmmo." + key).m_7220_((Component)new TextComponent(": " + DP.dp(value * 100.0) + "%")), xOffset, color, false, 0);
        }

        public TextElement(Enum<?> type, int xOffset, int color, boolean isHeader, int headerColor) {
            this((Component)new TranslatableComponent("pmmo.enum." + type.name()), xOffset, color, isHeader, headerColor);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y, int width, ItemRenderer unused) {
            if (this.isHeader()) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)this.headerColor());
            }
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.text(), (int)(x + this.xOffset()), (int)y, (int)this.color());
        }
    }

    private static interface Element {
        public void render(PoseStack var1, int var2, int var3, int var4, ItemRenderer var5);
    }
}

