/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import com.mojang.serialization.Codec;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.readers.TomlConfigHelper;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.ForgeConfigSpec;

public class PerksConfig {
    public static ForgeConfigSpec SERVER_CONFIG;
    private static final Codec<Map<EventType, Map<String, List<CompoundTag>>>> CODEC;
    public static TomlConfigHelper.ConfigObject<Map<EventType, Map<String, List<CompoundTag>>>> PERK_SETTINGS;
    private static Map<EventType, Map<String, List<CompoundTag>>> defaultSettings;

    private static void buildPerkSettings(ForgeConfigSpec.Builder builder) {
        builder.comment("These settings define which perks are used and the settings which govern them.").push("Perks");
        PERK_SETTINGS = TomlConfigHelper.defineObject(builder, "For_Event", CODEC, defaultSettings);
        builder.pop();
    }

    private static void generateDefaults() {
        defaultSettings = new HashMap<EventType, Map<String, List<CompoundTag>>>();
        HashMap<String, List<CompoundTag>> bodyMap = new HashMap<String, List<CompoundTag>>();
        bodyMap.put("mining", List.of(TagBuilder.start().withString("perk", "pmmo:break_speed").withInt("modifier", 1000).withDouble("pickaxe_dig", 0.005).build()));
        bodyMap.put("excavation", List.of(TagBuilder.start().withString("perk", "pmmo:break_speed").withInt("modifier", 1000).withDouble("shovel_dig", 0.005).build()));
        bodyMap.put("woodcutting", List.of(TagBuilder.start().withString("perk", "pmmo:break_speed").withInt("modifier", 1000).withDouble("axe_dig", 0.005).build()));
        bodyMap.put("farming", List.of(TagBuilder.start().withString("perk", "pmmo:break_speed").withInt("modifier", 1000).withDouble("hoe_dig", 0.005).withDouble("shears_dig", 0.005).build()));
        bodyMap.put("combat", List.of(TagBuilder.start().withString("perk", "pmmo:break_speed").withInt("modifier", 1000).withDouble("sword_dig", 0.005).build()));
        defaultSettings.put(EventType.BREAK_SPEED, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("mining", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "mining").build()));
        bodyMap.put("building", List.of(TagBuilder.start().withString("perk", "pmmo:attribute").withString("attribute", "forge:reach_distance").withDouble("per_level", 0.05).withDouble("max_boost", 10.0).build(), TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "building").build()));
        bodyMap.put("excavation", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "excavation").build()));
        bodyMap.put("woodcutting", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "woodcutting").build()));
        bodyMap.put("farming", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "farming").build()));
        bodyMap.put("agility", List.of(TagBuilder.start().withString("perk", "pmmo:attribute").withString("attribute", "minecraft:generic.movement_speed").withDouble("per_level", 3.5E-5).withDouble("max_boost", 1.0).build(), TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "agility").build()));
        bodyMap.put("endurance", List.of(TagBuilder.start().withString("perk", "pmmo:attribute").withString("attribute", "minecraft:generic.max_health").withDouble("per_level", 0.05).withDouble("max_boost", 10.0).build(), TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "endurance").build()));
        bodyMap.put("combat", List.of(TagBuilder.start().withString("perk", "pmmo:attribute").withString("attribute", "minecraft:generic.attack_damage").withDouble("per_level", 0.005).withDouble("max_boost", 1.0).build(), TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "combat").build()));
        bodyMap.put("gunslinging", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "gunslinging").build()));
        bodyMap.put("archery", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "archery").build()));
        bodyMap.put("smithing", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "smithing").build()));
        bodyMap.put("flying", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "flying").build()));
        bodyMap.put("swimming", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "swimming").build()));
        bodyMap.put("sailing", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "sailing").build()));
        bodyMap.put("fishing", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "fishing").build()));
        bodyMap.put("crafting", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "crafting").build()));
        bodyMap.put("magic", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "magic").build(), TagBuilder.start().withString("perk", "ars_scalaes:mana_boost").withDouble("max_boost", 3000.0).withDouble("per_level", 3.0).build(), TagBuilder.start().withString("perk", "ars_scalaes:mana_regen").withDouble("max_boost", 100.0).withDouble("per_level", 0.06).build()));
        bodyMap.put("slayer", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "slayer").build()));
        bodyMap.put("hunter", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "hunter").build()));
        bodyMap.put("taming", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "taming").build()));
        bodyMap.put("cooking", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "cooking").build()));
        bodyMap.put("alchemy", List.of(TagBuilder.start().withString("perk", "pmmo:fireworks").withString("skill", "alchemy").build()));
        defaultSettings.put(EventType.SKILL_UP, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("agility", List.of(TagBuilder.start().withString("perk", "pmmo:jump_boost").withDouble("per_level", 5.0E-4).build()));
        defaultSettings.put(EventType.JUMP, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("agility", List.of(TagBuilder.start().withString("perk", "pmmo:jump_boost").withDouble("per_level", 0.001).build()));
        defaultSettings.put(EventType.SPRINT_JUMP, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("agility", List.of(TagBuilder.start().withString("perk", "pmmo:jump_boost").withDouble("per_level", 0.0015).build()));
        defaultSettings.put(EventType.CROUCH_JUMP, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("swimming", List.of(TagBuilder.start().withString("perk", "pmmo:breath").build(), TagBuilder.start().withString("perk", "pmmo:night_vision").build()));
        defaultSettings.put(EventType.SUBMERGED, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("agility", List.of(TagBuilder.start().withString("perk", "pmmo:fall_save").withDouble("per_level", 0.005).build()));
        bodyMap.put("endurance", List.of(TagBuilder.start().withString("perk", "pmmo:fall_save").withDouble("per_level", 0.025).build()));
        defaultSettings.put(EventType.FROM_IMPACT, bodyMap);
        bodyMap = new HashMap();
        bodyMap.put("archery", List.of(TagBuilder.start().withString("perk", "pmmo:damage_boost").withList("applies_to", new Tag[]{StringTag.m_129297_((String)"minecraft:bow"), StringTag.m_129297_((String)"minecraft:crossbow"), StringTag.m_129297_((String)"minecraft:trident")}).build()));
        bodyMap.put("magic", List.of(TagBuilder.start().withString("perk", "pmmo:damage_boost").withList("applies_to", new Tag[]{StringTag.m_129297_((String)"ars_nouveau:spell_bow")}).build()));
        bodyMap.put("gunslinging", List.of(TagBuilder.start().withString("perk", "pmmo:damage_boost").withList("applies_to", new Tag[]{StringTag.m_129297_((String)"cgm:pistol"), StringTag.m_129297_((String)"cgm:shotgun"), StringTag.m_129297_((String)"cgm:rifle")}).build()));
        defaultSettings.put(EventType.DEAL_RANGED_DAMAGE, bodyMap);
        defaultSettings.put(EventType.RANGED_TO_MOBS, bodyMap);
    }

    static {
        CODEC = Codec.unboundedMap(EventType.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.f_128325_.listOf()));
        PerksConfig.generateDefaults();
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        PerksConfig.buildPerkSettings(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

