/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.writers;

import com.google.common.collect.Comparators;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.util.MsLoggy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class DataMigrator {
    private static final String PACKNAME = "migration_pack";
    private static final String LEGACYDIR = "pmmo";
    private static final Type mapType = new TypeToken<Map<String, Map<String, Double>>>(){}.getType();
    private static final Type mapType2 = new TypeToken<Map<String, Map<String, Map<String, Double>>>>(){}.getType();
    private static final Map<ObjectType, Map<ResourceLocation, ObjectData>> objects = new HashMap<ObjectType, Map<ResourceLocation, ObjectData>>();
    private static final Map<ObjectType, Map<ResourceLocation, LocationData>> locations = new HashMap<ObjectType, Map<ResourceLocation, LocationData>>();
    private static final Map<ResourceLocation, EnhancementsData> enchants = new HashMap<ResourceLocation, EnhancementsData>();
    private static final TriConsumer<JType, String, Map<?, ?>> ITEM_PROCESSOR = (type, rl, data) -> {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(rl.substring(1)));
        List<ResourceLocation> objectIDs = rl.contains("#") ? ForgeRegistries.ITEMS.tags().getTag(tag).stream().map(item -> ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)).toList() : List.of(new ResourceLocation(rl));
        for (ResourceLocation objectID : objectIDs) {
            switch (type) {
                case REQ_WEAR: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.WEAR, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case REQ_TOOL: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.TOOL, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case REQ_WEAPON: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.WEAPON, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case REQ_USE: {
                    Map<String, Integer> mappedRaws = DataMigrator.remapInt(data);
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.USE, mappedRaws, ReqType.INTERACT, mappedRaws)).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_CRAFT: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.CRAFT, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_SMELT: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.SMELT, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_COOK: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.SMELT, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_BREW: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.BREW, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_RIGHT_CLICK: {
                    Map<String, Long> remappedData = DataMigrator.remapLong(data);
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.ACTIVATE_ITEM, remappedData, EventType.ACTIVATE_BLOCK, remappedData)).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_BONUS_HELD: {
                    ObjectData raw = ObjectData.Builder.start().bonus(Map.of(ModifierDataType.HELD, DataMigrator.remapDouble(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_BONUS_WORN: {
                    ObjectData raw = ObjectData.Builder.start().bonus(Map.of(ModifierDataType.WORN, DataMigrator.remapDouble(data))).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case SALVAGE: {
                    ObjectData remappedRaws = ObjectData.Builder.start().salvage(DataMigrator.remapSalvage(data)).build();
                    objects.computeIfAbsent(ObjectType.ITEM, a -> new HashMap()).merge(objectID, remappedRaws, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
            }
        }
    };
    private static final TriConsumer<JType, String, Map<?, ?>> BLOCK_PROCESSOR = (type, rl, data) -> {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation(rl.substring(1)));
        List<ResourceLocation> objectIDs = rl.contains("#") ? ForgeRegistries.BLOCKS.tags().getTag(tag).stream().map(item -> ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)item)).toList() : List.of(new ResourceLocation(rl));
        for (ResourceLocation objectID : objectIDs) {
            switch (type) {
                case REQ_BREAK: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.BREAK, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.BLOCK, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case REQ_PLACE: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.PLACE, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.BLOCK, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_BREAK: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.BLOCK_BREAK, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.BLOCK, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_PLACE: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.BLOCK_PLACE, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.BLOCK, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_GROW: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.GROW, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.BLOCK, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
            }
        }
    };
    private static final TriConsumer<JType, String, Map<?, ?>> ENTITY_PROCESSOR = (type, rl, data) -> {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITIES.getRegistryKey(), (ResourceLocation)new ResourceLocation(rl.substring(1)));
        List<ResourceLocation> objectIDs = rl.contains("#") ? ForgeRegistries.ENTITIES.tags().getTag(tag).stream().map(item -> ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)item)).toList() : List.of(new ResourceLocation(rl));
        for (ResourceLocation objectID : objectIDs) {
            switch (type) {
                case REQ_KILL: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.KILL, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.ENTITY, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case REQ_ENTITY_INTERACT: {
                    ObjectData raw = ObjectData.Builder.start().reqs(Map.of(ReqType.ENTITY_INTERACT, DataMigrator.remapInt(data))).build();
                    objects.computeIfAbsent(ObjectType.ENTITY, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_BREED: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.BREED, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ENTITY, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_TAME: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.TAMING, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ENTITY, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
                case XP_VALUE_KILL: {
                    ObjectData raw = ObjectData.Builder.start().xpValues(Map.of(EventType.DEATH, DataMigrator.remapLong(data))).build();
                    objects.computeIfAbsent(ObjectType.ENTITY, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((ObjectData)ng));
                    break;
                }
            }
        }
    };
    private static final TriConsumer<JType, String, Map<?, ?>> DIMENSION_PROCESSOR = (type, rl, data) -> {
        switch (type) {
            case REQ_DIMENSION_TRAVEL: {
                LocationData raw = LocationData.Builder.start().req(DataMigrator.remapInt(data)).build();
                locations.computeIfAbsent(ObjectType.DIMENSION, a -> new HashMap()).merge(new ResourceLocation(rl), raw, (og, ng) -> og.combine((LocationData)ng));
                break;
            }
            case XP_BONUS_DIMENSION: {
                LocationData raw = LocationData.Builder.start().bonus(Map.of(ModifierDataType.DIMENSION, DataMigrator.remapDouble(data))).build();
                locations.computeIfAbsent(ObjectType.DIMENSION, a -> new HashMap()).merge(new ResourceLocation(rl), raw, (og, ng) -> og.combine((LocationData)ng));
                break;
            }
            case VEIN_BLACKLIST: {
                LocationData raw = LocationData.Builder.start().veinBlacklist(DataMigrator.remapVein(data)).build();
                locations.computeIfAbsent(ObjectType.DIMENSION, a -> new HashMap()).merge(new ResourceLocation(rl), raw, (og, ng) -> og.combine((LocationData)ng));
                break;
            }
        }
    };
    private static final TriConsumer<JType, String, Map<?, ?>> BIOME_PROCESSOR = (type, rl, data) -> {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(rl.substring(1)));
        List<ResourceLocation> objectIDs = rl.contains("#") ? ForgeRegistries.BIOMES.tags().getTag(tag).stream().map(item -> ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)item)).toList() : List.of(new ResourceLocation(rl));
        for (ResourceLocation objectID : objectIDs) {
            switch (type) {
                case REQ_BIOME: {
                    LocationData raw = LocationData.Builder.start().req(DataMigrator.remapInt(data)).build();
                    locations.computeIfAbsent(ObjectType.BIOME, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((LocationData)ng));
                    break;
                }
                case BIOME_EFFECT_POSITIVE: {
                    LocationData raw = LocationData.Builder.start().positive(DataMigrator.remapInt(data).entrySet().stream().collect(Collectors.toMap(entry -> new ResourceLocation((String)entry.getKey()), entry -> (Integer)entry.getValue()))).build();
                    locations.computeIfAbsent(ObjectType.BIOME, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((LocationData)ng));
                    break;
                }
                case BIOME_EFFECT_NEGATIVE: {
                    LocationData raw = LocationData.Builder.start().negative(DataMigrator.remapInt(data).entrySet().stream().collect(Collectors.toMap(entry -> new ResourceLocation((String)entry.getKey()), entry -> (Integer)entry.getValue()))).build();
                    locations.computeIfAbsent(ObjectType.BIOME, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((LocationData)ng));
                    break;
                }
                case XP_BONUS_BIOME: {
                    LocationData raw = LocationData.Builder.start().bonus(Map.of(ModifierDataType.BIOME, DataMigrator.remapDouble(data))).build();
                    locations.computeIfAbsent(ObjectType.BIOME, a -> new HashMap()).merge(objectID, raw, (og, ng) -> og.combine((LocationData)ng));
                    break;
                }
            }
        }
    };

    public static boolean shouldMigrate(MinecraftServer server) {
        return !server.m_129843_(LevelResource.f_78180_).resolve(PACKNAME).toFile().exists() && FMLPaths.CONFIGDIR.get().resolve(LEGACYDIR).toFile().exists();
    }

    public static boolean shouldConfigsClone() {
        return !FMLPaths.CONFIGDIR.get().resolve("pmmo-common-legacy.toml").toFile().exists();
    }

    private static Map<String, Integer> remapInt(Map<?, ?> data) {
        return data.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> Double.valueOf(entry.getValue().toString()).intValue()));
    }

    private static Map<String, Long> remapLong(Map<?, ?> data) {
        return data.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> Double.valueOf(entry.getValue().toString()).longValue()));
    }

    private static Map<String, Double> remapDouble(Map<?, ?> data) {
        return data.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> Double.valueOf(entry.getValue().toString())));
    }

    private static Map<ResourceLocation, CodecTypes.SalvageData> remapSalvage(Map<?, ?> data) {
        Map<String, Map> mappedRaws = data.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> Double.valueOf(e.getValue().toString())))));
        HashMap<ResourceLocation, CodecTypes.SalvageData> outData = new HashMap<ResourceLocation, CodecTypes.SalvageData>();
        mappedRaws.forEach((key, value) -> outData.put(new ResourceLocation(key), CodecTypes.SalvageData.migrate(value)));
        return outData;
    }

    private static List<ResourceLocation> remapVein(Map<?, ?> data) {
        return data.keySet().stream().map(key -> new ResourceLocation(key.toString())).toList();
    }

    private static Map<Integer, Map<String, Integer>> remapEnchant(Map<?, ?> data) {
        Map<Integer, Map> typeCastMap = data.entrySet().stream().collect(Collectors.toMap(entry -> Double.valueOf(entry.getKey().toString()).intValue(), entry -> DataMigrator.remapInt((Map)entry.getValue())));
        int maxConfigured = typeCastMap.keySet().stream().max(Comparators::max).orElse(-1);
        HashMap<Integer, Map<String, Integer>> outMap = new HashMap<Integer, Map<String, Integer>>();
        for (int i = 0; i <= maxConfigured; ++i) {
            Map innerMap = typeCastMap.get(i);
            outMap.put(i, innerMap == null ? new HashMap() : innerMap);
        }
        return outMap;
    }

    public static void generateMigrationPack(MinecraftServer server) {
        JsonElement data;
        Gson gson = new Gson();
        Path filepath = server.m_129843_(LevelResource.f_78180_).resolve(PACKNAME);
        filepath.toFile().mkdirs();
        try {
            Files.write(filepath.resolve("pack.mcmeta"), List.of("{", "\"pack\":{\"description\":\"PMMO Lecacy to Rework Migration Pack\",", "\"pack_format\":9},", "\"filter\":{\"block\":[{\"path\":\"pmmo\"}]}", "}"), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            System.out.println("Error While Generating pack.mcmeta for Generated Data: " + e.toString());
        }
        for (JType jtype : JType.values()) {
            Map rawMap;
            String fileName = jtype.name().toLowerCase() + ".json";
            File file = FMLPaths.CONFIGDIR.get().resolve("pmmo/" + fileName).toFile();
            try (FileInputStream input = new FileInputStream(file.getPath());
                 BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                rawMap = (Map)gson.fromJson((Reader)reader, jtype.type);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (rawMap == null) {
                return;
            }
            for (Map.Entry id : rawMap.entrySet()) {
                System.out.println("key:" + id.getKey().toString() + " Value:" + MsLoggy.mapToString((Map)id.getValue()));
                jtype.obj.processor.accept((Object)jtype, (Object)((String)id.getKey()), (Object)((Map)id.getValue()));
            }
        }
        for (Map.Entry entry : objects.entrySet()) {
            ObjectType type = (ObjectType)((Object)entry.getKey());
            System.out.println("Migration State: Objects Serialized" + ((Map)entry.getValue()).size());
            for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                data = (JsonElement)ObjectData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ObjectData)value.getValue())).resultOrPartial(str -> System.out.println((String)str)).get();
                DataMigrator.write((ResourceLocation)value.getKey(), data, type, filepath);
            }
        }
        for (Map.Entry entry : locations.entrySet()) {
            ObjectType type = (ObjectType)((Object)entry.getKey());
            System.out.println("Migration State: Locations Serialized" + ((Map)entry.getValue()).size());
            for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                data = (JsonElement)LocationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((LocationData)value.getValue())).resultOrPartial(str -> System.out.println((String)str)).get();
                DataMigrator.write((ResourceLocation)value.getKey(), data, type, filepath);
            }
        }
        System.out.println("Migration State: Enchants Serialized" + enchants.size());
        for (Map.Entry entry : enchants.entrySet()) {
            JsonElement data2 = (JsonElement)EnhancementsData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((EnhancementsData)entry.getValue())).resultOrPartial(str -> System.out.println((String)str)).get();
            DataMigrator.write((ResourceLocation)entry.getKey(), data2, ObjectType.ENCHANTMENT, filepath);
        }
        server.m_129892_().m_82117_(server.m_129893_(), "reload");
    }

    private static void write(ResourceLocation rl, JsonElement data, ObjectType type, Path filepath) {
        Path finalPath = filepath.resolve("data/" + rl.m_135827_() + type.path);
        finalPath.toFile().mkdirs();
        try {
            Files.write(finalPath.resolve(rl.m_135815_() + ".json"), List.of(data.toString()), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            System.out.println("Error While Generating Migration Pack File For: " + rl.toString() + " (" + e.toString() + ")");
        }
    }

    public static void cloneLegacyConfig() {
        try {
            FileUtils.copyFile((File)FMLPaths.CONFIGDIR.get().resolve("pmmo-common.toml").toFile(), (File)FMLPaths.CONFIGDIR.get().resolve("pmmo-common-legacy.toml").toFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static enum JType {
        REQ_WEAR(mapType, ObjectType.ITEM),
        REQ_USE_ENCHANTMENT(mapType2, ObjectType.ENCHANTMENT),
        REQ_TOOL(mapType, ObjectType.ITEM),
        REQ_WEAPON(mapType, ObjectType.ITEM),
        REQ_USE(mapType, ObjectType.ITEM),
        REQ_PLACE(mapType, ObjectType.BLOCK),
        REQ_BREAK(mapType, ObjectType.BLOCK),
        REQ_BIOME(mapType, ObjectType.BIOME),
        REQ_KILL(mapType, ObjectType.ENTITY),
        REQ_DIMENSION_TRAVEL(mapType, ObjectType.DIMENSION),
        XP_VALUE_BREAK(mapType, ObjectType.BLOCK),
        XP_VALUE_CRAFT(mapType, ObjectType.ITEM),
        XP_VALUE_PLACE(mapType, ObjectType.BLOCK),
        XP_VALUE_BREED(mapType, ObjectType.ENTITY),
        XP_VALUE_TAME(mapType, ObjectType.ENTITY),
        XP_VALUE_KILL(mapType, ObjectType.ENTITY),
        XP_VALUE_SMELT(mapType, ObjectType.ITEM),
        XP_VALUE_COOK(mapType, ObjectType.ITEM),
        XP_VALUE_BREW(mapType, ObjectType.ITEM),
        XP_VALUE_GROW(mapType, ObjectType.BLOCK),
        XP_VALUE_RIGHT_CLICK(mapType, ObjectType.ITEM),
        BIOME_EFFECT_NEGATIVE(mapType, ObjectType.BIOME),
        BIOME_EFFECT_POSITIVE(mapType, ObjectType.BIOME),
        XP_BONUS_BIOME(mapType, ObjectType.BIOME),
        XP_BONUS_HELD(mapType, ObjectType.ITEM),
        XP_BONUS_WORN(mapType, ObjectType.ITEM),
        XP_BONUS_DIMENSION(mapType, ObjectType.DIMENSION),
        VEIN_BLACKLIST(mapType, ObjectType.DIMENSION),
        REQ_ENTITY_INTERACT(mapType, ObjectType.ENTITY),
        SALVAGE(mapType2, ObjectType.ITEM);

        public Type type;
        public ObjectType obj;

        private JType(Type type, ObjectType obj) {
            this.type = type;
            this.obj = obj;
        }
    }

    private static enum ObjectType {
        ITEM("/pmmo/items/", ITEM_PROCESSOR),
        BLOCK("/pmmo/blocks/", BLOCK_PROCESSOR),
        ENTITY("/pmmo/entities/", ENTITY_PROCESSOR),
        DIMENSION("/pmmo/dimensions/", DIMENSION_PROCESSOR),
        BIOME("/pmmo/biomes/", BIOME_PROCESSOR),
        ENCHANTMENT("/pmmo/enchantments/", (type, rl, data) -> {
            switch (type) {
                case REQ_USE_ENCHANTMENT: {
                    EnhancementsData raw = EnhancementsData.Builder.start().skillArray(DataMigrator.remapEnchant(data)).build();
                    enchants.merge(new ResourceLocation(rl), raw, (og, ng) -> og.combine((EnhancementsData)ng));
                    break;
                }
            }
        });

        public String path;
        private TriConsumer<JType, String, Map<?, ?>> processor;

        private ObjectType(String path, TriConsumer<JType, String, Map<?, ?>> processor) {
            this.path = path;
            this.processor = processor;
        }
    }
}

