/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.writers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Reference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class PackGenerator {
    public static final String PACKNAME = "generated_pack";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static boolean applyOverride = false;
    public static boolean applyDefaults = false;
    public static boolean applyDisabler = false;
    public static boolean applySimple = false;
    public static List<String> namespaceFilter = new ArrayList<String>();
    public static Set<ServerPlayer> players = new HashSet<ServerPlayer>();
    private static final Filter defaultFilter = new Filter(List.of(new BlockFilter(Optional.empty(), Optional.of("pmmo"))));

    public static int generatePack(MinecraftServer server) {
        Path filepath = server.m_129843_(LevelResource.f_78180_).resolve(PACKNAME);
        filepath.toFile().mkdirs();
        Path packPath = filepath.resolve("pack.mcmeta");
        try {
            Files.writeString(packPath, (CharSequence)gson.toJson(PackGenerator.getPackObject(applyDisabler)), Charset.defaultCharset(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.out.println("Error While Generating pack.mcmeta for Generated Data: " + e.toString());
        }
        for (Category category : Category.values()) {
            List<ResourceLocation> filteredList = namespaceFilter.isEmpty() || category == Category.TAGS ? (List<ResourceLocation>)((Object)category.valueList.apply(server)) : category.valueList.apply(server).stream().filter(id -> namespaceFilter.contains(id.m_135827_())).toList();
            for (ResourceLocation id2 : filteredList) {
                int index = id2.m_135815_().lastIndexOf(47);
                String pathRoute = id2.m_135815_().substring(0, Math.max(index, 0));
                Path finalPath = filepath.resolve("data/" + id2.m_135827_() + "/" + category.route + "/" + pathRoute);
                finalPath.toFile().mkdirs();
                String extension = category.equals((Object)Category.FUNCTIONS) ? ".mcfunction" : ".json";
                try {
                    Files.writeString(finalPath.resolve(id2.m_135815_().substring(id2.m_135815_().lastIndexOf(47) + 1) + extension), (CharSequence)category.defaultData.apply(id2), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    System.out.println("Error While Generating Pack File For: " + id2.toString() + " (" + e.toString() + ")");
                }
            }
        }
        PackGenerator.generatePlayerConfigs(server, players);
        return 0;
    }

    public static int generatePlayerConfigs(MinecraftServer server, Collection<ServerPlayer> players) {
        Path filepath = server.m_129843_(LevelResource.f_78180_).resolve("generated_pack/data/minecraft/pmmo/players/");
        filepath.toFile().mkdirs();
        for (ServerPlayer player : players) {
            String idString = player.m_142081_().toString();
            try {
                Files.writeString(filepath.resolve(idString + ".json"), (CharSequence)gson.toJson((JsonElement)PlayerData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new PlayerData()).result().get()), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                System.out.println("Error While Generating Pack File For: " + idString.toString() + " (" + e.toString() + ")");
            }
        }
        return 0;
    }

    private static JsonElement getPackObject(boolean isDisabler) {
        McMeta pack = new McMeta(new Pack(isDisabler ? "Generated Resources including a disabler filter for PMMO's defaults" : "Generated Resources", 9), isDisabler ? Optional.of(defaultFilter) : Optional.empty());
        return (JsonElement)McMeta.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pack).result().get();
    }

    private static enum Category {
        ITEMS("pmmo/items", server -> ForgeRegistries.ITEMS.getKeys(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().ITEM_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.ITEM)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), applyDefaults ? existing.negativeEffects() : new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.ITEM)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(EventType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), Arrays.stream(new ModifierDataType[]{ModifierDataType.WORN, ModifierDataType.HELD}).collect(Collectors.toMap(m -> m, m -> applyDefaults ? (Map)existing.bonuses().getOrDefault(m, new HashMap()) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(new ModifierDataType[]{ModifierDataType.WORN, ModifierDataType.HELD}).collect(Collectors.toMap(m -> m, m -> applyDefaults ? (List)existing.nbtBonuses().getOrDefault(m, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, m -> (List)m.getValue())), applyDefaults ? existing.salvage() : Map.of(new ResourceLocation("modid:item"), APIUtils.SalvageBuilder.start().build()), applyDefaults ? existing.veinData() : VeinData.EMPTY);
            JsonObject raw = ((JsonElement)ObjectData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            return gson.toJson((JsonElement)raw);
        }),
        BLOCKS("pmmo/blocks", server -> ForgeRegistries.BLOCKS.getKeys(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().BLOCK_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.BLOCK)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.BLOCK)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(EventType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), applyDefaults ? existing.veinData() : new VeinData(Optional.empty(), Optional.empty(), Optional.of(1)));
            JsonObject raw = ((JsonElement)ObjectData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("negative_effect");
            raw.remove("bonuses");
            raw.remove("dealt_damage_xp");
            raw.remove("received_damage_xp");
            raw.remove("nbt_bonuses");
            raw.remove("salvage");
            return gson.toJson((JsonElement)raw);
        }),
        ENTITIES("pmmo/entities", server -> ForgeRegistries.ENTITIES.getKeys(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().ENTITY_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.ENTITY)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.ENTITY)) : new HashMap())).entrySet().stream().filter(entry -> applySimple && !((Map)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(EventType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> applySimple && !((List)entry.getValue()).isEmpty() || !applySimple).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
            JsonObject raw = ((JsonElement)ObjectData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("negative_effect");
            raw.remove("bonuses");
            raw.remove("nbt_bonuses");
            raw.remove("salvage");
            raw.remove("vein_data");
            return gson.toJson((JsonElement)raw);
        }),
        DIMENSIONS("pmmo/dimensions", server -> new HashSet<ResourceLocation>(server.m_129784_().stream().map(key -> key.m_135782_()).toList()), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            LocationData existing = core.getLoader().DIMENSION_LOADER.getData((ResourceLocation)id);
            LocationData data = new LocationData(applyOverride, new HashSet<String>(), applyDefaults ? existing.bonusMap() : Map.of(ModifierDataType.DIMENSION, new HashMap()), new HashMap<ResourceLocation, Integer>(), new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.veinBlacklist() : new ArrayList<ResourceLocation>(), applyDefaults ? existing.travelReq() : new HashMap<String, Integer>(), applyDefaults ? existing.mobModifiers() : new HashMap<ResourceLocation, Map<String, Double>>());
            JsonObject raw = ((JsonElement)LocationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("positive_effect");
            raw.remove("negative_effect");
            return gson.toJson((JsonElement)raw);
        }),
        BIOMES("pmmo/biomes", server -> server.m_206579_().m_175515_(BuiltinRegistries.f_123865_.m_123023_()).m_6566_(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            LocationData existing = core.getLoader().BIOME_LOADER.getData((ResourceLocation)id);
            LocationData data = new LocationData(applyOverride, new HashSet<String>(), applyDefaults ? existing.bonusMap() : Map.of(ModifierDataType.BIOME, new HashMap()), applyDefaults ? existing.positive() : new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.negative() : new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.veinBlacklist() : new ArrayList<ResourceLocation>(), applyDefaults ? existing.travelReq() : new HashMap<String, Integer>(), applyDefaults ? existing.mobModifiers() : new HashMap<ResourceLocation, Map<String, Double>>());
            JsonObject raw = ((JsonElement)LocationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            return gson.toJson((JsonElement)raw);
        }),
        ENCHANTMENTS("pmmo/enchantments", server -> ForgeRegistries.ENCHANTMENTS.getKeys(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            EnhancementsData existing = core.getLoader().ENCHANTMENT_LOADER.getData((ResourceLocation)id);
            return gson.toJson((JsonElement)EnhancementsData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new EnhancementsData(applyOverride, applyDefaults ? existing.skillArray() : new HashMap<Integer, Map<String, Integer>>())).result().get());
        }),
        EFFECTS("pmmo/effects", server -> ForgeRegistries.MOB_EFFECTS.getKeys(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            EnhancementsData existing = core.getLoader().EFFECT_LOADER.getData((ResourceLocation)id);
            return gson.toJson((JsonElement)EnhancementsData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new EnhancementsData(applyOverride, applyDefaults ? existing.skillArray() : new HashMap<Integer, Map<String, Integer>>())).result().get());
        }),
        TAGS("tags", server -> {
            HashSet<ResourceLocation> tags = new HashSet<ResourceLocation>(Set.of(Functions.pathPrepend(Reference.CROPS.f_203868_(), "blocks"), Functions.pathPrepend(Reference.CASCADING_BREAKABLES.f_203868_(), "blocks"), Functions.pathPrepend(Reference.ANIMAL_TAG.f_203868_(), "entity_types"), Functions.pathPrepend(Reference.BREEDABLE_TAG.f_203868_(), "entity_types"), Functions.pathPrepend(Reference.MOB_TAG.f_203868_(), "entity_types"), Functions.pathPrepend(Reference.RIDEABLE_TAG.f_203868_(), "entity_types"), Functions.pathPrepend(Reference.TAMABLE_TAG.f_203868_(), "entity_types"), Functions.pathPrepend(Reference.BREWABLES.f_203868_(), "items"), Functions.pathPrepend(Reference.SMELTABLES.f_203868_(), "items")));
            if (applyDisabler) {
                tags.add(new ResourceLocation("minecraft:functions/load"));
            }
            return tags;
        }, id -> id.equals((Object)new ResourceLocation("minecraft:functions/load")) ? gson.toJson((JsonElement)Tag.Builder.m_13304_().m_13327_(new ResourceLocation("pmmo:disable"), "disabler").m_13334_()) : gson.toJson((JsonElement)Tag.Builder.m_13304_().m_13334_())),
        FUNCTIONS("functions", server -> applyDisabler ? Set.of(new ResourceLocation("pmmo:disable")) : Set.of(), id -> "datapack disable \"mod:pmmo\"");

        public String route;
        public Function<MinecraftServer, Set<ResourceLocation>> valueList;
        private Function<ResourceLocation, String> defaultData;

        private Category(String route, Function<MinecraftServer, Set<ResourceLocation>> values, Function<ResourceLocation, String> defaultData) {
            this.route = route;
            this.valueList = values;
            this.defaultData = defaultData;
        }
    }

    private record McMeta(Pack pack, Optional<Filter> filter) {
        public static final Codec<McMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Pack.CODEC.fieldOf("pack").forGetter(McMeta::pack), (App)Filter.CODEC.optionalFieldOf("filter").forGetter(McMeta::filter)).apply((Applicative)instance, McMeta::new));
    }

    private record Pack(String description, int format) {
        public static final Codec<Pack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(Pack::description), (App)Codec.INT.fieldOf("pack_format").forGetter(Pack::format)).apply((Applicative)instance, Pack::new));
    }

    private record Filter(List<BlockFilter> block) {
        public static final Codec<Filter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockFilter.CODEC.listOf().fieldOf("block").forGetter(Filter::block)).apply((Applicative)instance, Filter::new));
    }

    private record BlockFilter(Optional<String> namespace, Optional<String> path) {
        public static final Codec<BlockFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("namespace").forGetter(BlockFilter::namespace), (App)Codec.STRING.optionalFieldOf("path").forGetter(BlockFilter::path)).apply((Applicative)instance, BlockFilter::new));
    }
}

