/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.compat.curios.CurioCompat;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.config.readers.CoreLoader;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_ClearData;
import harmonised.pmmo.registry.EventTriggerRegistry;
import harmonised.pmmo.registry.LevelRegistry;
import harmonised.pmmo.registry.PerkRegistry;
import harmonised.pmmo.registry.PredicateRegistry;
import harmonised.pmmo.registry.TooltipRegistry;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.PmmoSavedData;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Core {
    private static final Map<LogicalSide, Function<LogicalSide, Core>> INSTANCES = Map.of(LogicalSide.CLIENT, Functions.memoize(Core::new), LogicalSide.SERVER, Functions.memoize(Core::new));
    private final CoreLoader loader;
    private final PredicateRegistry predicates;
    private final EventTriggerRegistry eventReg;
    private final TooltipRegistry tooltips;
    private final PerkRegistry perks;
    private final LevelRegistry lvlProvider;
    private final IDataStorage data;
    private final LogicalSide side;
    private ResourceLocation playerID = new ResourceLocation("player");
    private final Map<UUID, BlockPos> markers = new HashMap<UUID, BlockPos>();

    private Core(LogicalSide side) {
        this.loader = new CoreLoader();
        this.predicates = new PredicateRegistry();
        this.eventReg = new EventTriggerRegistry();
        this.tooltips = new TooltipRegistry();
        this.perks = new PerkRegistry();
        this.lvlProvider = new LevelRegistry();
        this.data = side.equals((Object)LogicalSide.SERVER) ? new PmmoSavedData() : new DataMirror();
        this.side = side;
    }

    public static Core get(LogicalSide side) {
        return INSTANCES.get(side).apply(side);
    }

    public static Core get(Level level) {
        return Core.get(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    public void resetDataForReload() {
        this.tooltips.clearRegistry();
        if (this.side.equals((Object)LogicalSide.SERVER)) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return;
            }
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                Networking.sendToClient(new CP_ClearData(), player);
            }
        }
    }

    public CoreLoader getLoader() {
        return this.loader;
    }

    public PredicateRegistry getPredicateRegistry() {
        return this.predicates;
    }

    public EventTriggerRegistry getEventTriggerRegistry() {
        return this.eventReg;
    }

    public TooltipRegistry getTooltipRegistry() {
        return this.tooltips;
    }

    public PerkRegistry getPerkRegistry() {
        return this.perks;
    }

    public LevelRegistry getLevelProvider() {
        return this.lvlProvider;
    }

    public IDataStorage getData() {
        return this.data.get();
    }

    public LogicalSide getSide() {
        return this.side;
    }

    public void awardXP(List<ServerPlayer> players, Map<String, Long> xpValues) {
        CoreUtils.processSkillGroupXP(xpValues);
        new HashMap<String, Long>(xpValues).forEach((skill, value) -> xpValues.put((String)skill, (long)((double)value.longValue() * Config.SKILL_MODIFIERS.get().getOrDefault(skill, (Double)Config.GLOBAL_MODIFIER.get()))));
        for (int i = 0; i < players.size(); ++i) {
            if (players.get(i) instanceof FakePlayer || players.get(i).m_21224_()) continue;
            for (Map.Entry<String, Long> award : xpValues.entrySet()) {
                long xpAward = award.getValue();
                if (players.size() > 1) {
                    xpAward = Double.valueOf((double)xpAward * ((Double)Config.PARTY_BONUS.get() * (double)players.size())).longValue();
                }
                this.getData().setXpDiff(players.get(i).m_142081_(), award.getKey(), xpAward / (long)players.size());
            }
        }
    }

    public Map<String, Long> getExperienceAwards(EventType type, ItemStack stack, Player player, CompoundTag dataIn) {
        ResourceLocation itemID = RegistryUtil.getId(stack);
        dataIn.m_128391_(TagUtils.stackTag(stack));
        HashMap<String, Long> xpGains = this.tooltips.xpGainTooltipExists(itemID, type) ? this.tooltips.getItemXpGainTooltipData(itemID, type, stack) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, itemID, player, ObjectType.ITEM, dataIn);
    }

    public Map<String, Long> getExperienceAwards(MobEffectInstance mei, Player player, CompoundTag dataIn) {
        ResourceLocation effectID = RegistryUtil.getId(mei.m_19544_());
        EnhancementsData data = (EnhancementsData)this.loader.getLoader(ObjectType.EFFECT).getData().get(effectID);
        HashMap<String, Long> xpGains = new HashMap<String, Long>();
        if (data != null) {
            ((Map)data.skillArray().getOrDefault(mei.m_19564_() + 1, new HashMap())).forEach((skill, value) -> xpGains.put((String)skill, value.longValue()));
        }
        return this.getCommonXpAwardData(xpGains, EventType.EFFECT, effectID, player, ObjectType.EFFECT, dataIn);
    }

    public Map<String, Long> getExperienceAwards(EventType type, BlockPos pos, Level level, Player player, CompoundTag dataIn) {
        ResourceLocation res = RegistryUtil.getId(level.m_8055_(pos));
        BlockEntity tile = level.m_7702_(pos);
        dataIn.m_128391_(TagUtils.tileTag(tile));
        dataIn.m_128365_("state", (Tag)TagUtils.stateTag(level.m_8055_(pos)));
        HashMap<String, Long> xpGains = tile != null && this.tooltips.xpGainTooltipExists(res, type) ? this.tooltips.getBlockXpGainTooltipData(res, type, tile) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, res, player, ObjectType.BLOCK, dataIn);
    }

    public Map<String, Long> getExperienceAwards(EventType type, Entity entity, Player player, CompoundTag dataIn) {
        ResourceLocation entityID = entity.m_6095_().equals(EntityType.f_20532_) ? this.playerID : RegistryUtil.getId(entity);
        dataIn.m_128391_(TagUtils.entityTag(entity));
        HashMap<String, Long> xpGains = this.tooltips.xpGainTooltipExists(entityID, type) ? this.tooltips.getEntityXpGainTooltipData(entityID, type, entity) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, entityID, player, ObjectType.ENTITY, dataIn);
    }

    public Map<String, Long> getCommonXpAwardData(Map<String, Long> xpGains, EventType type, ResourceLocation objectID, Player player, ObjectType oType, CompoundTag tag) {
        if (xpGains.isEmpty()) {
            xpGains = CoreUtils.mergeXpMapsWithSummateCondition(tag.m_128441_("serialized_award_map") ? CoreUtils.deserializeAwardMap(tag.m_128469_("serialized_award_map")) : new HashMap(), this.getObjectExperienceMap(oType, objectID, type, tag));
            if (((Boolean)AutoValueConfig.ENABLE_AUTO_VALUES.get()).booleanValue() && xpGains.isEmpty()) {
                xpGains = AutoValues.getExperienceAward(type, objectID, oType);
            }
        }
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.XP, "XpGains: " + MsLoggy.mapToString(xpGains), new Object[0]);
        if (player != null && !(player instanceof FakePlayer)) {
            CoreUtils.applyXpModifiers(xpGains, this.getConsolidatedModifierMap(player));
        }
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.XP, "XpGains (afterBonus): " + MsLoggy.mapToString(xpGains), new Object[0]);
        CheeseTracker.applyAntiCheese(type, objectID, player, xpGains);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.XP, "XpGains (afterCheese): " + MsLoggy.mapToString(xpGains), new Object[0]);
        return xpGains;
    }

    public Map<String, Long> getObjectExperienceMap(ObjectType type, ResourceLocation objectID, EventType eventType, CompoundTag tag) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Long>(data != null ? MsLoggy.DEBUG.logAndReturn(data.getXpValues(eventType, tag), MsLoggy.LOG_CODE.DATA, "getObjectExperienceMap= {}", new Object[0]) : new HashMap());
    }

    public Map<String, Double> getObjectModifierMap(ObjectType type, ResourceLocation objectID, ModifierDataType modifierType, CompoundTag tag) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Double>(data != null ? data.getBonuses(modifierType, tag) : new HashMap());
    }

    public Map<String, Double> getConsolidatedModifierMap(Player player) {
        HashMap<String, Double> mapOut = new HashMap<String, Double>();
        if (player instanceof FakePlayer) {
            return mapOut;
        }
        ResourceLocation biomeID = RegistryUtil.getId((Holder<Biome>)player.m_183503_().m_204166_(player.m_142538_()));
        for (Map.Entry<String, Double> entry : this.getObjectModifierMap(ObjectType.BIOME, biomeID, ModifierDataType.BIOME, new CompoundTag()).entrySet()) {
            mapOut.merge(entry.getKey(), entry.getValue(), (o, n) -> o + (n - 1.0));
        }
        ResourceLocation dimensionID = player.m_183503_().m_46472_().m_135782_();
        for (Map.Entry<String, Double> entry : this.getObjectModifierMap(ObjectType.DIMENSION, dimensionID, ModifierDataType.DIMENSION, new CompoundTag()).entrySet()) {
            mapOut.merge(entry.getKey(), entry.getValue(), (o, n) -> o + (n - 1.0));
        }
        HashMap hashMap = new HashMap();
        for (ItemStack stack2 : List.of(player.m_21206_(), player.m_21205_())) {
            ResourceLocation itemID = RegistryUtil.getId(stack2);
            Map<String, Double> map = this.tooltips.bonusTooltipExists(itemID, ModifierDataType.HELD) ? this.tooltips.getBonusTooltipData(itemID, ModifierDataType.HELD, stack2) : this.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.HELD, TagUtils.stackTag(stack2));
            for (Map.Entry<String, Double> modMap : map.entrySet()) {
                mapOut.merge(modMap.getKey(), modMap.getValue(), (o, n) -> o + (n - 1.0));
            }
        }
        ArrayList arrayList = new ArrayList();
        player.m_6168_().forEach(arrayList::add);
        if (CurioCompat.hasCurio) {
            CurioCompat.getItems(player).forEach(arrayList::add);
        }
        arrayList.forEach(stack -> {
            ResourceLocation itemID = RegistryUtil.getId(stack);
            Map<String, Double> modifers = this.tooltips.bonusTooltipExists(itemID, ModifierDataType.WORN) ? this.tooltips.getBonusTooltipData(itemID, ModifierDataType.WORN, (ItemStack)stack) : this.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.WORN, stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_());
            for (Map.Entry<String, Double> modMap : modifers.entrySet()) {
                mapOut.merge(modMap.getKey(), modMap.getValue(), (o, n) -> o + (n - 1.0));
            }
        });
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Modifier Map: {}", MsLoggy.mapToString(mapOut));
        return this.loader.PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).mergeWithPlayerBonuses(CoreUtils.processSkillGroupBonus(mapOut));
    }

    public boolean isActionPermitted(ReqType type, ItemStack stack, Player player) {
        if (player instanceof FakePlayer || !((Boolean)Config.reqEnabled(type).get()).booleanValue() || this.getLoader().PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).ignoreReq()) {
            return true;
        }
        ResourceLocation itemID = RegistryUtil.getId(stack.m_41720_());
        return this.predicates.predicateExists(itemID, type) ? this.predicates.checkPredicateReq(player, stack, type) : this.doesPlayerMeetReq(player.m_142081_(), this.getReqMap(type, stack));
    }

    public boolean isActionPermitted(ReqType type, BlockPos pos, Player player) {
        if (player instanceof FakePlayer || !((Boolean)Config.reqEnabled(type).get()).booleanValue() || this.getLoader().PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).ignoreReq()) {
            return true;
        }
        BlockEntity tile = player.m_183503_().m_7702_(pos);
        ResourceLocation res = RegistryUtil.getId(player.m_183503_().m_8055_(pos));
        return tile != null && this.predicates.predicateExists(res, type) ? this.predicates.checkPredicateReq(player, tile, type) : this.doesPlayerMeetReq(player.m_142081_(), this.getReqMap(type, pos, player.m_183503_()));
    }

    public boolean isActionPermitted(ReqType type, Entity entity, Player player) {
        if (player instanceof FakePlayer || !((Boolean)Config.reqEnabled(type).get()).booleanValue() || this.getLoader().PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).ignoreReq()) {
            return true;
        }
        ResourceLocation entityID = entity.m_6095_().equals(EntityType.f_20532_) ? this.playerID : RegistryUtil.getId(entity);
        return this.predicates.predicateExists(entityID, type) ? this.predicates.checkPredicateReq(player, entity, type) : this.doesPlayerMeetReq(player.m_142081_(), this.getReqMap(type, entity));
    }

    public boolean isActionPermitted(ReqType type, Holder<Biome> biome, Player player) {
        if (type != ReqType.TRAVEL) {
            return false;
        }
        if (player instanceof FakePlayer || !((Boolean)Config.reqEnabled(type).get()).booleanValue() || this.getLoader().PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).ignoreReq()) {
            return true;
        }
        return this.doesPlayerMeetReq(player.m_142081_(), this.getObjectSkillMap(ObjectType.BIOME, RegistryUtil.getId(biome), type, new CompoundTag()));
    }

    public boolean isActionPermitted(ReqType type, ResourceKey<Level> dimension, Player player) {
        if (type != ReqType.TRAVEL) {
            return false;
        }
        if (player instanceof FakePlayer || !((Boolean)Config.reqEnabled(type).get()).booleanValue() || this.getLoader().PLAYER_LOADER.getData(new ResourceLocation(player.m_142081_().toString())).ignoreReq()) {
            return true;
        }
        return this.doesPlayerMeetReq(player.m_142081_(), this.getObjectSkillMap(ObjectType.DIMENSION, dimension.m_135782_(), type, new CompoundTag()));
    }

    public boolean doesPlayerMeetReq(UUID playerID, Map<String, Integer> requirements) {
        CoreUtils.processSkillGroupReqs(requirements);
        for (Map.Entry<String, Integer> req : requirements.entrySet()) {
            int skillLevel = this.getData().getPlayerSkillLevel(req.getKey(), playerID);
            if (SkillsConfig.SKILLS.get().getOrDefault(req.getKey(), SkillData.Builder.getDefault()).isSkillGroup()) {
                SkillData skillData = SkillsConfig.SKILLS.get().get(req.getKey());
                if (!skillData.getUseTotalLevels()) continue;
                int total = skillData.getGroup().keySet().stream().map(skill -> this.getData().getPlayerSkillLevel((String)skill, playerID)).collect(Collectors.summingInt(Integer::intValue));
                if (req.getValue() <= total) continue;
                return false;
            }
            if (req.getValue() <= skillLevel) continue;
            return false;
        }
        return true;
    }

    public Map<String, Integer> getObjectSkillMap(ObjectType type, ResourceLocation objectID, ReqType reqType, CompoundTag nbt) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Integer>(data != null ? data.getReqs(reqType, nbt) : new HashMap());
    }

    public Map<String, Integer> getReqMap(ReqType reqType, ItemStack stack) {
        HashMap<String, Integer> reqMap;
        ResourceLocation itemID = RegistryUtil.getId(stack);
        Map<Object, Object> map = reqMap = reqType == ReqType.USE_ENCHANTMENT ? this.getEnchantReqs(stack) : new HashMap();
        if (this.tooltips.requirementTooltipExists(itemID, reqType)) {
            this.tooltips.getItemRequirementTooltipData(itemID, reqType, stack).forEach((skill, lvl) -> reqMap.merge((String)skill, (Integer)lvl, (o, n) -> o > n ? o : n));
        }
        return this.getCommonReqData(reqMap, ObjectType.ITEM, itemID, reqType, TagUtils.stackTag(stack));
    }

    public Map<String, Integer> getEnchantReqs(ItemStack stack) {
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        if (!stack.m_41793_() || !((Boolean)Config.reqEnabled(ReqType.USE_ENCHANTMENT).get()).booleanValue()) {
            return outMap;
        }
        for (Map.Entry enchant : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            this.getEnchantmentReqs(RegistryUtil.getId((Enchantment)enchant.getKey()), (Integer)enchant.getValue()).forEach((skill, level) -> outMap.merge((String)skill, (Integer)level, (o, n) -> o > n ? o : n));
        }
        return outMap;
    }

    public Map<String, Integer> getReqMap(ReqType reqType, Entity entity) {
        ResourceLocation entityID = entity.m_6095_().equals(EntityType.f_20532_) ? new ResourceLocation("minecraft:player") : RegistryUtil.getId(entity);
        HashMap<String, Integer> reqMap = this.tooltips.requirementTooltipExists(entityID, reqType) ? this.tooltips.getEntityRequirementTooltipData(entityID, reqType, entity) : new HashMap<String, Integer>();
        return this.getCommonReqData(reqMap, ObjectType.ENTITY, entityID, reqType, TagUtils.entityTag(entity));
    }

    public Map<String, Integer> getReqMap(ReqType reqType, BlockPos pos, Level level) {
        BlockEntity tile = level.m_7702_(pos);
        ResourceLocation blockID = RegistryUtil.getId(level.m_8055_(pos));
        HashMap<String, Integer> reqMap = tile != null && this.tooltips.requirementTooltipExists(blockID, reqType) ? this.tooltips.getBlockRequirementTooltipData(blockID, reqType, tile) : new HashMap<String, Integer>();
        CompoundTag dataIn = TagUtils.tileTag(tile);
        dataIn.m_128365_("state", (Tag)TagUtils.stateTag(level.m_8055_(pos)));
        return this.getCommonReqData(reqMap, ObjectType.BLOCK, blockID, reqType, dataIn);
    }

    public Map<String, Integer> getCommonReqData(Map<String, Integer> reqsIn, ObjectType oType, ResourceLocation objectID, ReqType type, CompoundTag tag) {
        if (reqsIn.isEmpty()) {
            reqsIn = this.getObjectSkillMap(oType, objectID, type, tag);
            if (((Boolean)AutoValueConfig.ENABLE_AUTO_VALUES.get()).booleanValue() && reqsIn.isEmpty()) {
                reqsIn = AutoValues.getRequirements(type, objectID, oType);
            }
        }
        return CoreUtils.processSkillGroupReqs(reqsIn);
    }

    public Map<String, Integer> getEnchantmentReqs(ResourceLocation enchantID, int enchantLvl) {
        return ((EnhancementsData)this.loader.getLoader(ObjectType.ENCHANTMENT).getData(enchantID)).skillArray().getOrDefault(enchantLvl, new HashMap());
    }

    public void getSalvage(ServerPlayer player) {
        ItemStack salvageItem;
        boolean salvageOffHand;
        boolean salvageMainHand = !player.m_21205_().m_41619_();
        boolean bl = salvageOffHand = !salvageMainHand && !player.m_21206_().m_41619_();
        ItemStack itemStack = salvageMainHand ? player.m_21205_() : (salvageItem = salvageOffHand ? player.m_21206_() : ItemStack.f_41583_);
        if (salvageItem == ItemStack.f_41583_ || salvageItem.m_150930_(Items.f_41852_)) {
            return;
        }
        if (!this.loader.ITEM_LOADER.getData().containsKey(RegistryUtil.getId(salvageItem))) {
            return;
        }
        Map<String, Long> playerXp = this.getData().getXpMap(player.m_142081_());
        HashMap<String, Long> xpAwards = new HashMap<String, Long>();
        boolean validAttempt = false;
        block0: for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> result : this.loader.ITEM_LOADER.getData(RegistryUtil.getId(salvageItem)).salvage().entrySet()) {
            for (Map.Entry<String, Integer> skill : result.getValue().levelReq().entrySet()) {
                if (skill.getValue() <= Core.get(LogicalSide.SERVER).getData().getLevelFromXP(playerXp.getOrDefault(skill.getKey(), 0L))) continue;
                continue block0;
            }
            validAttempt = true;
            double base = result.getValue().baseChance();
            double max = result.getValue().maxChance();
            double bonus = 0.0;
            for (Map.Entry<String, Double> skill : result.getValue().chancePerLevel().entrySet()) {
                bonus += skill.getValue() * (double)Core.get(LogicalSide.SERVER).getData().getLevelFromXP(playerXp.getOrDefault(skill.getKey(), 0L));
            }
            for (int i = 0; i < result.getValue().salvageMax(); ++i) {
                if (!(player.m_21187_().nextDouble() < Math.min(max, base + bonus))) continue;
                player.m_7197_(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(result.getKey())), false, true);
                for (Map.Entry<String, Long> award : result.getValue().xpAward().entrySet()) {
                    xpAwards.merge(award.getKey(), award.getValue(), (o, n) -> o + n);
                }
            }
        }
        if (validAttempt) {
            if (salvageMainHand) {
                player.m_21205_().m_41774_(1);
            }
            if (salvageOffHand) {
                player.m_21206_().m_41774_(1);
            }
            List<ServerPlayer> party = PartyUtils.getPartyMembersInRange(player);
            this.awardXP(party, xpAwards);
        } else {
            player.m_6352_((Component)LangProvider.DENIAL_SALVAGE.asComponent(salvageItem.m_41611_()), player.m_142081_());
        }
    }

    public void setMarkedPos(UUID playerID, BlockPos pos) {
        BlockPos finalPos = pos.equals((Object)this.getMarkedPos(playerID)) ? BlockPos.f_121853_ : pos;
        this.markers.put(playerID, finalPos);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Player " + playerID.toString() + " Marked Pos: " + finalPos.toString(), new Object[0]);
    }

    public BlockPos getMarkedPos(UUID playerID) {
        return this.markers.getOrDefault(playerID, BlockPos.f_121853_);
    }

    public int getBlockConsume(Block block) {
        return this.loader.BLOCK_LOADER.getData((ResourceLocation)RegistryUtil.getId((Block)block)).veinData().consumeAmount.orElseGet(() -> (Boolean)Config.REQUIRE_SETTING.get() != false ? -1 : (Integer)Config.DEFAULT_CONSUME.get());
    }
}

