/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core;

import com.mojang.serialization.DynamicOps;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class CoreUtils {
    public static Map<String, Long> deserializeAwardMap(CompoundTag nbt) {
        return new HashMap<String, Long>(CodecTypes.LONG_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(str -> MsLoggy.ERROR.log(MsLoggy.LOG_CODE.API, "Error Deserializing Award Map from API: {}", str)).orElse(new HashMap()));
    }

    public static Map<String, Long> mergeXpMapsWithSummateCondition(Map<String, Long> ogMap, Map<String, Long> newMap) {
        boolean summate = (Boolean)Config.SUMMATED_MAPS.get();
        if (!summate) {
            return newMap;
        }
        for (Map.Entry<String, Long> entry : newMap.entrySet()) {
            ogMap.merge(entry.getKey(), entry.getValue(), (a, b) -> a > b ? a : b);
        }
        return ogMap;
    }

    public static Map<String, Long> applyXpModifiers(Map<String, Long> mapIn, Map<String, Double> modifiers) {
        modifiers.forEach((skill, modifier) -> mapIn.computeIfPresent((String)skill, (key, xp) -> (long)((double)xp.longValue() * modifier)));
        return mapIn;
    }

    public static Map<String, Long> processSkillGroupXP(Map<String, Long> map) {
        new HashMap<String, Long>(map).forEach((skill, baseXP) -> {
            SkillData data = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault());
            if (data.isSkillGroup()) {
                map.remove(skill);
                data.getGroupXP((long)baseXP).forEach((member, xp) -> map.merge((String)member, (Long)xp, Long::sum));
            }
        });
        return map;
    }

    public static Map<String, Integer> processSkillGroupReqs(Map<String, Integer> map) {
        new HashMap<String, Integer>(map).forEach((skill, level) -> {
            SkillData data = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault());
            if (data.isSkillGroup() && !data.getUseTotalLevels()) {
                map.remove(skill);
                data.getGroupReq((int)level).forEach((member, xp) -> map.merge((String)member, (Integer)xp, Integer::sum));
            }
        });
        return map;
    }

    public static Map<String, Double> processSkillGroupBonus(Map<String, Double> map) {
        new HashMap<String, Double>(map).forEach((skill, level) -> {
            SkillData data = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault());
            if (data.isSkillGroup()) {
                map.remove(skill);
                map.putAll(data.getGroupBonus((double)level));
            }
        });
        return map;
    }

    public static int getSkillColor(String skill) {
        return SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).getColor();
    }

    public static Style getSkillStyle(String skill) {
        return Style.f_131099_.m_131148_(TextColor.m_131266_((int)CoreUtils.getSkillColor(skill)));
    }

    public static List<MobEffectInstance> getEffects(Map<ResourceLocation, Integer> config, boolean applyDefaultNegatives) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        if (applyDefaultNegatives && config.isEmpty()) {
            config = AutoValueConfig.ITEM_PENALTIES.get();
        }
        for (Map.Entry<ResourceLocation, Integer> effect : config.entrySet()) {
            MobEffect effectRoot = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effect.getKey());
            if (effectRoot == null) continue;
            effects.add(new MobEffectInstance(effectRoot, 75, effect.getValue().intValue(), true, true));
        }
        return effects;
    }
}

