/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.nbt;

import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PathReader {
    public static List<String> getNBTValues(String path, CompoundTag nbt) {
        List<String> nodes = PathReader.parsePath(path);
        if (nbt.m_128456_() || nbt == null) {
            return new ArrayList<String>();
        }
        return PathReader.evaluateCompound(nodes, nbt);
    }

    private static List<String> parsePath(String path) {
        ArrayList<String> nodes = new ArrayList<String>();
        StringReader reader = new StringReader(path);
        Object element = "";
        while (reader.canRead()) {
            if (reader.peek() == '.') {
                nodes.add((String)element);
                element = "";
                reader.read();
                continue;
            }
            element = (String)element + reader.read();
        }
        nodes.add((String)element);
        return nodes;
    }

    private static List<String> evaluateCompound(List<String> nodes, CompoundTag nbt) {
        ArrayList<String> list = new ArrayList<String>();
        if (nbt.m_128456_() || nbt == null) {
            return list;
        }
        String nodeEntry = nodes.get(0);
        if (PathReader.isQualifiedNode(nodeEntry) && !PathReader.isQualifiedCompound(nodeEntry, nbt)) {
            return list;
        }
        if (PathReader.isList(nodeEntry)) {
            nodes.remove(0);
            list.addAll(PathReader.evaluateList(nodes, nodeEntry, (ListTag)nbt.m_128423_(PathReader.rawNode(nodeEntry))));
        } else if (PathReader.isCompound(nodeEntry)) {
            nodes.remove(0);
            list.addAll(PathReader.evaluateCompound(nodes, nbt.m_128469_(PathReader.rawNode(nodeEntry))));
        } else {
            Tag value = nbt.m_128423_(PathReader.rawNode(nodeEntry));
            if (value != null) {
                list.add(value.m_7916_());
            }
        }
        return list;
    }

    private static List<String> evaluateList(List<String> nodes, String node, ListTag lnbt) {
        ArrayList<String> list = new ArrayList<String>();
        if (lnbt == null) {
            return list;
        }
        int index = PathReader.getListIndex(node);
        if (index == -2) {
            index = PathReader.getQualifiedIndex(node, lnbt);
        }
        if (index < -1 || index >= lnbt.size()) {
            return list;
        }
        if (index == -1) {
            for (int l = 0; l < lnbt.size(); ++l) {
                if (lnbt.get(0) instanceof CompoundTag) {
                    list.addAll(PathReader.evaluateCompound(new ArrayList<String>(nodes), lnbt.m_128728_(l)));
                    continue;
                }
                if (lnbt.get(0) instanceof ListTag) {
                    list.addAll(PathReader.evaluateList(new ArrayList<String>(nodes), PathReader.getListParameters(nodes.get(0)), lnbt.m_128744_(l)));
                    continue;
                }
                list.add(lnbt.get(l).m_7916_());
            }
        } else if (lnbt.get(0) instanceof CompoundTag) {
            list.addAll(PathReader.evaluateCompound(nodes, lnbt.m_128728_(index)));
        } else if (lnbt.get(0) instanceof ListTag) {
            list.addAll(PathReader.evaluateList(nodes, PathReader.getListParameters(nodes.get(0)), lnbt.m_128744_(index)));
        } else {
            list.add(lnbt.get(index).m_7916_());
        }
        return list;
    }

    private static boolean isList(String node) {
        return node.contains("[");
    }

    private static boolean isCompound(String node) {
        return node.contains("{");
    }

    private static boolean isQualifiedNode(String node) {
        return node.matches("\\{.*:.*}");
    }

    private static boolean isQualifiedCompound(String node, CompoundTag nbt) {
        String root = PathReader.rawNode(node);
        String key = node.substring(node.indexOf("{") + 1, node.indexOf(":")).replaceAll("\"", "");
        String value = node.substring(node.indexOf(":") + 1, node.indexOf("}")).replaceAll("\"", "");
        boolean test = nbt.m_128441_(root) && nbt.m_128469_(root).m_128441_(key) && nbt.m_128469_(root).m_128423_(key).m_7916_().equalsIgnoreCase(value);
        return test;
    }

    private static int getListIndex(String node) {
        String rawIndex = PathReader.getListParameters(node);
        try {
            return rawIndex.isEmpty() ? -1 : Integer.valueOf(rawIndex);
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }

    private static int getQualifiedIndex(String param, ListTag lnbt) {
        if (!PathReader.isCompound(param)) {
            return -2;
        }
        if (!(lnbt.get(0) instanceof CompoundTag)) {
            return -2;
        }
        String key = param.substring(param.indexOf("{") + 1, param.indexOf(":"));
        String value = param.substring(param.indexOf(":") + 1, param.indexOf("}"));
        value = PathReader.rawValue(value);
        for (int i = 0; i < lnbt.size(); ++i) {
            CompoundTag element = lnbt.m_128728_(i);
            if (!element.m_128441_(key) || !element.m_128423_(key).m_7916_().equalsIgnoreCase(value)) continue;
            return i;
        }
        return -2;
    }

    private static String getListParameters(String node) {
        if (PathReader.isList(node)) {
            int beginIndex = node.indexOf("[") + 1;
            int endIndex = node.indexOf("]");
            return node.substring(beginIndex, endIndex);
        }
        return "";
    }

    private static String rawNode(String node) {
        if (PathReader.isList(node)) {
            return node.substring(0, node.indexOf("["));
        }
        if (PathReader.isCompound(node)) {
            return node.substring(0, node.indexOf("{"));
        }
        return node;
    }

    private static String rawValue(String val) {
        int firstIndex = val.indexOf("\"");
        return val.substring(firstIndex + 1, val.indexOf("\"", firstIndex + 1));
    }
}

