/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.PerkSide;
import harmonised.pmmo.core.perks.FeaturePerks;
import harmonised.pmmo.core.perks.PerksImpl;
import harmonised.pmmo.features.fireworks.FireworkHandler;
import harmonised.pmmo.util.TagBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.function.TriFunction;

public class PerkRegistration {
    private static TriFunction<Player, CompoundTag, Integer, CompoundTag> NONE = (a, b, c) -> new CompoundTag();
    private static TriPredicate<Player, CompoundTag, Integer> PASS_TRUE = (a, b, c) -> true;

    public static void init() {
        APIUtils.registerPerk(PerkRegistration.rl("break_speed"), PerksImpl.getDefaults(), PASS_TRUE, PerksImpl.BREAK_SPEED, NONE, PerkSide.BOTH);
        APIUtils.registerPerk(PerkRegistration.rl("fireworks"), TagBuilder.start().withString("firework_skill", "none").withString("skill", "none").build(), PASS_TRUE, FireworkHandler.FIREWORKS, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("attribute"), TagBuilder.start().withDouble("max_boost", 0.0).withDouble("per_level", 0.0).build(), PASS_TRUE, FeaturePerks.ATTRIBUTE, FeaturePerks.ATTRIBUTE_TERM, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("reach"), TagBuilder.start().withDouble("max_boost", 10.0).withDouble("per_level", 0.1).build(), PASS_TRUE, FeaturePerks.REACH, FeaturePerks.REACH_TERM, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("damage"), TagBuilder.start().withDouble("max_boost", 1.0).withDouble("per_level", 0.005).build(), PASS_TRUE, FeaturePerks.DAMAGE, FeaturePerks.DAMAGE_TERM, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("speed"), TagBuilder.start().withDouble("max_boost", 1.0).withDouble("per_level", 0.005).build(), PASS_TRUE, FeaturePerks.SPEED, FeaturePerks.SPEED_TERM, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("health"), TagBuilder.start().withDouble("max_boost", 10.0).withDouble("per_level", 0.05).build(), PASS_TRUE, FeaturePerks.HEALTH, FeaturePerks.HEALTH_TERM, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("jump_boost"), TagBuilder.start().withDouble("per_level", 5.0E-4).withDouble("max_boost", 0.033).build(), PASS_TRUE, FeaturePerks.JUMP_CLIENT, NONE, PerkSide.CLIENT);
        APIUtils.registerPerk(PerkRegistration.rl("jump_boost"), TagBuilder.start().withDouble("per_level", 5.0E-4).withDouble("max_boost", 0.033).build(), PASS_TRUE, FeaturePerks.JUMP_SERVER, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("breath"), TagBuilder.start().withLong("cooldown", 30000L).withDouble("per_level", 1.0).build(), FeaturePerks.BREATH_CHECK, FeaturePerks.BREATH, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("fall_save"), TagBuilder.start().withDouble("per_level", 0.025).withFloat("damageIn", 0.0f).build(), PASS_TRUE, FeaturePerks.FALL_SAVE, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("damage_boost"), TagBuilder.start().withFloat("damageIn", 0.0f).withList("applies_to", new Tag[]{StringTag.m_129297_((String)"weapon:id")}).withDouble("per_level", 0.05).build(), FeaturePerks.DAMAGE_BOOST_CHECK, FeaturePerks.DAMAGE_BOOST, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("command"), new CompoundTag(), PASS_TRUE, FeaturePerks.RUN_COMMAND, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("night_vision"), TagBuilder.start().withInt("duration", 100).build(), FeaturePerks.NIGHT_VISION_CHECK, FeaturePerks.NIGHT_VISION, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("regen"), TagBuilder.start().withLong("cooldown", 30000L).withInt("duration", 1).withDouble("per_level", 0.02).build(), PASS_TRUE, FeaturePerks.REGEN, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("effect"), TagBuilder.start().withString("effect", "modid:effect").withInt("per_level", 20).withInt("modifier", 0).withBool("ambient", false).withBool("visible", true).build(), PASS_TRUE, FeaturePerks.GIVE_EFFECT, NONE, PerkSide.SERVER);
        APIUtils.registerPerk(PerkRegistration.rl("tame_boost"), PerksImpl.TAME_DEFAULTS, PASS_TRUE, PerksImpl.TAME_BOOST, NONE, PerkSide.SERVER);
    }

    private static ResourceLocation rl(String str) {
        return new ResourceLocation("pmmo", str);
    }
}

