/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.MsLoggy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;

public class BreakSpeedHandler {
    private static Map<UUID, DetailsCache> resultCache = new HashMap<UUID, DetailsCache>();

    public static void handle(PlayerEvent.BreakSpeed event) {
        Core core = Core.get(event.getEntity().m_183503_());
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (resultCache.containsKey(player.m_142081_()) && BreakSpeedHandler.usingCache(event)) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Cache Used. Supplied: {}", Float.valueOf(event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.TOOL, player.m_21205_(), player)) {
            event.setCanceled(true);
            player.m_5661_((Component)new TextComponent("Unable to use this tool"), false);
            Messenger.sendDenialMsg(ReqType.TOOL, player, player.m_21205_().m_41611_());
            resultCache.put(player.m_142081_(), new DetailsCache(player.m_21205_(), event.getPos(), event.getState(), true, event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.BREAK, event.getPos(), player)) {
            event.setCanceled(true);
            player.m_5661_((Component)new TextComponent("Unable to break this block"), false);
            Messenger.sendDenialMsg(ReqType.BREAK, player, event.getState().m_60734_().m_49954_());
            resultCache.put(player.m_142081_(), new DetailsCache(player.m_21205_(), event.getPos(), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag eventHookOutput = new CompoundTag();
        if (!player.f_19853_.f_46443_ && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BREAK_SPEED, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            resultCache.put(player.m_142081_(), new DetailsCache(player.m_21205_(), event.getPos(), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag perkDataIn = eventHookOutput;
        perkDataIn.m_128350_("speedIn", event.getNewSpeed());
        perkDataIn.m_128356_("block_pos", event.getPos().m_121878_());
        CompoundTag perkDataOut = core.getPerkRegistry().executePerk(EventType.BREAK_SPEED, player, perkDataIn, core.getSide());
        if (perkDataOut.m_128441_("speed")) {
            float newSpeed = Math.max(0.0f, perkDataOut.m_128457_("speed"));
            event.setNewSpeed(newSpeed);
            resultCache.put(player.m_142081_(), new DetailsCache(player.m_21205_(), event.getPos(), event.getState(), player.m_20096_(), false, newSpeed));
        }
    }

    private static boolean usingCache(PlayerEvent.BreakSpeed event) {
        DetailsCache cachedData = resultCache.get(event.getEntity().m_142081_());
        if (event.getEntity().m_20096_() == cachedData.isPlayerStanding() && event.getPos().equals((Object)cachedData.pos) && event.getState().equals(cachedData.state) && ((Player)event.getEntity()).m_21205_().equals(cachedData.item, false)) {
            if (cachedData.cancelled) {
                event.setCanceled(true);
            } else {
                event.setNewSpeed(cachedData.newSpeed);
            }
            return true;
        }
        return false;
    }

    private record DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean isPlayerStanding, boolean cancelled, float newSpeed) {
        public DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean cancelled, float newSpeed) {
            this(item, pos, state, true, cancelled, newSpeed);
        }
    }
}

