/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageReceivedHandler {
    private static final List<String> environmental = List.of(DamageSource.f_19305_.f_19326_, DamageSource.f_19306_.f_19326_, DamageSource.f_19307_.f_19326_, DamageSource.f_19308_.f_19326_, DamageSource.f_19309_.f_19326_, DamageSource.f_19310_.f_19326_, DamageSource.f_19311_.f_19326_, DamageSource.f_19312_.f_19326_, DamageSource.f_19313_.f_19326_, DamageSource.f_19314_.f_19326_, DamageSource.f_19321_.f_19326_, DamageSource.f_19322_.f_19326_, DamageSource.f_19325_.f_19326_, DamageSource.f_146701_.f_19326_, DamageSource.f_146702_.f_19326_);
    private static final List<String> falling = List.of(DamageSource.f_19315_.f_19326_, DamageSource.f_146703_.f_19326_, DamageSource.f_19316_.f_19326_);
    private static final List<String> magic = List.of(DamageSource.f_19319_.f_19326_, "indirectMagic");

    public static void handle(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            EventType type = DamageReceivedHandler.getSourceCategory(event.getSource());
            if (type.equals(EventType.FROM_PLAYERS) && player.equals((Object)event.getSource().m_7639_())) {
                return;
            }
            Core core = Core.get(player.m_183503_());
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + type.name() + " | Source Raw: " + event.getSource().f_19326_, new Object[0]);
            boolean serverSide = !player.f_19853_.f_46443_;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            CompoundTag perkDataIn = eventHookOutput;
            perkDataIn.m_128350_("damageIn", event.getAmount());
            CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(type, player, perkDataIn, core.getSide()));
            if (perkOutput.m_128441_("damage")) {
                event.setAmount(perkOutput.m_128457_("damage"));
            }
            if (serverSide) {
                Map<String, Long> xpAward = DamageReceivedHandler.getExperienceAwards(core, type, event.getSource(), event.getAmount(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, EventType type, DamageSource source, float damage, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Mth.m_14036_((float)damage, (float)0.0f, (float)player.m_21223_());
        switch (type) {
            case FROM_PLAYERS: 
            case FROM_MOBS: 
            case FROM_ANIMALS: {
                core.getExperienceAwards(type, source.m_7639_(), player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)((float)value.longValue() * ultimateDamage)));
                break;
            }
            case FROM_ENVIRONMENT: {
                Config.FROM_ENVIRONMENT_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_ENVIRONMENT_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case FROM_IMPACT: {
                Config.FROM_IMPACT_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_IMPACT_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case FROM_MAGIC: {
                Config.FROM_MAGIC_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_MAGIC_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case RECEIVE_DAMAGE: 
            case FROM_PROJECTILES: {
                Entity uncategorizedEntity = source.m_7639_();
                if (uncategorizedEntity != null) {
                    core.getExperienceAwards(type, uncategorizedEntity, player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)((float)value.longValue() * ultimateDamage)));
                    break;
                }
                Config.RECEIVE_DAMAGE_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.RECEIVE_DAMAGE_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            default: {
                return new HashMap<String, Long>();
            }
        }
        return mapOut;
    }

    private static EventType getSourceCategory(DamageSource source) {
        if (source.f_19326_.equals("player")) {
            return EventType.FROM_PLAYERS;
        }
        if (environmental.contains(source.f_19326_)) {
            return EventType.FROM_ENVIRONMENT;
        }
        if (falling.contains(source.f_19326_)) {
            return EventType.FROM_IMPACT;
        }
        if (magic.contains(source.f_19326_)) {
            return EventType.FROM_MAGIC;
        }
        if (source.m_7639_() != null) {
            if (source.m_7639_().m_6095_().m_204039_(Reference.MOB_TAG)) {
                return EventType.FROM_MOBS;
            }
            if (source.m_7639_().m_6095_().m_204039_(Reference.ANIMAL_TAG)) {
                return EventType.FROM_ANIMALS;
            }
        }
        if (source.m_19360_()) {
            return EventType.FROM_PROJECTILES;
        }
        return EventType.RECEIVE_DAMAGE;
    }
}

