/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;

public class DeathHandler {
    public static void handle(LivingDeathEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            LivingEntity target = event.getEntityLiving();
            if (target == null) {
                return;
            }
            Player player = (Player)event.getSource().m_7639_();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.f_19853_);
            if (!core.isActionPermitted(ReqType.WEAPON, player.m_21205_(), player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.WEAPON, player, player.m_21205_().m_41611_());
                return;
            }
            if (!core.isActionPermitted(ReqType.KILL, (Entity)target, player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.KILL, player, target.m_7755_());
                return;
            }
            boolean serverSide = !player.f_19853_.f_46443_;
            CompoundTag hookOutput = new CompoundTag();
            if (serverSide && (hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.DEATH, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.DEATH, player, hookOutput, core.getSide()));
            if (serverSide) {
                Map<String, Long> xpAward = core.getExperienceAwards(EventType.DEATH, (Entity)target, player, hookOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }
}

