/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.features.penalties.EffectManager;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class PlayerTickHandler {
    private static final Map<UUID, Integer> airLast = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> healthLast = new HashMap<UUID, Float>();
    private static short ticksIgnoredSinceLastProcess = 0;

    public static void handle(TickEvent.PlayerTickEvent event) {
        float healthDiff;
        if ((ticksIgnoredSinceLastProcess = (short)(ticksIgnoredSinceLastProcess + 1)) < 10) {
            return;
        }
        Player player = event.player;
        Core core = Core.get(event.side);
        if (player instanceof ServerPlayer) {
            VeinMiningLogic.regenerateVein((ServerPlayer)player);
            EffectManager.applyEffects(core, player);
        }
        if (!airLast.containsKey(player.m_142081_())) {
            airLast.put(player.m_142081_(), player.m_20146_());
        }
        if (!healthLast.containsKey(player.m_142081_())) {
            healthLast.put(player.m_142081_(), Float.valueOf(player.m_21223_()));
        }
        if (player.m_20146_() != airLast.getOrDefault(player.m_142081_(), 0).intValue()) {
            PlayerTickHandler.processEvent(EventType.BREATH_CHANGE, core, event);
        }
        if ((double)Math.abs(healthDiff = player.m_21223_() - healthLast.getOrDefault(player.m_142081_(), Float.valueOf(0.0f)).floatValue()) >= 0.01) {
            PlayerTickHandler.processEvent(EventType.HEALTH_CHANGE, core, event);
            PlayerTickHandler.processEvent(healthDiff > 0.0f ? EventType.HEALTH_INCREASE : EventType.HEALTH_DECREASE, core, event);
        }
        if (player.m_20159_()) {
            PlayerTickHandler.processEvent(EventType.RIDING, core, event);
        }
        if (!player.m_21220_().isEmpty()) {
            PlayerTickHandler.processEvent(EventType.EFFECT, core, event);
        }
        if (player.m_5842_()) {
            Vec3 vec = player.m_20184_();
            if (player.m_20142_()) {
                PlayerTickHandler.processEvent(EventType.SWIM_SPRINTING, core, event);
            }
            double sinkingRate = 0.01;
            if (vec.m_7098_() > sinkingRate) {
                PlayerTickHandler.processEvent(EventType.SURFACING, core, event);
            } else if (vec.m_7098_() < -sinkingRate) {
                PlayerTickHandler.processEvent(EventType.DIVING, core, event);
            } else {
                PlayerTickHandler.processEvent(EventType.SUBMERGED, core, event);
            }
        } else if (player.m_20069_()) {
            PlayerTickHandler.processEvent(EventType.SWIMMING, core, event);
        } else if (player.m_20142_()) {
            PlayerTickHandler.processEvent(EventType.SPRINTING, core, event);
        } else if (player.m_6047_()) {
            PlayerTickHandler.processEvent(EventType.CROUCH, core, event);
        }
        airLast.put(player.m_142081_(), player.m_20146_());
        healthLast.put(player.m_142081_(), Float.valueOf(player.m_21223_()));
        ticksIgnoredSinceLastProcess = 0;
    }

    private static void processEvent(EventType type, Core core, TickEvent.PlayerTickEvent event) {
        CompoundTag eventHookOutput = new CompoundTag();
        boolean serverSide = core.getSide().equals((Object)LogicalSide.SERVER);
        if (serverSide) {
            eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag());
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(type, event.player, eventHookOutput, core.getSide()));
        if (serverSide) {
            ResourceLocation source = new ResourceLocation("player");
            HashMap<String, Long> xpAward = perkOutput.m_128441_("serialized_award_map") ? CoreUtils.deserializeAwardMap(perkOutput.m_128469_("serialized_award_map")) : new HashMap();
            switch (type) {
                case BREATH_CHANGE: {
                    int diff = Math.abs(airLast.getOrDefault(event.player.m_142081_(), 0) - event.player.m_20146_());
                    Map<String, Double> ratio = Config.BREATH_CHANGE_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * (double)diff * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case HEALTH_CHANGE: {
                    PlayerTickHandler.processHealthChange(Config.HEALTH_CHANGE_XP.get(), core, event.player, xpAward);
                    break;
                }
                case HEALTH_INCREASE: {
                    PlayerTickHandler.processHealthChange(Config.HEALTH_INCREASE_XP.get(), core, event.player, xpAward);
                    break;
                }
                case HEALTH_DECREASE: {
                    PlayerTickHandler.processHealthChange(Config.HEALTH_DECREASE_XP.get(), core, event.player, xpAward);
                    break;
                }
                case RIDING: {
                    source = RegistryUtil.getId(event.player.m_20202_());
                    core.getExperienceAwards(type, event.player.m_20202_(), event.player, perkOutput).forEach((skill, value) -> xpAward.put((String)skill, (Long)value));
                    break;
                }
                case EFFECT: {
                    for (MobEffectInstance mei : event.player.m_21220_()) {
                        source = RegistryUtil.getId(mei.m_19544_());
                        core.getExperienceAwards(mei, event.player, perkOutput).forEach((skill, value) -> xpAward.put((String)skill, (Long)value));
                    }
                    break;
                }
                case SPRINTING: {
                    Vec3 vec = event.player.m_20184_();
                    double magnitude = Math.sqrt(Math.pow(vec.m_7096_(), 2.0) + Math.pow(vec.m_7098_(), 2.0) + Math.pow(vec.m_7094_(), 2.0));
                    Map<String, Double> ratio = Config.SPRINTING_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case SUBMERGED: {
                    Map<String, Double> ratio = Config.SUBMERGED_XP.get();
                    ratio.keySet().forEach(skill -> xpAward.put((String)skill, ratio.getOrDefault(skill, 0.0).longValue()));
                    break;
                }
                case SWIMMING: {
                    Vec3 vec = event.player.m_20184_();
                    double magnitude = Math.sqrt(Math.pow(vec.m_7096_(), 2.0) + Math.pow(vec.m_7098_(), 2.0) + Math.pow(vec.m_7094_(), 2.0));
                    Map<String, Double> ratio = Config.SWIMMING_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case DIVING: {
                    Vec3 vec = event.player.m_20184_();
                    double magnitude = Math.sqrt(Math.pow(vec.m_7096_(), 2.0) + Math.pow(vec.m_7098_(), 2.0) + Math.pow(vec.m_7094_(), 2.0));
                    Map<String, Double> ratio = Config.DIVING_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case SURFACING: {
                    Vec3 vec = event.player.m_20184_();
                    double magnitude = Math.sqrt(Math.pow(vec.m_7096_(), 2.0) + Math.pow(vec.m_7098_(), 2.0) + Math.pow(vec.m_7094_(), 2.0));
                    Map<String, Double> ratio = Config.SURFACING_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case SWIM_SPRINTING: {
                    Vec3 vec = event.player.m_20184_();
                    double magnitude = Math.sqrt(Math.pow(vec.m_7096_(), 2.0) + Math.pow(vec.m_7098_(), 2.0) + Math.pow(vec.m_7094_(), 2.0));
                    Map<String, Double> ratio = Config.SWIM_SPRINTING_XP.get();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.player).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
            }
            CheeseTracker.applyAntiCheese(type, source, event.player, xpAward);
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.XP, "XpGains (afterCheese): " + MsLoggy.mapToString(xpAward), new Object[0]);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    private static void processHealthChange(Map<String, Double> ratio, Core core, Player player, Map<String, Long> xpAward) {
        float diff = Math.abs(healthLast.getOrDefault(player.m_142081_(), Float.valueOf(0.0f)).floatValue() - player.m_21223_());
        ratio.keySet().forEach(skill -> {
            Double value = ratio.getOrDefault(skill, 0.0) * (double)diff * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
            xpAward.put((String)skill, value.longValue());
        });
    }
}

