/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class AutoBlock {
    private static final double BASE_HARDNESS = 4.0;
    public static final ReqType[] REQTYPES = new ReqType[]{ReqType.BREAK, ReqType.PLACE};
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.BLOCK_BREAK, EventType.BLOCK_PLACE, EventType.GROW};
    private static final List<String> WORLD_SENSITIVE_MOD_IDS = List.of("dynamictrees", "dtbop");

    public static Map<String, Integer> processReqs(ReqType type, ResourceLocation blockID) {
        if (!type.blockApplicable || AutoBlock.isWorldSensitive(blockID)) {
            return new HashMap<String, Integer>();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockID);
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        switch (type) {
            case BREAK: {
                if (block.equals(Blocks.f_49990_)) break;
                float breakSpeed = block.m_49966_().m_60800_(null, null);
                AutoValueConfig.getBlockReq(type).forEach((skill, level) -> outMap.put((String)skill, (int)Math.max(0.0, ((double)breakSpeed - 4.0) * (Double)AutoValueConfig.HARDNESS_MODIFIER.get())));
                break;
            }
        }
        return outMap;
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation blockID) {
        if (!type.blockApplicable || AutoBlock.isWorldSensitive(blockID)) {
            return new HashMap<String, Long>();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockID);
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        switch (type) {
            case BLOCK_BREAK: 
            case BLOCK_PLACE: {
                if (ForgeRegistries.BLOCKS.tags().getTag(Reference.CROPS).contains((Object)block)) {
                    outMap.putAll(AutoValueConfig.getBlockXpAward(EventType.GROW));
                    break;
                }
                if (ForgeRegistries.BLOCKS.tags().getTag(Reference.MINABLE_AXE).contains((Object)block)) {
                    outMap.putAll(AutoValueConfig.AXE_OVERRIDE.get());
                    break;
                }
                if (ForgeRegistries.BLOCKS.tags().getTag(Reference.MINABLE_HOE).contains((Object)block)) {
                    outMap.putAll(AutoValueConfig.HOE_OVERRIDE.get());
                    break;
                }
                if (ForgeRegistries.BLOCKS.tags().getTag(Reference.MINABLE_SHOVEL).contains((Object)block)) {
                    outMap.putAll(AutoValueConfig.SHOVEL_OVERRIDE.get());
                    break;
                }
                AutoValueConfig.getBlockXpAward(type).forEach((skill, level) -> {
                    float breakSpeed = Math.max(1.0f, block.m_49966_().m_60800_(null, null));
                    long xpOut = Double.valueOf(Math.max(1.0, (double)breakSpeed * (Double)AutoValueConfig.HARDNESS_MODIFIER.get() * (double)level.longValue())).longValue();
                    if (ForgeRegistries.BLOCKS.tags().getTag(Tags.Blocks.ORES).contains((Object)block)) {
                        xpOut = (long)((double)xpOut * (Double)AutoValueConfig.RARITIES_MODIFIER.get());
                    }
                    outMap.put((String)skill, xpOut);
                });
                break;
            }
            case GROW: {
                if (!(block instanceof CropBlock)) break;
                outMap.putAll(AutoValueConfig.getBlockXpAward(type));
                break;
            }
        }
        return outMap;
    }

    private static boolean isWorldSensitive(ResourceLocation id) {
        return WORLD_SENSITIVE_MOD_IDS.contains(id.m_135827_());
    }
}

