/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.google.gson.JsonObject;
import harmonised.pmmo.util.MsLoggy;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class RareDropModifier
extends LootModifier {
    public ItemStack drop;
    public double chance;

    public RareDropModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(lootItemID));
        this.drop.m_41764_(count);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        double rand = MsLoggy.DEBUG.logAndReturn(context.m_78933_().nextDouble(), MsLoggy.LOG_CODE.FEATURE, "Rand: {} as test for " + this.drop.serializeNBT().toString(), new Object[0]);
        if (rand <= this.chance) {
            generatedLoot.add(this.drop.m_41777_());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RareDropModifier> {
        public RareDropModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            ResourceLocation lootItemID = new ResourceLocation(object.get("item").getAsString());
            int count = object.get("count").getAsInt();
            double chance = object.get("chance").getAsDouble();
            return new RareDropModifier(ailootcondition, lootItemID, count, chance);
        }

        public JsonObject write(RareDropModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", instance.drop.m_41720_().getRegistryName().toString());
            json.addProperty("count", (Number)instance.drop.m_41613_());
            json.addProperty("chance", (Number)instance.chance);
            return json;
        }
    }
}

