/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.google.gson.JsonObject;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class TreasureLootModifier
extends LootModifier {
    public ItemStack drop;
    private final int count;
    public double chance;

    public TreasureLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = lootItemID.equals((Object)new ResourceLocation("air")) ? Items.f_41852_.m_7968_() : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(lootItemID));
        this.drop.m_41764_(count);
        this.count = count;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78933_().nextDouble() <= this.chance) {
            Entity breaker;
            BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            if (state != null && this.drop.m_41720_() == Items.f_41852_) {
                this.drop = (ItemStack)state.m_60724_(new LootContext.Builder(context)).get(0);
                this.drop.m_41764_(this.count);
            }
            if ((breaker = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof Player) {
                Player player = (Player)breaker;
                ((Player)breaker).m_6352_((Component)LangProvider.FOUND_TREASURE.asComponent(), breaker.m_142081_());
            }
            generatedLoot.add(this.drop.m_41777_());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<TreasureLootModifier> {
        public TreasureLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            ResourceLocation lootItemID = new ResourceLocation(object.get("item").getAsString());
            int count = object.get("count").getAsInt();
            double chance = object.get("chance").getAsDouble();
            return new TreasureLootModifier(ailootcondition, lootItemID, count, chance);
        }

        public JsonObject write(TreasureLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", instance.drop.m_41720_().getRegistryName().toString());
            json.addProperty("count", (Number)instance.drop.m_41613_());
            json.addProperty("chance", (Number)instance.chance);
            return json;
        }
    }
}

