/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.party;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartyUtils {
    private static final Map<UUID, Integer> playerToPartyMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Invite> invites = new HashMap<UUID, Invite>();

    public static List<ServerPlayer> getPartyMembersInRange(ServerPlayer player) {
        ArrayList<ServerPlayer> inRange = new ArrayList<ServerPlayer>();
        for (ServerPlayer member : PartyUtils.getPartyMembers(player)) {
            if (!(player.m_20182_().m_82554_(member.m_20182_()) <= (double)((Integer)Config.PARTY_RANGE.get()).intValue())) continue;
            inRange.add(member);
        }
        return inRange;
    }

    public static List<ServerPlayer> getPartyMembers(ServerPlayer player) {
        int partyID = playerToPartyMap.getOrDefault(player.m_142081_(), -1);
        if (partyID == -1) {
            return List.of(player);
        }
        ArrayList<ServerPlayer> outList = new ArrayList<ServerPlayer>();
        outList.add(player);
        for (Map.Entry<UUID, Integer> member : playerToPartyMap.entrySet()) {
            ServerPlayer memberPlayer;
            if (member.getKey().equals(player.m_142081_()) || member.getValue() != partyID || (memberPlayer = player.m_20194_().m_6846_().m_11259_(member.getKey())) == null) continue;
            outList.add(memberPlayer);
        }
        return outList;
    }

    public static void inviteToParty(Player member, Player invitee) {
        UUID requestID = UUID.randomUUID();
        Style acceptStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pmmo party accept " + requestID.toString())).m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true));
        MutableComponent accept = LangProvider.PARTY_ACCEPT.asComponent().m_130948_(acceptStyle);
        Style declineStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pmmo party decline " + requestID.toString())).m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true));
        MutableComponent decline = LangProvider.PARTY_DECLINE_INVITE.asComponent().m_130948_(declineStyle);
        invitee.m_6352_((Component)LangProvider.PARTY_PLAYER_INVITED.asComponent(member.m_5446_(), accept, decline), invitee.m_142081_());
        invites.put(requestID, new Invite(playerToPartyMap.get(member.m_142081_()), invitee.m_142081_()));
    }

    public static void uninviteToParty(Player member, Player invitee) {
        int memberPartyID = playerToPartyMap.getOrDefault(member.m_142081_(), -1);
        if (memberPartyID == -1) {
            member.m_6352_((Component)LangProvider.PARTY_NOT_IN.asComponent(), member.m_142081_());
            return;
        }
        UUID inviteToRemove = null;
        for (Map.Entry<UUID, Invite> invite : invites.entrySet()) {
            Invite i = invite.getValue();
            if (i.partyID() != memberPartyID || !i.player().equals(invitee.m_142081_())) continue;
            inviteToRemove = invite.getKey();
            break;
        }
        if (inviteToRemove != null) {
            invites.remove(inviteToRemove);
            member.m_6352_((Component)LangProvider.PARTY_RESCIND_INVITE.asComponent(invitee.m_5446_()), member.m_142081_());
        }
    }

    public static void acceptInvite(Player invitee, UUID requestID) {
        Invite invite;
        if (invites.get(requestID) == null) {
            invitee.m_6352_((Component)LangProvider.PARTY_NO_INVITES.asComponent(), invitee.m_142081_());
        }
        if (!(invite = invites.get(requestID)).player().equals(invitee.m_142081_())) {
            return;
        }
        playerToPartyMap.put(invitee.m_142081_(), invite.partyID());
        invites.remove(requestID);
        invitee.m_6352_((Component)LangProvider.PARTY_JOINED.asComponent(), invitee.m_142081_());
    }

    public static boolean declineInvite(UUID requestID) {
        return invites.remove(requestID) != null;
    }

    public static void removeFromParty(Player player) {
        playerToPartyMap.remove(player.m_142081_());
    }

    public static void createParty(Player player) {
        playerToPartyMap.put(player.m_142081_(), PartyUtils.getFreePartyID());
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, MsLoggy.mapToString(playerToPartyMap), new Object[0]);
    }

    public static boolean isInParty(Player player) {
        return MsLoggy.DEBUG.logAndReturn(playerToPartyMap.containsKey(player.m_142081_()), MsLoggy.LOG_CODE.FEATURE, "Is In Party: {}", new Object[0]);
    }

    private static int getFreePartyID() {
        for (int id = 0; id < Integer.MAX_VALUE; ++id) {
            if (playerToPartyMap.values().contains(id)) {
                continue;
            }
            return id;
        }
        return -1;
    }

    private record Invite(int partyID, UUID player) {
    }
}

