/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.veinmining;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VeinShapeData {
    private Level level;
    private BlockPos center;
    private int maxBlocks;
    private final Map<BlockPos, Node> map = new HashMap<BlockPos, Node>();
    private final ShapeType mode;
    private final Direction face;

    public VeinShapeData(Level level, BlockPos center, int maxBlocks, ShapeType mode, Direction playerFacing) {
        this.level = level;
        this.center = center;
        this.maxBlocks = maxBlocks;
        this.mode = mode;
        this.face = playerFacing;
        this.map.put(center, new Node(0, false, false));
    }

    public Set<BlockPos> getVein() {
        Block block = this.level.m_8055_(this.center).m_60734_();
        return switch (this.mode) {
            case ShapeType.AOE -> {
                int ring = 0;
                while (this.maxBlocks > 0) {
                    this.addNodesForRing(ring, block);
                    ++ring;
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
            case ShapeType.TUNNEL -> {
                BlockState centerState = this.level.m_8055_(this.center);
                BlockPos lastPos = this.center;
                while (this.maxBlocks > 0 && !lastPos.equals((Object)BlockPos.f_121853_)) {
                    lastPos = this.stepShape(lastPos, centerState, false);
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
            case ShapeType.BIG_TUNNEL -> {
                BlockState centerState = this.level.m_8055_(this.center);
                BlockPos lastPos = this.center;
                while (this.maxBlocks > 0 && !lastPos.equals((Object)BlockPos.f_121853_)) {
                    lastPos = this.stepShape(lastPos, centerState, true);
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
            default -> this.map.keySet();
        };
    }

    private void addNodesForRing(int ring, Block block) {
        HashMap<BlockPos, Node> ringMap = new HashMap<BlockPos, Node>();
        this.map.forEach((pos, node) -> {
            if (node.ring() == ring && !node.scanned() && !node.isTerminal()) {
                ringMap.put((BlockPos)pos, (Node)node);
            }
        });
        if (ringMap.isEmpty()) {
            this.maxBlocks = 0;
            return;
        }
        ringMap.forEach((pos, node) -> {
            this.map.put((BlockPos)pos, node.setScanned());
            HashMap<BlockPos, Node> newRingMap = new HashMap<BlockPos, Node>();
            block0: for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (this.maxBlocks <= 0) break block0;
                        BlockPos currentPos = pos.m_142082_(x, y, z);
                        if (this.map.containsKey(currentPos) || !this.level.m_8055_(currentPos).m_60734_().equals(block)) continue;
                        newRingMap.put(currentPos, new Node(ring + 1, false, false));
                        --this.maxBlocks;
                    }
                }
            }
            if (newRingMap.isEmpty()) {
                this.map.put((BlockPos)pos, node.setScanned().setTerminal());
            } else {
                this.map.putAll(newRingMap);
            }
        });
    }

    private BlockPos stepShape(BlockPos from, BlockState centerState, boolean isBig) {
        boolean allFalse = true;
        if (this.level.m_8055_(from).m_60734_().equals(centerState.m_60734_())) {
            this.map.put(from, Node.NONE);
            --this.maxBlocks;
            allFalse = false;
        }
        if (this.maxBlocks > 0 && this.level.m_8055_(from.m_7495_()).m_60734_().equals(centerState.m_60734_())) {
            this.map.put(from.m_7495_(), Node.NONE);
            --this.maxBlocks;
            allFalse = false;
        }
        if (isBig) {
            if (this.maxBlocks > 0 && this.level.m_8055_(from.m_7494_()).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(from.m_7494_(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, true)).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, true), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, true).m_7494_()).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, true).m_7494_(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, true).m_7495_()).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, true).m_7495_(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, false)).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, false), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, false).m_7494_()).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, false).m_7494_(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.m_8055_(this.getAdjacent(from, false).m_7495_()).m_60734_().equals(centerState.m_60734_())) {
                this.map.put(this.getAdjacent(from, false).m_7495_(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
        }
        if (allFalse) {
            return BlockPos.f_121853_;
        }
        return from.m_142300_(this.face);
    }

    private BlockPos getAdjacent(BlockPos pos, boolean left) {
        return switch (this.face) {
            case Direction.NORTH -> {
                if (left) {
                    yield pos.m_142125_();
                }
                yield pos.m_142126_();
            }
            case Direction.SOUTH -> {
                if (left) {
                    yield pos.m_142126_();
                }
                yield pos.m_142125_();
            }
            case Direction.WEST -> {
                if (left) {
                    yield pos.m_142128_();
                }
                yield pos.m_142127_();
            }
            case Direction.EAST -> {
                if (left) {
                    yield pos.m_142127_();
                }
                yield pos.m_142128_();
            }
            default -> pos;
        };
    }

    public static enum ShapeType {
        AOE,
        TUNNEL,
        BIG_TUNNEL;

    }

    private record Node(int ring, boolean scanned, boolean isTerminal) {
        public static Node NONE = new Node(0, false, false);

        public Node setScanned() {
            return new Node(this.ring(), true, this.isTerminal());
        }

        public Node setTerminal() {
            return new Node(this.ring(), this.scanned(), true);
        }
    }
}

