/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class PerkRegistry {
    private Map<ResourceLocation, CompoundTag> properties = new HashMap<ResourceLocation, CompoundTag>();
    private Map<ResourceLocation, TriPredicate<Player, CompoundTag, Integer>> conditions = new HashMap<ResourceLocation, TriPredicate<Player, CompoundTag, Integer>>();
    private Map<ResourceLocation, TriFunction<Player, CompoundTag, Integer, CompoundTag>> perkExecutions = new HashMap<ResourceLocation, TriFunction<Player, CompoundTag, Integer, CompoundTag>>();
    private Map<ResourceLocation, TriFunction<Player, CompoundTag, Integer, CompoundTag>> perkTerminations = new HashMap<ResourceLocation, TriFunction<Player, CompoundTag, Integer, CompoundTag>>();
    private final Random rand = new Random();

    public void registerPerk(ResourceLocation perkID, CompoundTag propertyDefaults, TriPredicate<Player, CompoundTag, Integer> customConditions, TriFunction<Player, CompoundTag, Integer, CompoundTag> onExecute, TriFunction<Player, CompoundTag, Integer, CompoundTag> onConclude) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull((Object)propertyDefaults);
        Preconditions.checkNotNull(customConditions);
        Preconditions.checkNotNull(onExecute);
        Preconditions.checkNotNull(onConclude);
        this.properties.put(perkID, propertyDefaults);
        this.conditions.put(perkID, customConditions);
        this.perkExecutions.put(perkID, onExecute);
        this.perkTerminations.put(perkID, onConclude);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.API, "Registered Perk: " + perkID.toString(), new Object[0]);
    }

    public void registerProperties(ResourceLocation perkID, CompoundTag propertyDefaults) {
        this.properties.put(perkID, propertyDefaults);
    }

    public CompoundTag getProperties(ResourceLocation perkID) {
        return this.properties.getOrDefault(perkID, new CompoundTag()).m_6426_();
    }

    public CompoundTag executePerk(EventType cause, Player player, LogicalSide side) {
        return this.executePerk(cause, player, new CompoundTag(), side);
    }

    public CompoundTag executePerk(EventType cause, Player player, @NotNull CompoundTag dataIn, LogicalSide side) {
        if (player == null) {
            return new CompoundTag();
        }
        CompoundTag output = new CompoundTag();
        ((Map)PerksConfig.PERK_SETTINGS.get().getOrDefault(cause, new HashMap())).forEach((skill, list) -> {
            int skillLevel = Core.get(side).getData().getPlayerSkillLevel((String)skill, player.m_142081_());
            list.forEach(src -> {
                ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
                src = this.getProperties(perkID).m_128391_(src.m_6426_().m_128391_(dataIn.m_6426_()));
                CompoundTag executionOutput = new CompoundTag();
                if (this.isValidContext(perkID, player, (CompoundTag)src, skillLevel)) {
                    executionOutput = (CompoundTag)this.perkExecutions.getOrDefault(perkID, (TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(plyr, nbt, level) -> new CompoundTag())).apply((Object)player, src, (Object)skillLevel);
                }
                output.m_128391_(TagUtils.mergeTags(output, executionOutput));
            });
        });
        return output;
    }

    private boolean isValidContext(ResourceLocation perkID, Player player, CompoundTag src, int skillLevel) {
        if (src.m_128441_("max_level") && skillLevel > src.m_128451_("max_level")) {
            return false;
        }
        if (src.m_128441_("min_level") && skillLevel < src.m_128451_("min_level")) {
            return false;
        }
        boolean modulus = src.m_128441_("per_x_level");
        boolean milestone = src.m_128441_("milestones");
        if (modulus || milestone) {
            boolean modulus_match = modulus;
            boolean milestone_match = milestone;
            if (modulus && skillLevel % Math.max(1, src.m_128451_("per_x_level")) != 0) {
                modulus_match = false;
            }
            if (milestone && !src.m_128437_("milestones", 6).stream().map(tag -> ((DoubleTag)tag).m_7047_()).toList().contains(skillLevel)) {
                milestone_match = false;
            }
            if (!modulus_match && !milestone_match) {
                return false;
            }
        }
        if (src.m_128441_("chance") && src.m_128459_("chance") < this.rand.nextDouble()) {
            return false;
        }
        return this.conditions.getOrDefault(perkID, (TriPredicate<Player, CompoundTag, Integer>)((TriPredicate)(p, s, l) -> true)).test((Object)player, (Object)src, (Object)skillLevel);
    }

    public CompoundTag terminatePerk(EventType cause, Player player, LogicalSide side) {
        return this.terminatePerk(cause, player, new CompoundTag(), side);
    }

    public CompoundTag terminatePerk(EventType cause, Player player, CompoundTag dataIn, LogicalSide side) {
        Map map = PerksConfig.PERK_SETTINGS.get().getOrDefault(cause, new HashMap());
        CompoundTag output = new CompoundTag();
        for (String skill : map.keySet()) {
            List entries = (List)map.get(skill);
            int skillLevel = Core.get(side).getData().getPlayerSkillLevel(skill, player.m_142081_());
            for (int i = 0; i < entries.size(); ++i) {
                CompoundTag src = (CompoundTag)entries.get(i);
                src.m_128391_(dataIn);
                ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
                CompoundTag executionOutput = new CompoundTag();
                executionOutput = (CompoundTag)this.perkTerminations.getOrDefault(perkID, (TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(plyr, nbt, level) -> new CompoundTag())).apply((Object)player, (Object)src, (Object)skillLevel);
                output = TagUtils.mergeTags(output, executionOutput);
            }
        }
        return output;
    }
}

