/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.events.XpEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_UpdateExperience;
import harmonised.pmmo.network.clientpackets.CP_UpdateLevelCache;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PmmoSavedData
extends SavedData
implements IDataStorage {
    private static String NAME = "pmmo";
    private Map<UUID, Map<String, Long>> xp = new HashMap<UUID, Map<String, Long>>();
    private Map<UUID, Map<String, Long>> scheduledXP = new HashMap<UUID, Map<String, Long>>();
    private static final Codec<Map<UUID, Map<String, Long>>> XP_CODEC = Codec.unboundedMap(CodecTypes.UUID_CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.LONG).xmap(HashMap::new, HashMap::new));
    private static final String XP_KEY = "xp_data";
    private static final String SCHEDULED_KEY = "scheduled_xp";
    private List<Long> levelCache = new ArrayList<Long>();

    @Override
    public long getXpRaw(UUID playerID, String skillName) {
        return ((Map)this.xp.getOrDefault(playerID, new HashMap())).getOrDefault(skillName, 0L);
    }

    @Override
    public boolean setXpDiff(UUID playerID, String skillName, long change) {
        long oldValue = this.getXpRaw(playerID, skillName);
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerID);
        if (player == null) {
            this.scheduledXP.computeIfAbsent(playerID, id -> new HashMap()).merge(skillName, change, (o, n) -> o + n);
            return true;
        }
        XpEvent gainXpEvent = new XpEvent(player, skillName, oldValue, change, TagBuilder.start().build());
        if (MinecraftForge.EVENT_BUS.post((Event)gainXpEvent)) {
            return false;
        }
        this.setXpRaw(playerID, gainXpEvent.skill, oldValue + gainXpEvent.amountAwarded);
        return true;
    }

    @Override
    public void setXpRaw(UUID playerID, String skillName, long value) {
        long formerRaw = this.getLevelFromXP(this.getXpRaw(playerID, skillName));
        this.xp.computeIfAbsent(playerID, s -> new HashMap()).put(skillName, value);
        this.m_77762_();
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerID);
        if (player != null) {
            Networking.sendToClient(new CP_UpdateExperience(skillName, value), player);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Skill Update Packet sent to Client" + playerID.toString(), new Object[0]);
            if (formerRaw != (long)this.getLevelFromXP(value)) {
                Core.get(LogicalSide.SERVER).getPerkRegistry().executePerk(EventType.SKILL_UP, (Player)player, TagBuilder.start().withString("firework_skill", skillName).build(), LogicalSide.SERVER);
            }
        }
    }

    @Override
    public Map<String, Long> getXpMap(UUID playerID) {
        return this.xp.getOrDefault(playerID, new HashMap());
    }

    @Override
    public void setXpMap(UUID playerID, Map<String, Long> map) {
        this.xp.put(playerID, map != null ? map : new HashMap());
        this.m_77762_();
    }

    @Override
    public int getPlayerSkillLevel(String skill, UUID player) {
        int rawLevel = Core.get(LogicalSide.SERVER).getLevelProvider().process(skill, this.getLevelFromXP(this.getXpRaw(player, skill)));
        int skillMaxLevel = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).getMaxLevel();
        return Math.min(rawLevel, skillMaxLevel);
    }

    @Override
    public void setPlayerSkillLevel(String skill, UUID player, int level) {
        long xpRaw = level > 0 ? this.levelCache.get(level - 1) : 0L;
        this.setXpRaw(player, skill, xpRaw);
    }

    @Override
    public boolean changePlayerSkillLevel(String skill, UUID playerID, int change) {
        int currentLevel = this.getPlayerSkillLevel(skill, playerID);
        long oldXp = this.getXpRaw(playerID, skill);
        long newXp = currentLevel - 1 + change >= 0 ? this.levelCache.get(currentLevel + change - 1) : 0L;
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerID);
        if (player != null) {
            XpEvent gainXpEvent = new XpEvent(player, skill, oldXp, newXp - oldXp, TagBuilder.start().build());
            if (MinecraftForge.EVENT_BUS.post((Event)gainXpEvent)) {
                return false;
            }
            if (gainXpEvent.isLevelUp()) {
                Core.get(LogicalSide.SERVER).getPerkRegistry().executePerk(EventType.SKILL_UP, (Player)player, TagBuilder.start().withString("firework_skill", skill).build(), LogicalSide.SERVER);
            }
            this.setPlayerSkillLevel(gainXpEvent.skill, playerID, gainXpEvent.endLevel());
        } else {
            this.setPlayerSkillLevel(skill, playerID, currentLevel + change);
        }
        return true;
    }

    @Override
    public long getBaseXpForLevel(int level) {
        return level > 0 && level - 1 < this.levelCache.size() ? this.levelCache.get(level - 1) : 0L;
    }

    public PmmoSavedData() {
    }

    public PmmoSavedData(CompoundTag nbt) {
        this.xp = new HashMap<UUID, Map<String, Long>>(XP_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_(XP_KEY)).result().orElse(new HashMap()));
        this.scheduledXP = new HashMap<UUID, Map<String, Long>>(XP_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_(SCHEDULED_KEY)).result().orElse(new HashMap()));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        Map<UUID, Map> cleanXP = this.xp.entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        nbt.m_128365_(XP_KEY, (Tag)XP_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, cleanXP).result().orElse(new CompoundTag()));
        nbt.m_128365_(SCHEDULED_KEY, (Tag)XP_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.scheduledXP).result().orElse(new CompoundTag()));
        return nbt;
    }

    @Override
    public IDataStorage get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (IDataStorage)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(PmmoSavedData::new, PmmoSavedData::new, NAME);
        }
        return new PmmoSavedData();
    }

    @Override
    public int getLevelFromXP(long xp) {
        for (int i = 0; i < this.levelCache.size(); ++i) {
            if (this.levelCache.get(i) <= xp) continue;
            return Core.get(LogicalSide.SERVER).getLevelProvider().process("", i);
        }
        return (Integer)Config.MAX_LEVEL.get();
    }

    public List<Long> getLevelCache() {
        return this.levelCache;
    }

    @Override
    public void computeLevelsForCache() {
        if (Config.STATIC_LEVELS.get().size() > 0 && Config.STATIC_LEVELS.get().get(0) != -1L) {
            ArrayList<Long> values = new ArrayList<Long>((Collection)Config.STATIC_LEVELS.get());
            boolean validList = true;
            for (int i = 1; i < values.size(); ++i) {
                if ((Long)values.get(i) > (Long)values.get(i - 1)) continue;
                validList = false;
                break;
            }
            if (validList) {
                Config.MAX_LEVEL.set((Object)values.size());
                this.levelCache = values;
                return;
            }
        }
        boolean exponential = (Boolean)Config.USE_EXPONENTIAL_FORMULA.get();
        long linearBase = (Long)Config.LINEAR_BASE_XP.get();
        double linearPer = (Double)Config.LINEAR_PER_LEVEL.get();
        int exponentialBase = (Integer)Config.EXPONENTIAL_BASE_XP.get();
        double exponentialRoot = (Double)Config.EXPONENTIAL_POWER_BASE.get();
        double exponentialRate = (Double)Config.EXPONENTIAL_LEVEL_MOD.get();
        long current = 0L;
        for (int i = 1; i <= (Integer)Config.MAX_LEVEL.get(); ++i) {
            if ((current = (long)((double)current + (exponential ? (double)exponentialBase * Math.pow(exponentialRoot, exponentialRate * (double)i) : (double)linearBase + (double)i * linearPer))) >= Long.MAX_VALUE) {
                Config.MAX_LEVEL.set((Object)(i - 1));
                break;
            }
            this.levelCache.add(current);
        }
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            Networking.sendToClient(new CP_UpdateLevelCache(this.levelCache), player);
        }
    }

    public void awardScheduledXP(UUID playerID) {
        HashMap queue = new HashMap(this.scheduledXP.getOrDefault(playerID, new HashMap()));
        this.scheduledXP.remove(playerID);
        for (Map.Entry scheduledValue : queue.entrySet()) {
            this.setXpDiff(playerID, (String)scheduledValue.getKey(), (Long)scheduledValue.getValue());
        }
    }
}

