/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class TutorialOverlayGUI
implements IGuiOverlay {
    private Minecraft mc;
    private Font fontRenderer;
    private List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    private BlockHitResult bhr;

    public void render(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        if (this.mc == null) {
            this.mc = Minecraft.m_91087_();
        }
        if (!(this.mc.f_91077_ instanceof BlockHitResult)) {
            return;
        }
        this.bhr = (BlockHitResult)this.mc.f_91077_;
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.f_91062_;
        }
        int renderLeft = screenWidth / 8 * 5;
        int renderTop = screenHeight / 4;
        int tooltipWidth = 3 * (screenWidth / 8);
        if (!this.mc.f_91066_.f_92063_) {
            if (this.mc.f_91073_.m_8055_(this.bhr.m_82425_()).m_60734_().equals(ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Config.SALVAGE_BLOCK.get())))) {
                this.lines = new ArrayList<ClientTooltipComponent>(this.ctc(this.mc, LangProvider.SALVAGE_TUTORIAL_HEADER.asComponent().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), tooltipWidth));
                if (!(!this.mc.f_91074_.m_6047_() || this.mc.f_91074_.m_21205_().m_41619_() && this.mc.f_91074_.m_21206_().m_41619_())) {
                    ItemStack salvageStack = this.mc.f_91074_.m_21205_().m_41619_() ? this.mc.f_91074_.m_21206_() : this.mc.f_91074_.m_21205_();
                    this.gatherSalvageData(salvageStack).forEach(line -> this.lines.addAll(this.ctc(this.mc, (MutableComponent)line, tooltipWidth)));
                } else {
                    this.lines.addAll(this.ctc(this.mc, LangProvider.SALVAGE_TUTORIAL_USAGE.asComponent(), tooltipWidth));
                }
            } else {
                return;
            }
            stack.m_85836_();
            RenderSystem.m_69478_();
            if (!this.lines.isEmpty()) {
                int i = 0;
                int j = this.lines.size() == 1 ? -2 : 0;
                for (ClientTooltipComponent clienttooltipcomponent : this.lines) {
                    int k = clienttooltipcomponent.m_142069_(this.fontRenderer);
                    if (k > i) {
                        i = k;
                    }
                    j += clienttooltipcomponent.m_142103_();
                }
                int j2 = renderLeft;
                int k2 = renderTop;
                if (j2 + i > screenWidth) {
                    j2 -= 28 + i;
                }
                if (k2 + j + 6 > screenHeight) {
                    k2 = screenHeight - j - 6;
                }
                stack.m_85836_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                Matrix4f matrix4f = stack.m_85850_().m_85861_();
                RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)ItemStack.f_41583_, (PoseStack)stack, (int)j2, (int)k2, (Font)this.fontRenderer, this.lines);
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderStart());
                TutorialOverlayGUI.fillGradient(matrix4f, bufferbuilder, j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBorderEnd(), colorEvent.getBorderEnd());
                RenderSystem.m_69482_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.m_69461_();
                RenderSystem.m_69493_();
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                stack.m_85837_(0.0, 0.0, 400.0);
                int l1 = k2;
                for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                    ClientTooltipComponent clienttooltipcomponent1 = this.lines.get(i2);
                    clienttooltipcomponent1.m_142440_(this.fontRenderer, j2, l1, matrix4f, multibuffersource$buffersource);
                    l1 += clienttooltipcomponent1.m_142103_() + (i2 == 0 ? 2 : 0);
                }
                multibuffersource$buffersource.m_109911_();
                stack.m_85849_();
                l1 = k2;
                for (int l2 = 0; l2 < this.lines.size(); ++l2) {
                    ClientTooltipComponent clienttooltipcomponent2 = this.lines.get(l2);
                    l1 += clienttooltipcomponent2.m_142103_() + (l2 == 0 ? 2 : 0);
                }
            }
            stack.m_85849_();
        }
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    private List<ClientTooltipComponent> ctc(Minecraft mc, MutableComponent component, int width) {
        return mc.f_91062_.m_92923_((FormattedText)component, width).stream().map(fcs -> ClientTooltipComponent.m_169948_((FormattedCharSequence)fcs)).toList();
    }

    private List<MutableComponent> gatherSalvageData(ItemStack stack) {
        ArrayList<MutableComponent> outList = new ArrayList<MutableComponent>();
        for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> entry : Core.get((LogicalSide)LogicalSide.CLIENT).getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).salvage().entrySet()) {
            outList.add(MutableComponent.m_237204_((ComponentContents)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(entry.getKey())).m_41611_().m_214077_()));
            CodecTypes.SalvageData data = entry.getValue();
            if (!data.levelReq().isEmpty()) {
                outList.add(LangProvider.SALVAGE_LEVEL_REQ.asComponent().m_130940_(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Integer> entry2 : data.levelReq().entrySet()) {
                    outList.add(Component.m_237115_((String)("pmmo." + entry2.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + entry2.getValue()))));
                }
            }
            outList.add(LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).m_130940_(ChatFormatting.UNDERLINE));
            outList.add(LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).m_130940_(ChatFormatting.UNDERLINE));
            if (!data.chancePerLevel().isEmpty()) {
                outList.add(LangProvider.SALVAGE_CHANCE_MOD.asComponent().m_130940_(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Number> entry3 : data.chancePerLevel().entrySet()) {
                    outList.add(Component.m_237115_((String)("pmmo." + entry3.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + entry3.getValue()))));
                }
            }
            if (data.xpAward().isEmpty()) continue;
            outList.add(LangProvider.SALVAGE_XP_AWARD.asComponent().m_130940_(ChatFormatting.UNDERLINE));
            for (Map.Entry<String, Number> entry4 : data.xpAward().entrySet()) {
                outList.add(Component.m_237115_((String)("pmmo." + entry4.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + entry4.getValue()))));
            }
        }
        return outList;
    }
}

