/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class PlayerStatsComponent
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    protected static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("pmmo", "textures/gui/player_stats.png");
    protected static final Core core = Core.get(LogicalSide.CLIENT);
    protected Minecraft minecraft;
    private boolean visible;
    private int xOffset;
    private int width;
    private int height;
    private boolean widthTooNarrow;
    private int timesInventoryChanged;
    protected PlayerStatsScroller statsScroller;
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;

    public void init(int width, int height, Minecraft minecraft, boolean widthTooNarrow) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.widthTooNarrow = widthTooNarrow;
        this.timesInventoryChanged = minecraft.f_91074_.m_150109_().m_36072_();
        if (this.visible) {
            this.initVisuals();
        }
    }

    public void tick() {
        if (this.isVisible() && this.timesInventoryChanged != this.minecraft.f_91074_.m_150109_().m_36072_()) {
            this.timesInventoryChanged = this.minecraft.f_91074_.m_150109_().m_36072_();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 120.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            this.m_93228_(poseStack, i, j, 0, 0, 147, 166);
            this.statsScroller.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            poseStack.m_85849_();
        }
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.statsScroller = new PlayerStatsScroller(Minecraft.m_91087_(), 131, 150, j + 8, i + 8);
        this.statsScroller.populateAbilities(core, this.minecraft);
    }

    public int updateScreenPosition(int x, int y) {
        int i = this.isVisible() && !this.widthTooNarrow ? 177 + (x - y - 200) / 2 : (x - y) / 2;
        return i;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        if (visible) {
            this.initVisuals();
        }
        this.visible = visible;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_6375_(pMouseX, pMouseY, pButton) || super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_6050_(pMouseX, pMouseY, pDelta) || super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY) || super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput pNarrationElementOutput) {
    }

    static class PlayerStatsScroller
    extends ScrollPanel {
        private final List<String> skillsKeys = new ArrayList<String>();
        private final List<StatComponent> abilities = new ArrayList<StatComponent>();

        public PlayerStatsScroller(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 1, 6, 0xFFFFFF, 0xFFFFFF, -2011094751, -16777216, -11184811);
        }

        public void populateAbilities(Core core, Minecraft minecraft) {
            IDataStorage dataStorage = core.getData();
            this.skillsKeys.addAll(dataStorage.getXpMap(null).keySet());
            this.skillsKeys.sort(Comparator.comparingLong(skill -> dataStorage.getXpRaw(null, (String)skill)).reversed());
            for (String skillKey : this.skillsKeys) {
                SkillData skillData = SkillsConfig.SKILLS.get().getOrDefault(skillKey, SkillData.Builder.getDefault());
                this.abilities.add(new StatComponent(minecraft, this.left + 1, this.top, skillKey, skillData));
            }
        }

        protected void drawPanel(PoseStack guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            for (StatComponent component : this.abilities) {
                component.m_94278_(component.f_93620_, relativeY);
                component.m_6305_(guiGraphics, mouseX, mouseY, Minecraft.m_91087_().getPartialTick());
                relativeY += 24 + this.border;
            }
        }

        protected int getScrollAmount() {
            return 24 + this.border;
        }

        protected int getContentHeight() {
            int height = this.abilities.size() * (24 + this.border);
            if (height < this.bottom - this.top - 1) {
                height = this.bottom - this.top - 1;
            }
            return height;
        }

        @NotNull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    static class StatComponent
    extends ImageButton {
        private final Minecraft minecraft;
        private final String skillName;
        private final SkillData skillData;
        private final Color skillColor;
        private final int skillLevel;
        private final long skillCurrentXP;
        private final long skillXpToNext;
        private static final int BASE_HEIGHT = 24;

        public StatComponent(Minecraft minecraft, int pX, int pY, String skillKey, SkillData skillData) {
            super(pX, pY, 123, 24, 0, 167, 25, TEXTURE_LOCATION, pButton -> {});
            this.minecraft = minecraft;
            this.skillName = Component.m_237115_((String)("pmmo." + skillKey)).getString();
            this.skillData = skillData;
            this.skillColor = new Color(skillData.getColor());
            this.skillCurrentXP = core.getData().getXpRaw(null, skillKey);
            this.skillLevel = core.getData().getLevelFromXP(this.skillCurrentXP);
            this.skillXpToNext = core.getData().getBaseXpForLevel(this.skillLevel + 1) - this.skillCurrentXP;
        }

        public void m_6303_(PoseStack graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_6303_(graphics, pMouseX, pMouseY, pPartialTick);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skillData.getIcon());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            StatComponent.m_93160_((PoseStack)graphics, (int)(this.f_93620_ + 3), (int)(this.f_93621_ + 3), (int)18, (int)18, (float)0.0f, (float)0.0f, (int)this.skillData.getIconSize(), (int)this.skillData.getIconSize(), (int)this.skillData.getIconSize(), (int)this.skillData.getIconSize());
            this.renderProgressBar(graphics);
            GuiComponent.m_93236_((PoseStack)graphics, (Font)this.minecraft.f_91062_, (String)this.skillName, (int)(this.f_93620_ + 24), (int)(this.f_93621_ + 5), (int)this.skillColor.getRGB());
            GuiComponent.m_93236_((PoseStack)graphics, (Font)this.minecraft.f_91062_, (String)String.valueOf(this.skillLevel), (int)(this.f_93620_ + this.f_93618_ - 5 - this.minecraft.f_91062_.m_92895_(String.valueOf(this.skillLevel))), (int)(this.f_93621_ + 5), (int)this.skillColor.getRGB());
        }

        public void renderProgressBar(PoseStack graphics) {
            int renderX = this.f_93620_ + 24;
            Objects.requireNonNull(this.minecraft.f_91062_);
            int renderY = this.f_93621_ + (9 + 6);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
            if (this.f_93622_) {
                MutableComponent text = Component.m_237113_((String)"%s => %s".formatted(this.skillXpToNext, this.skillLevel + 1));
                GuiComponent.m_93243_((PoseStack)graphics, (Font)this.minecraft.f_91062_, (Component)text, (int)renderX, (int)(renderY - 1), (int)this.skillColor.getRGB());
            } else {
                RenderSystem.m_157429_((float)((float)this.skillColor.getRed() / 255.0f), (float)((float)this.skillColor.getGreen() / 255.0f), (float)((float)this.skillColor.getBlue() / 255.0f), (float)((float)this.skillColor.getAlpha() / 255.0f));
                GuiComponent.m_93160_((PoseStack)graphics, (int)renderX, (int)renderY, (int)94, (int)5, (float)0.0f, (float)217.0f, (int)102, (int)5, (int)256, (int)256);
                long baseXP = core.getData().getBaseXpForLevel(this.skillLevel);
                long requiredXP = core.getData().getBaseXpForLevel(this.skillLevel + 1);
                float percent = 100.0f / (float)(requiredXP - baseXP);
                int xp = (int)Math.min(Math.floor(percent * (float)(this.skillCurrentXP - baseXP)), 94.0);
                GuiComponent.m_93160_((PoseStack)graphics, (int)renderX, (int)renderY, (int)xp, (int)5, (float)0.0f, (float)223.0f, (int)102, (int)5, (int)256, (int)256);
            }
        }
    }
}

