/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.compat.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillTask
extends Task {
    public static TaskType SKILL = FTBQHandler.SKILL;
    public String skill = "mining";
    public int requiredLevel = 1;

    public SkillTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return SKILL;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("skill", this.skill);
        nbt.m_128405_("requiredLevel", this.requiredLevel);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.skill = nbt.m_128461_("skill");
        this.requiredLevel = nbt.m_128451_("requiredLevel");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.skill, Short.MAX_VALUE);
        buffer.writeInt(this.requiredLevel);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.m_130136_(Short.MAX_VALUE);
        this.requiredLevel = buffer.readInt();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)"mining", (Object[])SkillsConfig.SKILLS.get().keySet().toArray()).create());
        config.addInt("requiredLevel", this.requiredLevel, input -> {
            this.requiredLevel = input;
        }, this.requiredLevel, 1, ((Integer)Config.MAX_LEVEL.get()).intValue());
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        IDataStorage data = Core.get(player.f_19853_).getData();
        long xp = data.getPlayerSkillLevel(this.skill, player.m_20148_());
        SkillData config = SkillsConfig.SKILLS.get().getOrDefault(this.skill, SkillData.Builder.getDefault());
        if (config.isSkillGroup() && config.getUseTotalLevels()) {
            xp = config.groupedSkills().get().entrySet().stream().map(entry -> (int)((Double)entry.getValue() * (double)data.getPlayerSkillLevel((String)entry.getKey(), player.m_20148_()))).collect(Collectors.summingInt(Integer::intValue)).intValue();
        }
        teamData.setProgress((Task)this, xp);
    }

    public long getMaxProgress() {
        return this.requiredLevel;
    }

    public Component getAltTitle() {
        return LangProvider.FTBQ_SKILL_TITLE.asComponent(this.requiredLevel, LangProvider.skill(this.skill));
    }
}

