/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.util.Functions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record LocationData(boolean override, Set<String> tagValues, Map<ModifierDataType, Map<String, Double>> bonusMap, Map<ResourceLocation, Integer> positive, Map<ResourceLocation, Integer> negative, List<ResourceLocation> veinBlacklist, Map<String, Integer> travelReq, Map<ResourceLocation, Map<String, Double>> mobModifiers) implements DataSource<LocationData>
{
    public static final Codec<LocationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(ld -> Optional.of(ld.override())), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("isTagFor").forGetter(ld -> Optional.of(new ArrayList<String>(ld.tagValues()))), (App)Codec.optionalField((String)"bonus", (Codec)Codec.simpleMap(ModifierDataType.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ModifierDataType.values())).codec()).forGetter(ld -> Optional.of(ld.bonusMap())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).optionalFieldOf("positive_effect").forGetter(ld -> Optional.of(ld.positive())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).optionalFieldOf("negative_effect").forGetter(ld -> Optional.of(ld.negative())), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("vein_blacklist").forGetter(ld -> Optional.of(ld.veinBlacklist())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).optionalFieldOf("travel_req").forGetter(ld -> Optional.of(ld.travelReq())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CodecTypes.DOUBLE_CODEC).optionalFieldOf("mob_modifier").forGetter(ld -> Optional.of(ld.mobModifiers()))).apply((Applicative)instance, (override, tags, bonus, pos, neg, vein, req, mobs) -> new LocationData(override.orElse(false), new HashSet<String>(tags.orElse(List.of())), DataSource.clearEmptyValues(bonus.orElse(new HashMap())), DataSource.clearEmptyValues(pos.orElse(new HashMap())), DataSource.clearEmptyValues(neg.orElse(new HashMap())), new ArrayList<ResourceLocation>(vein.orElse(new ArrayList())), DataSource.clearEmptyValues(req.orElse(new HashMap())), DataSource.clearEmptyValues(mobs.orElse(new HashMap())))));

    public LocationData() {
        this(false, new HashSet<String>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<ResourceLocation, Integer>(), new ArrayList<ResourceLocation>(), new HashMap<String, Integer>(), new HashMap<ResourceLocation, Map<String, Double>>());
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.bonusMap().getOrDefault(type, new HashMap());
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonusMap().put(type, bonuses);
    }

    @Override
    public Map<String, Integer> getReqs(ReqType type, CompoundTag nbt) {
        return this.travelReq();
    }

    @Override
    public void setReqs(ReqType type, Map<String, Integer> reqs) {
        this.travelReq().clear();
        this.travelReq().putAll(reqs);
    }

    @Override
    public Map<ResourceLocation, Integer> getNegativeEffect() {
        return this.negative();
    }

    @Override
    public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
        this.negative().clear();
        this.negative().putAll(neg);
    }

    @Override
    public Map<ResourceLocation, Integer> getPositiveEffect() {
        return this.positive();
    }

    @Override
    public void setPositiveEffects(Map<ResourceLocation, Integer> pos) {
        this.positive().clear();
        this.positive().putAll(pos);
    }

    @Override
    public Set<String> getTagValues() {
        return this.tagValues();
    }

    @Override
    public LocationData combine(LocationData two) {
        HashSet<String> tagValues = new HashSet<String>();
        HashMap<ModifierDataType, Map<String, Double>> bonusMap = new HashMap<ModifierDataType, Map<String, Double>>();
        HashMap<ResourceLocation, Integer> positive = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, Integer> negative = new HashMap<ResourceLocation, Integer>();
        ArrayList<ResourceLocation> veinBlacklist = new ArrayList<ResourceLocation>();
        HashMap<String, Integer> travelReq = new HashMap<String, Integer>();
        HashMap<ResourceLocation, Map<String, Double>> mobModifiers = new HashMap<ResourceLocation, Map<String, Double>>();
        BiConsumer<LocationData, LocationData> bothOrNeither = (o, t) -> {
            tagValues.addAll(o.tagValues());
            t.tagValues().forEach(rl -> {
                if (!tagValues.contains(rl)) {
                    tagValues.add((String)rl);
                }
            });
            bonusMap.putAll(o.bonusMap());
            t.bonusMap().forEach((key, value) -> bonusMap.merge((ModifierDataType)key, (Map<String, Double>)value, (oldV, newV) -> {
                HashMap mergedMap = new HashMap(oldV);
                newV.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            positive.putAll(o.positive());
            t.positive().forEach((key, value) -> positive.merge((ResourceLocation)key, (Integer)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            negative.putAll(o.negative());
            t.negative().forEach((key, value) -> negative.merge((ResourceLocation)key, (Integer)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            veinBlacklist.addAll(o.veinBlacklist());
            t.veinBlacklist().forEach(rl -> {
                if (!veinBlacklist.contains(rl)) {
                    veinBlacklist.add((ResourceLocation)rl);
                }
            });
            travelReq.putAll(o.travelReq());
            t.travelReq().forEach((key, value) -> travelReq.merge((String)key, (Integer)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            mobModifiers.putAll(o.mobModifiers());
            t.mobModifiers().forEach((key, value) -> mobModifiers.merge((ResourceLocation)key, (Map<String, Double>)value, (oldV, newV) -> {
                HashMap mergedMap = new HashMap(oldV);
                newV.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            tagValues.addAll(o.tagValues().isEmpty() ? t.tagValues() : o.tagValues());
            bonusMap.putAll(o.bonusMap().isEmpty() ? t.bonusMap() : o.bonusMap());
            positive.putAll(o.positive().isEmpty() ? t.positive() : o.positive());
            negative.putAll(o.negative().isEmpty() ? t.negative() : o.negative());
            veinBlacklist.addAll(o.veinBlacklist().isEmpty() ? t.veinBlacklist() : o.veinBlacklist());
            travelReq.putAll(o.travelReq().isEmpty() ? t.travelReq() : o.travelReq());
            mobModifiers.putAll(o.mobModifiers().isEmpty() ? t.mobModifiers() : o.mobModifiers());
        }, bothOrNeither, bothOrNeither);
        return new LocationData(this.override() || two.override(), tagValues, bonusMap, positive, negative, veinBlacklist, travelReq, mobModifiers);
    }

    @Override
    public boolean isUnconfigured() {
        return this.bonusMap.values().stream().allMatch(map -> map.isEmpty()) && this.positive.isEmpty() && this.negative.isEmpty() && this.veinBlacklist.isEmpty() && this.travelReq.isEmpty() && this.mobModifiers.isEmpty();
    }
}

