/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.nbt;

import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.config.GlobalsConfig;
import harmonised.pmmo.core.nbt.BehaviorToPrevious;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.Operator;
import harmonised.pmmo.core.nbt.PathReader;
import harmonised.pmmo.core.nbt.Result;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;

public class NBTUtils {
    private static final Map<Pair<CompoundTag, Set<LogicEntry>>, Map<String, Double>> cache = new HashMap<Pair<CompoundTag, Set<LogicEntry>>, Map<String, Double>>();

    public static Map<String, Long> getExperienceAward(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.translateToLong(NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic)));
    }

    public static Map<String, Integer> getRequirement(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.translateToInt(NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic)));
    }

    public static Map<String, Double> getBonuses(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic));
    }

    private static Map<String, Double> evaluateEntries(CompoundTag nbt, LinkedHashSet<LogicEntry> logic) {
        int i;
        HashMap<String, Double> output = new HashMap<String, Double>();
        if (nbt == null || nbt.m_128456_()) {
            return output;
        }
        if (cache.containsKey(Pair.of((Object)nbt, logic))) {
            return MsLoggy.DEBUG.logAndReturn(cache.get(Pair.of((Object)nbt, logic)), MsLoggy.LOG_CODE.DATA, "NBT Cache Used", new Object[0]);
        }
        ArrayList<LogicTier> logicSequence = new ArrayList<LogicTier>();
        for (LogicEntry entry : logic) {
            logicSequence.add(new LogicTier(entry.behavior(), entry.addCases(), NBTUtils.processCases(entry.cases(), nbt)));
        }
        ArrayList interMap = new ArrayList();
        for (i = 0; i < logicSequence.size(); ++i) {
            HashMap<String, Double> combinedMap = new HashMap<String, Double>();
            List<Result> data = ((LogicTier)logicSequence.get((int)i)).results;
            boolean isSummative = ((LogicTier)logicSequence.get((int)i)).isSummative;
            for (Result r : data) {
                if (r == null || !r.compares()) continue;
                Map<String, Double> value = r.values();
                for (Map.Entry<String, Double> val : value.entrySet()) {
                    combinedMap.merge(val.getKey(), val.getValue(), (in1, in2) -> isSummative ? in1 + in2 : (in1 > in2 ? in1 : in2));
                }
            }
            interMap.add(combinedMap);
        }
        block9: for (i = 0; i < logicSequence.size(); ++i) {
            switch (((LogicTier)logicSequence.get(i)).behavior()) {
                case SUB_FROM: {
                    for (Map.Entry value : ((Map)interMap.get(i)).entrySet()) {
                        if (output.getOrDefault(value.getKey(), 0.0) - (Double)value.getValue() <= 0.0) {
                            output.remove(value.getKey());
                            continue;
                        }
                        output.merge((String)value.getKey(), (Double)value.getValue(), (oldValue, newValue) -> oldValue - newValue);
                    }
                    continue block9;
                }
                case HIGHEST: {
                    for (Map.Entry value : ((Map)interMap.get(i)).entrySet()) {
                        output.merge((String)value.getKey(), (Double)value.getValue(), (oldValue, newValue) -> oldValue > newValue ? oldValue : newValue);
                    }
                    continue block9;
                }
                case REPLACE: {
                    for (Map.Entry value : ((Map)interMap.get(i)).entrySet()) {
                        output.put((String)value.getKey(), (Double)value.getValue());
                    }
                    continue block9;
                }
                default: {
                    for (Map.Entry value : ((Map)interMap.get(i)).entrySet()) {
                        output.merge((String)value.getKey(), (Double)value.getValue(), (oldValue, newValue) -> oldValue + newValue);
                    }
                }
            }
        }
        cache.put((Pair<CompoundTag, Set<LogicEntry>>)Pair.of((Object)nbt, logic), output);
        return output;
    }

    private static List<Result> processCases(List<LogicEntry.Case> cases, CompoundTag nbt) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (int i = 0; i < cases.size(); ++i) {
            LogicEntry.Case caseIterant = cases.get(i);
            List<String> paths = caseIterant.paths();
            List<LogicEntry.Criteria> criteria = caseIterant.criteria();
            for (int p = 0; p < paths.size(); ++p) {
                for (int c = 0; c < criteria.size(); ++c) {
                    LogicEntry.Criteria critObj = criteria.get(c);
                    Map<String, Double> values = critObj.skillMap();
                    Operator operator = critObj.operator();
                    List<String> comparison = PathReader.getNBTValues(NBTUtils.getActualPath(paths.get(p)), nbt);
                    for (int j = 0; j < comparison.size(); ++j) {
                        List comparators = new ArrayList();
                        if (!operator.equals((Object)Operator.EXISTS)) {
                            comparators = critObj.comparators().orElseGet(() -> new ArrayList());
                            for (int l = 0; l < comparators.size(); ++l) {
                                String comparator = NBTUtils.getActualConstant((String)comparators.get(l));
                                results.add(new Result(operator, comparator, comparison.get(j), values));
                            }
                            continue;
                        }
                        results.add(new Result(operator, "", comparison.get(j), values));
                    }
                }
            }
        }
        return results;
    }

    private static Map<String, Long> translateToLong(Map<String, Double> src) {
        HashMap<String, Long> output = new HashMap<String, Long>();
        src.forEach((k, v) -> output.put((String)k, v.longValue()));
        return output;
    }

    private static Map<String, Integer> translateToInt(Map<String, Double> src) {
        HashMap<String, Integer> output = new HashMap<String, Integer>();
        src.forEach((k, v) -> output.put((String)k, v.intValue()));
        return output;
    }

    private static String getActualPath(String key) {
        return key.contains("#") ? GlobalsConfig.PATHS.get().getOrDefault(key.replace("#", ""), "") : key;
    }

    private static String getActualConstant(String key) {
        return key.contains("#") ? GlobalsConfig.CONSTANTS.get().getOrDefault(key.replace("#", ""), "") : key;
    }

    private record LogicTier(BehaviorToPrevious behavior, boolean isSummative, List<Result> results) {
    }
}

