/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.function.TriFunction;

public class FeaturePerks {
    private static final CompoundTag NONE = new CompoundTag();
    private static Map<UUID, Long> regen_cooldown = new HashMap<UUID, Long>();
    private static Map<UUID, Long> breathe_cooldown = new HashMap<UUID, Long>();
    private static final UUID ATTRIBUTE_ID = UUID.fromString("b902b6aa-8393-4bdc-8f0d-b937268ef5af");
    private static final Map<String, Attribute> attributeCache = new HashMap<String, Attribute>();
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> ATTRIBUTE = (player, nbt, level) -> {
        double perLevel = nbt.m_128459_("per_level");
        double maxBoost = nbt.m_128459_("max_boost");
        AttributeInstance instance = player.m_21051_(FeaturePerks.getAttribute(nbt));
        double boost = Math.min(perLevel * (double)level.intValue(), maxBoost);
        AttributeModifier modifier = new AttributeModifier(ATTRIBUTE_ID, "PMMO-modifier based on user skill", boost, AttributeModifier.Operation.ADDITION);
        instance.m_22120_(ATTRIBUTE_ID);
        instance.m_22125_(modifier);
        return NONE;
    };
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> ATTRIBUTE_TERM = (player, nbt, level) -> {
        AttributeInstance instance = player.m_21051_(FeaturePerks.getAttribute(nbt));
        instance.m_22120_(ATTRIBUTE_ID);
        return NONE;
    };
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> SPEED = (player, nbt, level) -> {
        double maxSpeedBoost = nbt.m_128459_("max_boost");
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        double speedBoost = player.m_21051_(Attributes.f_22279_).m_22115_() * Math.max(0.0, Math.min(maxSpeedBoost, Math.min(maxSpeedBoost, (double)level.intValue() * nbt.m_128459_("per_level") / 100.0)));
        if (speedBoost > 0.0 && (speedAttribute.m_22111_(speedModifierID) == null || speedAttribute.m_22111_(speedModifierID).m_22218_() != speedBoost)) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, AttributeModifier.Operation.ADDITION);
            speedAttribute.m_22120_(speedModifierID);
            speedAttribute.m_22125_(speedModifier);
        }
        return NONE;
    };
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> SPEED_TERM = (p, nbt, l) -> {
        AttributeInstance speedAttribute = p.m_21051_(Attributes.f_22279_);
        speedAttribute.m_22120_(speedModifierID);
        return NONE;
    };
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> DAMAGE = (player, nbt, level) -> {
        double maxDamage = nbt.m_128459_("max_boost");
        double perLevel = nbt.m_128459_("per_level");
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        double damageBoost = Math.min(maxDamage, (double)level.intValue() * perLevel);
        AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Combat Level", damageBoost, AttributeModifier.Operation.MULTIPLY_BASE);
        damageAttribute.m_22120_(damageModifierID);
        damageAttribute.m_22125_(damageModifier);
        return NONE;
    };
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> DAMAGE_TERM = (player, nbt, level) -> {
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        damageAttribute.m_22120_(damageModifierID);
        return NONE;
    };
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> REACH = (player, nbt, level) -> {
        double perLevel = nbt.m_128459_("per_level");
        double maxReach = nbt.m_128459_("max_boost");
        double reach = -0.91 + (double)level.intValue() * perLevel;
        reach = Math.min(maxReach, reach);
        AttributeInstance reachAttribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute.m_22111_(reachModifierID) == null || reachAttribute.m_22111_(reachModifierID).m_22218_() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, AttributeModifier.Operation.ADDITION);
            reachAttribute.m_22120_(reachModifierID);
            reachAttribute.m_22125_(reachModifier);
        }
        return NONE;
    };
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> REACH_TERM = (player, nbt, level) -> {
        AttributeInstance reachAttribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        reachAttribute.m_22120_(reachModifierID);
        return NONE;
    };
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> HEALTH = (player, nbt, level) -> {
        double perLevel = nbt.m_128459_("per_level");
        int maxHeart = nbt.m_128451_("max_boost");
        int heartBoost = (int)(perLevel * (double)level.intValue());
        heartBoost = Math.min(maxHeart, heartBoost);
        AttributeInstance hpAttribute = player.m_21051_(Attributes.f_22276_);
        AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Endurance Level", (double)heartBoost, AttributeModifier.Operation.ADDITION);
        hpAttribute.m_22120_(hpModifierID);
        hpAttribute.m_22125_(hpModifier);
        return NONE;
    };
    public static final TriFunction<Player, CompoundTag, Integer, CompoundTag> HEALTH_TERM = (player, nbt, level) -> {
        AttributeInstance hpAttribute = player.m_21051_(Attributes.f_22276_);
        hpAttribute.m_22120_(hpModifierID);
        return NONE;
    };
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> NIGHT_VISION = (player, nbt, level) -> {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, nbt.m_128451_("duration"), 0, true, false, false));
        return NONE;
    };
    public static TriPredicate<Player, CompoundTag, Integer> NIGHT_VISION_CHECK = (player, nbt, level) -> !player.m_21023_(MobEffects.f_19611_) || player.m_21124_(MobEffects.f_19611_).m_19557_() <= 80;
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> REGEN = (player, nbt, level) -> {
        long cooldown = nbt.m_128454_("cooldown");
        int duration = nbt.m_128451_("duration");
        double strength = nbt.m_128459_("per_level");
        int perLevel = Math.max(0, (int)((double)level.intValue() * strength));
        long currentCD = regen_cooldown.getOrDefault(player.m_20148_(), System.currentTimeMillis());
        if (currentCD < System.currentTimeMillis() - cooldown || currentCD + 20L >= System.currentTimeMillis()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, perLevel));
            regen_cooldown.put(player.m_20148_(), System.currentTimeMillis());
        }
        return NONE;
    };
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> JUMP_CLIENT = (player, nbt, level) -> {
        double jumpBoost = Math.min(nbt.m_128459_("max_boost"), -0.011 + (double)level.intValue() * nbt.m_128459_("per_level"));
        player.m_20256_(player.m_20184_().m_82520_(0.0, jumpBoost, 0.0));
        player.f_19864_ = true;
        return NONE;
    };
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> JUMP_SERVER = (player, nbt, level) -> {
        double jumpBoost = Math.min(nbt.m_128459_("max_boost"), -0.011 + (double)level.intValue() * nbt.m_128459_("per_level"));
        return TagBuilder.start().withDouble("jump_boost_output", player.m_20184_().f_82480_ + jumpBoost).build();
    };
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> BREATH = (player, nbt, level) -> {
        int perLevel = Math.max(1, (int)((double)level.intValue() * nbt.m_128459_("per_level")));
        player.m_20301_(player.m_20146_() + perLevel);
        player.m_213846_((Component)LangProvider.PERK_BREATH_REFRESH.asComponent());
        breathe_cooldown.put(player.m_20148_(), System.currentTimeMillis());
        return NONE;
    };
    public static TriPredicate<Player, CompoundTag, Integer> BREATH_CHECK = (player, nbt, level) -> {
        long currentCD = breathe_cooldown.getOrDefault(player.m_20148_(), System.currentTimeMillis());
        return player.m_20146_() < 2 && (currentCD < System.currentTimeMillis() - nbt.m_128454_("cooldown") || currentCD + 20L >= System.currentTimeMillis());
    };
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> FALL_SAVE = (player, nbt, level) -> {
        float saved = (int)(nbt.m_128459_("per_level") * (double)level.intValue());
        return TagBuilder.start().withFloat("damage", Math.max(nbt.m_128457_("damageIn") - saved, 0.0f)).build();
    };
    public static final String APPLICABLE_TO = "applies_to";
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> DAMAGE_BOOST = (player, nbt, level) -> {
        float damage = nbt.m_128457_("damageIn") * (1.0f + (float)(nbt.m_128459_("per_level") * (double)level.intValue()));
        return TagBuilder.start().withFloat("damage", damage).build();
    };
    public static TriPredicate<Player, CompoundTag, Integer> DAMAGE_BOOST_CHECK = (player, nbt, level) -> {
        List<String> type = nbt.m_128437_(APPLICABLE_TO, 8).stream().map(tag -> tag.m_7916_()).toList();
        return type.contains(RegistryUtil.getId(player.m_21205_()).toString());
    };
    private static final String COMMAND = "command";
    private static final String FUNCTION = "function";
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> RUN_COMMAND = (p, nbt, level) -> {
        if (!(p instanceof ServerPlayer)) {
            return NONE;
        }
        if (nbt.m_128441_("skill") && nbt.m_128441_("firework_skill") && !nbt.m_128461_("skill").equals(nbt.m_128461_("firework_skill"))) {
            return NONE;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (nbt.m_128441_(FUNCTION)) {
            player.m_20194_().m_129890_().m_136112_((CommandFunction)player.m_20194_().m_129890_().m_136118_(new ResourceLocation(nbt.m_128461_(FUNCTION))).get(), player.m_20203_().m_81324_().m_81358_(2));
        } else if (nbt.m_128441_(COMMAND)) {
            player.m_20194_().m_129892_().m_230957_(player.m_20203_().m_81324_().m_81358_(2), nbt.m_128461_(COMMAND));
        }
        return NONE;
    };
    public static final String EFFECT = "effect";
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> GIVE_EFFECT = (player, nbt, level) -> {
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_(EFFECT)));
        if (effect != null) {
            int perLevel = nbt.m_128451_("per_level");
            int amplifier = nbt.m_128451_("modifier");
            boolean ambient = nbt.m_128471_("ambient");
            boolean visible = nbt.m_128471_("visible");
            player.m_7292_(new MobEffectInstance(effect, perLevel * level, amplifier, ambient, visible));
        }
        return NONE;
    };

    private static Attribute getAttribute(CompoundTag nbt) {
        return attributeCache.computeIfAbsent(nbt.m_128461_("attribute"), name -> (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(name)));
    }
}

