/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.util.TagBuilder;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.function.TriFunction;

public class PerksImpl {
    private static final CompoundTag NONE = new CompoundTag();
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> DUMMY = (player, nbt, level) -> NONE;
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> BREAK_SPEED = (player, nbt, level) -> {
        float speedIn = nbt.m_128441_("speedIn") ? nbt.m_128457_("speedIn") : player.m_21205_().m_41691_(Blocks.f_50080_.m_49966_());
        float speedBonus = PerksImpl.getRatioForTool(player.m_21205_(), nbt);
        if (speedBonus == 0.0f) {
            return NONE;
        }
        float newSpeed = speedIn * Math.max(0.0f, 1.0f + (float)level.intValue() * speedBonus);
        return TagBuilder.start().withFloat("speed", newSpeed).build();
    };
    private static Set<ToolAction> DIG_ACTIONS = Set.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.SHOVEL_DIG, ToolActions.HOE_DIG, ToolActions.SHEARS_DIG, ToolActions.SWORD_DIG);
    private static final UUID ATTRIBUTE_ID = UUID.fromString("b902b6aa-8393-4bdc-8f0d-b937268ef5af");
    public static final CompoundTag TAME_DEFAULTS = TagBuilder.start().withDouble("per_level", 1.0).build();
    private static final Map<Attribute, Double> ANIMAL_ATTRIBUTES = Map.of(Attributes.f_22288_, 0.005, Attributes.f_22276_, 1.0, Attributes.f_22279_, 0.01, Attributes.f_22284_, 0.01, Attributes.f_22281_, 0.01);
    public static final String ANIMAL_ID = "tamed";
    public static TriFunction<Player, CompoundTag, Integer, CompoundTag> TAME_BOOST = (player, nbt, level) -> {
        if (player.f_19853_ instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)player.f_19853_;
            UUID animalID = nbt.m_128342_(ANIMAL_ID);
            LivingEntity animal = (LivingEntity)world.m_142646_().m_142694_(animalID);
            if (animal == null) {
                return NONE;
            }
            double perLevel = nbt.m_128459_("per_level");
            for (Map.Entry<Attribute, Double> atr : ANIMAL_ATTRIBUTES.entrySet()) {
                AttributeInstance instance = animal.m_21051_(atr.getKey());
                if (instance == null) continue;
                AttributeModifier modifier = new AttributeModifier(ATTRIBUTE_ID, "Taming boost", perLevel * atr.getValue() * (double)level.intValue(), AttributeModifier.Operation.ADDITION);
                instance.m_22125_(modifier);
            }
        }
        return NONE;
    };

    private static float getRatioForTool(ItemStack tool, CompoundTag nbt) {
        float ratio = 0.0f;
        for (ToolAction action : DIG_ACTIONS) {
            if (!tool.canPerformAction(action)) continue;
            ratio += nbt.m_128457_(action.name());
        }
        return ratio;
    }

    public static CompoundTag getDefaults() {
        TagBuilder builder = TagBuilder.start();
        for (ToolAction action : DIG_ACTIONS) {
            builder.withFloat(action.name(), 0.0f);
        }
        return builder.build();
    }
}

