/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.storage.ChunkDataHandler;
import harmonised.pmmo.storage.ChunkDataProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class CropGrowHandler {
    public static void handle(BlockEvent.CropGrowEvent.Post event) {
        Level level = (Level)event.getLevel();
        if (!level.f_46443_) {
            Core core = Core.get(level);
            BlockPos sourcePos = CropGrowHandler.getParentPos(level, event.getState(), event.getPos());
            ChunkDataHandler cap = (ChunkDataHandler)level.m_46745_(sourcePos).getCapability(ChunkDataProvider.CHUNK_CAP).orElseGet(ChunkDataHandler::new);
            UUID placerID = cap.checkPos(sourcePos);
            ServerPlayer player = event.getLevel().m_7654_().m_6846_().m_11259_(placerID);
            if (player == null) {
                return;
            }
            cap.addPos(event.getPos(), placerID);
            CompoundTag hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.GROW, (Event)event, new CompoundTag());
            hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.GROW, (Player)player, core.getSide()));
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.GROW, event.getPos(), level, (Player)player, hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange(player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    private static BlockPos getParentPos(Level level, BlockState state, BlockPos posIn) {
        if (state.m_204336_(Reference.CASCADING_BREAKABLES)) {
            return level.m_8055_(posIn.m_7494_()).m_60795_() && level.m_8055_(posIn.m_7495_()).m_204336_(Reference.CASCADING_BREAKABLES) ? posIn.m_7495_() : (level.m_8055_(posIn.m_7495_()).m_60795_() && level.m_8055_(posIn.m_7494_()).m_204336_(Reference.CASCADING_BREAKABLES) ? posIn.m_7494_() : posIn);
        }
        return posIn;
    }
}

