/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;

public class FishHandler {
    public static void handle(ItemFishedEvent event) {
        Player player = event.getEntity();
        Core core = Core.get(player.m_9236_());
        if (!core.isActionPermitted(ReqType.TOOL, (ItemStack)event.getDrops().get(0), player)) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.TOOL, player, ((ItemStack)event.getDrops().get(0)).m_41611_());
            return;
        }
        boolean serverSide = !player.f_19853_.f_46443_;
        CompoundTag eventHookOutput = new CompoundTag();
        if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.FISH, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            return;
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.FISH, player, eventHookOutput, core.getSide()));
        if (serverSide) {
            HashMap<String, Long> xpAward = new HashMap<String, Long>();
            for (ItemStack stack : event.getDrops()) {
                core.getExperienceAwards(EventType.FISH, stack, event.getEntity(), perkOutput).forEach((skill, value) -> xpAward.merge((String)skill, (Long)value, (o, n) -> o + n));
            }
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

