/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_ResetXP;
import harmonised.pmmo.network.clientpackets.CP_SyncVein;
import harmonised.pmmo.network.clientpackets.CP_UpdateExperience;
import harmonised.pmmo.network.clientpackets.CP_UpdateLevelCache;
import harmonised.pmmo.network.serverpackets.SP_SetVeinLimit;
import harmonised.pmmo.storage.PmmoSavedData;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;

public class LoginHandler {
    public static void handle(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Core core = Core.get(player.f_19853_);
        core.getPerkRegistry().terminatePerk(EventType.DISABLE_PERK, player, core.getSide());
        if (core.getSide().equals((Object)LogicalSide.SERVER)) {
            Networking.sendToClient(new CP_ResetXP(), (ServerPlayer)player);
            for (Map.Entry<String, Long> skillMap : core.getData().getXpMap(player.m_20148_()).entrySet()) {
                Networking.sendToClient(new CP_UpdateExperience(skillMap.getKey(), skillMap.getValue()), (ServerPlayer)player);
            }
            Networking.sendToClient(new CP_UpdateLevelCache(((PmmoSavedData)core.getData()).getLevelCache()), (ServerPlayer)player);
            Networking.sendToClient(new CP_SyncVein(VeinMiningLogic.getCurrentCharge(player)), (ServerPlayer)player);
            ((PmmoSavedData)core.getData()).awardScheduledXP(player.m_20148_());
        } else {
            Networking.sendToServer(new SP_SetVeinLimit((Integer)Config.VEIN_LIMIT.get()));
        }
        if (ModList.get().isLoaded("jei")) {
            AutoValues.resetCache();
        }
    }
}

