/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShieldBlockHandler {
    public static void handle(ShieldBlockEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getDamageSource().m_7639_() == null) {
            return;
        }
        Player player = (Player)event.getEntity();
        Core core = Core.get(player.f_19853_);
        ItemStack shield = player.m_21211_();
        Entity attacker = event.getDamageSource().m_7639_();
        if (!core.isActionPermitted(ReqType.WEAPON, shield, player)) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.WEAPON, player, shield.m_41611_());
            return;
        }
        boolean serverSide = !player.f_19853_.f_46443_;
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide && (hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.SHIELD_BLOCK, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            return;
        }
        hookOutput.m_128350_("damageIn", event.getBlockedDamage());
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.SHIELD_BLOCK, player, hookOutput, core.getSide()));
        if (serverSide) {
            HashMap<String, Long> xpAward = new HashMap<String, Long>();
            core.getExperienceAwards(EventType.SHIELD_BLOCK, attacker, player, hookOutput).forEach((skill, value) -> xpAward.put((String)skill, (long)((float)value.longValue() * event.getBlockedDamage())));
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

