/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.mixin;

import harmonised.pmmo.storage.ChunkDataProvider;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class ServerLevelMixin {
    @Inject(method={"destroyBlock(Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/entity/Entity;I)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z")})
    public void setBlockInvocation(BlockPos pos, boolean p_46627_, @Nullable Entity entity, int p_46629_, CallbackInfoReturnable<?> ci) {
        if ((Level)this instanceof ServerLevel) {
            ServerLevelMixin.execute(pos, (Level)this);
        }
    }

    private static void execute(BlockPos pos, Level level) {
        BlockState state = level.m_8055_(pos);
        level.m_46745_(pos).getCapability(ChunkDataProvider.CHUNK_CAP).ifPresent(cap -> {
            for (BlockPos neighbor : ServerLevelMixin.getNeighbors(pos)) {
                UUID playerID = cap.getBreaker(neighbor);
                if (playerID == null) continue;
                ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerID);
                MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, (Player)player));
                cap.setBreaker(pos, playerID);
                break;
            }
        });
    }

    private static Set<BlockPos> getNeighbors(BlockPos src) {
        return Set.of(src.m_7494_(), src.m_7495_(), src.m_122012_(), src.m_122019_(), src.m_122024_(), src.m_122029_());
    }
}

