/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup;

import com.mojang.brigadier.CommandDispatcher;
import harmonised.pmmo.commands.CmdPmmoRoot;
import harmonised.pmmo.compat.curios.CurioCompat;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.readers.CoreLoader;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.perks.PerkRegistration;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.features.loot_modifiers.SkillUpTrigger;
import harmonised.pmmo.features.veinmining.capability.VeinHandler;
import harmonised.pmmo.features.veinmining.capability.VeinProvider;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.setup.datagen.GLMProvider;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.ChunkDataProvider;
import harmonised.pmmo.storage.IChunkData;
import harmonised.pmmo.util.MsLoggy;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonSetup {
    public static void init(FMLCommonSetupEvent event) {
        Networking.registerMessages();
        Networking.registerDataSyncPackets();
        PerkRegistration.init();
        event.enqueueWork(() -> (SkillUpTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)SkillUpTrigger.SKILL_UP));
        CurioCompat.hasCurio = ModList.get().isLoaded("curios");
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.init();
        }
    }

    @SubscribeEvent
    public static void onServerStartup(ServerStartingEvent event) {
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.LOADING, "Loading PMMO Saved Data", new Object[0]);
        Core.get(LogicalSide.SERVER).getData();
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.LOADING, "Computing data for cache", new Object[0]);
        Core.get(LogicalSide.SERVER).getData().computeLevelsForCache();
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.LOADING, "PMMO Server loading process complete", new Object[0]);
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.SERVER)) {
            if (event.getConfig().getFileName().equalsIgnoreCase("pmmo-server.toml")) {
                Core.get(LogicalSide.SERVER).getData().computeLevelsForCache();
            }
            if (event.getConfig().getFileName().equalsIgnoreCase("pmmo-autovalues.toml")) {
                AutoValues.resetCache();
            }
        }
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CmdPmmoRoot.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)CoreLoader.RELOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BLOCK_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENTITY_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().PLAYER_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENCHANTMENT_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().EFFECT_LOADER);
    }

    public static void onCapabilityRegister(RegisterCapabilitiesEvent event) {
        event.register(IChunkData.class);
        event.register(VeinHandler.class);
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(ChunkDataProvider.CHUNK_CAP_ID, (ICapabilityProvider)new ChunkDataProvider());
    }

    @SubscribeEvent
    public static void onPlayerCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(VeinProvider.VEIN_CAP_ID, (ICapabilityProvider)new VeinProvider());
        }
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            for (LangProvider.Locale locale : LangProvider.Locale.values()) {
                generator.m_236039_(true, (DataProvider)new LangProvider(generator, locale.str));
            }
        }
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new GLMProvider(generator));
        }
    }
}

