/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.enums;

import com.mojang.serialization.Codec;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.common.IExtensibleEnum;

public enum ReqType implements StringRepresentable,
IExtensibleEnum,
GuiEnumGroup
{
    WEAR(true, false, false, "endurance"),
    USE_ENCHANTMENT(true, false, false, "magic"),
    TOOL(true, false, false, "mining"),
    WEAPON(true, false, false, "combat"),
    USE(true, false, false, "crafting"),
    PLACE(true, true, false, "building"),
    BREAK(true, true, false, "mining"),
    KILL(false, false, true, "combat"),
    TRAVEL(false, false, false, "agility"),
    RIDE(false, false, true, "farming"),
    TAME(false, false, true, "taming"),
    BREED(false, false, true, "farming"),
    INTERACT(true, true, false, "engineering"),
    ENTITY_INTERACT(false, false, true, "farming");

    public final boolean itemApplicable;
    public final boolean blockApplicable;
    public final boolean entityApplicable;
    public final String defaultSkill;
    public static final ReqType[] ITEM_APPLICABLE_EVENTS;
    public static final ReqType[] BLOCK_APPLICABLE_EVENTS;
    public static final ReqType[] ENTITY_APPLICABLE_EVENTS;
    public static final ReqType[] BLOCKITEM_APPLICABLE_EVENTS;
    public static final Codec<ReqType> CODEC;
    private static final Map<String, ReqType> BY_NAME;

    private ReqType(boolean itemApplicable, boolean blockApplicable, boolean entityApplicable, String defaultSkill) {
        this.itemApplicable = itemApplicable;
        this.blockApplicable = blockApplicable;
        this.entityApplicable = entityApplicable;
        this.defaultSkill = defaultSkill;
    }

    public static ReqType byName(String name) {
        return BY_NAME.get(name);
    }

    public String m_7912_() {
        return this.name();
    }

    public static ReqType create(String name, boolean itemApplicable, boolean blockApplicable, boolean entityApplicable, String defaultSkill) {
        throw new IllegalStateException("Enum not extended");
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        ITEM_APPLICABLE_EVENTS = (ReqType[])Arrays.asList(ReqType.values()).stream().filter(type -> type.itemApplicable).toArray(ReqType[]::new);
        BLOCK_APPLICABLE_EVENTS = (ReqType[])Arrays.asList(ReqType.values()).stream().filter(type -> type.blockApplicable).toArray(ReqType[]::new);
        ENTITY_APPLICABLE_EVENTS = (ReqType[])Arrays.asList(ReqType.values()).stream().filter(type -> type.entityApplicable).toArray(ReqType[]::new);
        BLOCKITEM_APPLICABLE_EVENTS = (ReqType[])Arrays.asList(ReqType.values()).stream().filter(type -> type.itemApplicable || type.blockApplicable).toArray(ReqType[]::new);
        CODEC = IExtensibleEnum.createCodecForExtensibleEnum(ReqType::values, ReqType::byName);
        BY_NAME = Arrays.stream(ReqType.values()).collect(Collectors.toMap(ReqType::m_7912_, s -> s));
    }
}

