/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.StatsScreen;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.client.gui.component.SelectionWidget;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GlossarySelectScreen
extends Screen {
    private static final ResourceLocation GUI_BG = new ResourceLocation("pmmo", "textures/gui/screenboxy.png");
    private SelectionWidget<SelectionWidget.SelectionEntry<SELECTION>> selectSection;
    private SelectionWidget<SelectionWidget.SelectionEntry<OBJECT>> selectObject;
    private SelectionWidget<SelectionWidget.SelectionEntry<String>> selectSkills;
    private SelectionWidget<SelectionWidget.SelectionEntry<GuiEnumGroup>> selectEnum;
    private Button viewButton;
    private SELECTION selection;
    private OBJECT object;
    private String skill = "";
    private GuiEnumGroup type;
    private int renderX;
    private int renderY;

    public GlossarySelectScreen() {
        super((Component)Component.m_237113_((String)"pmmo_glossary"));
        this.m_7856_();
    }

    protected void m_7856_() {
        this.renderX = this.f_96543_ / 2 - 128;
        this.renderY = this.f_96544_ / 2 - 128;
        this.selectSection = new SelectionWidget<SelectionWidget.SelectionEntry>(this.f_96543_ / 2 - 100, this.renderY + 25, 200, (Component)LangProvider.GLOSSARY_DEFAULT_SECTION.asComponent(), this::updateSelection);
        this.selectSection.setEntries(SELECTION.CHOICE_LIST);
        this.selectObject = new SelectionWidget<SelectionWidget.SelectionEntry>(this.f_96543_ / 2 - 100, this.renderY + 50, 200, (Component)LangProvider.GLOSSARY_DEFAULT_OBJECT.asComponent(), sel -> {
            this.object = (OBJECT)((Object)((Object)sel.reference));
            this.updateEnum((SelectionWidget.SelectionEntry<OBJECT>)sel);
        });
        this.selectObject.f_93624_ = false;
        this.selectSkills = new SelectionWidget<SelectionWidget.SelectionEntry>(this.f_96543_ / 2 - 100, this.renderY + 75, 200, (Component)LangProvider.GLOSSARY_DEFAULT_SKILL.asComponent(), sel -> {
            this.skill = (String)sel.reference;
        });
        this.selectSkills.setEntries(SkillsConfig.SKILLS.get().keySet().stream().sorted().map(skill -> new SelectionWidget.SelectionEntry<String>((Component)Component.m_237115_((String)("pmmo." + skill)).m_6270_(CoreUtils.getSkillStyle(skill)), (String)skill)).toList());
        this.selectSkills.f_93624_ = false;
        this.selectEnum = new SelectionWidget<SelectionWidget.SelectionEntry>(this.f_96543_ / 2 - 100, this.renderY + 100, 200, (Component)LangProvider.GLOSSARY_DEFAULT_ENUM.asComponent(), sel -> {
            this.type = (GuiEnumGroup)sel.reference;
        });
        this.selectEnum.f_93624_ = false;
        this.viewButton = Button.m_253074_((Component)LangProvider.GLOSSARY_VIEW_BUTTON.asComponent(), button -> {
            if (this.selection != null && this.object != null) {
                Minecraft.m_91087_().m_91152_((Screen)new StatsScreen(this.selection, this.object, this.skill, this.type));
            }
        }).m_252987_(this.f_96543_ / 2 - 40, this.renderY + 125, 80, 20).m_253136_();
        this.viewButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.viewButton);
        this.m_142416_((GuiEventListener)this.selectEnum);
        this.m_142416_((GuiEventListener)this.selectSkills);
        this.m_142416_((GuiEventListener)this.selectObject);
        this.m_142416_((GuiEventListener)this.selectSection);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
    }

    public void m_7333_(PoseStack stack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BG);
        GuiComponent.m_93228_((PoseStack)stack, (int)this.renderX, (int)this.renderY, (int)0, (int)0, (int)256, (int)256);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrolled) {
        if (this.selectSection.isExtended()) {
            return this.selectSection.m_6050_(mouseX, mouseY, scrolled) || super.m_6050_(mouseX, mouseY, scrolled);
        }
        if (this.selectObject.isExtended()) {
            return this.selectObject.m_6050_(mouseX, mouseY, scrolled) || super.m_6050_(mouseX, mouseY, scrolled);
        }
        if (this.selectSkills.isExtended()) {
            return this.selectSkills.m_6050_(mouseX, mouseY, scrolled) || super.m_6050_(mouseX, mouseY, scrolled);
        }
        if (this.selectEnum.isExtended()) {
            return this.selectEnum.m_6050_(mouseX, mouseY, scrolled) || super.m_6050_(mouseX, mouseY, scrolled);
        }
        return super.m_6050_(mouseX, mouseY, scrolled);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTicks) {
        if (this.selectSection.isExtended()) {
            return this.selectSection.m_6375_(mouseX, mouseY, partialTicks) || super.m_6375_(mouseX, mouseY, partialTicks);
        }
        if (this.selectObject.isExtended()) {
            return this.selectObject.m_6375_(mouseX, mouseY, partialTicks) || super.m_6375_(mouseX, mouseY, partialTicks);
        }
        if (this.selectSkills.isExtended()) {
            return this.selectSkills.m_6375_(mouseX, mouseY, partialTicks) || super.m_6375_(mouseX, mouseY, partialTicks);
        }
        if (this.selectEnum.isExtended()) {
            return this.selectEnum.m_6375_(mouseX, mouseY, partialTicks) || super.m_6375_(mouseX, mouseY, partialTicks);
        }
        return this.viewButton.m_6375_(mouseX, mouseY, partialTicks) || super.m_6375_(mouseX, mouseY, partialTicks);
    }

    private void updateSelection(SelectionWidget.SelectionEntry<SELECTION> sel) {
        this.selection = (SELECTION)((Object)sel.reference);
        this.selectObject.f_93624_ = true;
        this.selectObject.setEntries(this.selection.validObjects);
        this.selectSkills.f_93624_ = true;
        this.selectEnum.f_93624_ = this.selection != SELECTION.SALVAGE && this.selection != SELECTION.VEIN && this.selection != SELECTION.PERKS;
        this.viewButton.f_93624_ = true;
    }

    private void updateEnum(SelectionWidget.SelectionEntry<OBJECT> sel) {
        if (this.selection == null) {
            return;
        }
        this.selectEnum.setEntries(switch ((OBJECT)((Object)sel.reference)) {
            case OBJECT.ITEMS -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.ITEM_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.ITEM_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.HELD, ModifierDataType.WORN});
                }
                yield new ArrayList();
            }
            case OBJECT.BLOCKS -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.BLOCK_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.BLOCK_APPLICABLE_EVENTS);
                }
                yield new ArrayList();
            }
            case OBJECT.ENTITY -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.ENTITY_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.ENTITY_APPLICABLE_EVENTS);
                }
                yield new ArrayList();
            }
            case OBJECT.DIMENSIONS -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.TRAVEL});
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.DIMENSION});
                }
                yield new ArrayList();
            }
            case OBJECT.BIOMES -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.TRAVEL});
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.BIOME});
                }
                yield new ArrayList();
            }
            case OBJECT.ENCHANTS -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.USE_ENCHANTMENT});
                }
                yield new ArrayList();
            }
            default -> new ArrayList();
        });
    }

    private List<SelectionWidget.SelectionEntry<GuiEnumGroup>> enumToList(GuiEnumGroup[] array) {
        return Arrays.stream(array).map(val -> new SelectionWidget.SelectionEntry<GuiEnumGroup>((Component)Component.m_237115_((String)("pmmo.enum." + val.getName())), (GuiEnumGroup)val)).toList();
    }

    public static enum SELECTION {
        REQS(LangProvider.GLOSSARY_SECTION_REQ.asComponent(), Arrays.stream(OBJECT.values()).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        XP(LangProvider.GLOSSARY_SECTION_XP.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.BLOCKS, OBJECT.ENTITY, OBJECT.EFFECTS}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        BONUS(LangProvider.GLOSSARY_SECTION_BONUS.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        SALVAGE(LangProvider.GLOSSARY_SECTION_SALVAGE.asComponent(), List.of(new SelectionWidget.SelectionEntry<OBJECT>((Component)OBJECT.ITEMS.text, OBJECT.ITEMS))),
        VEIN(LangProvider.GLOSSARY_SECTION_VEIN.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.BLOCKS, OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        MOB_SCALING(LangProvider.GLOSSARY_SECTION_MOB.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        PERKS(LangProvider.GLOSSARY_SECTION_PERKS.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.PERKS}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList());

        MutableComponent text;
        List<SelectionWidget.SelectionEntry<OBJECT>> validObjects;
        public static final List<SelectionWidget.SelectionEntry<SELECTION>> CHOICE_LIST;

        private SELECTION(MutableComponent text, List<SelectionWidget.SelectionEntry<OBJECT>> validObjects) {
            this.text = text;
            this.validObjects = validObjects;
        }

        static {
            CHOICE_LIST = Arrays.stream(SELECTION.values()).map(val -> new SelectionWidget.SelectionEntry<SELECTION>((Component)val.text, (SELECTION)((Object)val))).toList();
        }
    }

    public static enum OBJECT {
        ITEMS(LangProvider.GLOSSARY_OBJECT_ITEMS.asComponent()),
        BLOCKS(LangProvider.GLOSSARY_OBJECT_BLOCKS.asComponent()),
        ENTITY(LangProvider.GLOSSARY_OBJECT_ENTITIES.asComponent()),
        DIMENSIONS(LangProvider.GLOSSARY_OBJECT_DIMENSIONS.asComponent()),
        BIOMES(LangProvider.GLOSSARY_OBJECT_BIOMES.asComponent()),
        ENCHANTS(LangProvider.GLOSSARY_OBJECT_ENCHANTS.asComponent()),
        EFFECTS(LangProvider.GLOSSARY_OBJECT_EFFECTS.asComponent()),
        PERKS(LangProvider.GLOSSARY_OBJECT_PERKS.asComponent());

        MutableComponent text;
        public static final List<SelectionWidget.SelectionEntry<OBJECT>> CHOICE_LIST;

        private OBJECT(MutableComponent text) {
            this.text = text;
        }

        static {
            CHOICE_LIST = Arrays.stream(OBJECT.values()).map(val -> new SelectionWidget.SelectionEntry<OBJECT>((Component)val.text, (OBJECT)((Object)val))).toList();
        }
    }
}

