/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_SyncData_ClearXp;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;

public class CmdNodeAdmin {
    private static final String SKILL_ARG = "Skill Name";
    private static final String TARGET_ARG = "Target";
    private static final String TYPE_ARG = "Change Type";
    private static final String VALUE_ARG = "New Value";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(p -> p.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)TARGET_ARG, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(SkillsConfig.SKILLS.get().keySet(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, true))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(SkillsConfig.SKILLS.get().keySet(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, false))))))).then(Commands.m_82127_((String)"clear").executes(ctx -> CmdNodeAdmin.adminClear((CommandContext<CommandSourceStack>)ctx)))).executes(ctx -> CmdNodeAdmin.displayPlayer((CommandContext<CommandSourceStack>)ctx)));
    }

    public static int adminSetOrAdd(CommandContext<CommandSourceStack> ctx, boolean isSet) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(ctx, (String)TARGET_ARG);
        String skillName = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        boolean isLevel = StringArgumentType.getString(ctx, (String)TYPE_ARG).equalsIgnoreCase("level");
        Long value = LongArgumentType.getLong(ctx, (String)VALUE_ARG);
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : players) {
            if (isSet) {
                if (isLevel) {
                    data.setPlayerSkillLevel(skillName, player.m_20148_(), value.intValue());
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)LangProvider.SET_LEVEL.asComponent(skillName, value, player.m_7755_()), true);
                    continue;
                }
                data.setXpRaw(player.m_20148_(), skillName, value);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)LangProvider.SET_XP.asComponent(skillName, value, player.m_7755_()), true);
                continue;
            }
            if (isLevel) {
                data.changePlayerSkillLevel(skillName, player.m_20148_(), value.intValue());
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)LangProvider.ADD_LEVEL.asComponent(skillName, value, player.m_7755_()), true);
                continue;
            }
            data.setXpDiff(player.m_20148_(), skillName, value);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)LangProvider.ADD_XP.asComponent(skillName, value, player.m_7755_()), true);
        }
        return 0;
    }

    public static int adminClear(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)TARGET_ARG)) {
            data.setXpMap(player.m_20148_(), new HashMap<String, Long>());
            Networking.sendToClient(new CP_SyncData_ClearXp(), player);
        }
        return 0;
    }

    public static int displayPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)TARGET_ARG)) {
            ((CommandSourceStack)ctx.getSource()).m_81354_(player.m_7755_(), false);
            for (Map.Entry<String, Long> skillMap : data.getXpMap(player.m_20148_()).entrySet()) {
                int level = data.getLevelFromXP(skillMap.getValue());
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237113_((String)(skillMap.getKey() + ": " + level + " | " + skillMap.getValue())), false);
            }
        }
        return 0;
    }
}

