/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.NBTUtils;
import harmonised.pmmo.util.Functions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public record ObjectData(boolean override, Set<String> tagValues, Map<ReqType, Map<String, Integer>> reqs, Map<ReqType, List<LogicEntry>> nbtReqs, Map<ResourceLocation, Integer> negativeEffects, Map<EventType, Map<String, Long>> xpValues, Map<EventType, List<LogicEntry>> nbtXpValues, Map<ModifierDataType, Map<String, Double>> bonuses, Map<ModifierDataType, List<LogicEntry>> nbtBonuses, Map<ResourceLocation, CodecTypes.SalvageData> salvage, VeinData veinData) implements DataSource<ObjectData>
{
    private final Map<ResourceLocation, CodecTypes.SalvageData> salvage;
    public static final Codec<ObjectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(od -> Optional.of(od.override())), (App)Codec.STRING.listOf().optionalFieldOf("isTagFor").forGetter(od -> Optional.of(new ArrayList<String>(od.tagValues))), (App)Codec.optionalField((String)"requirements", (Codec)Codec.simpleMap(ReqType.CODEC, CodecTypes.INTEGER_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ReqType.values())).codec()).forGetter(od -> Optional.of(od.reqs())), (App)Codec.optionalField((String)"nbt_requirements", (Codec)Codec.simpleMap(ReqType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ReqType.values())).codec()).forGetter(od -> Optional.of(od.nbtReqs())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).optionalFieldOf("negative_effect").forGetter(od -> Optional.of(od.negativeEffects())), (App)Codec.optionalField((String)"xp_values", (Codec)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])EventType.values())).codec()).forGetter(od -> Optional.of(od.xpValues())), (App)Codec.optionalField((String)"nbt_xp_values", (Codec)Codec.simpleMap(EventType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])EventType.values())).codec()).forGetter(od -> Optional.of(od.nbtXpValues())), (App)Codec.optionalField((String)"bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ModifierDataType.values())).codec()).forGetter(od -> Optional.of(od.bonuses())), (App)Codec.optionalField((String)"nbt_bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ModifierDataType.values())).codec()).forGetter(od -> Optional.of(od.nbtBonuses())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CodecTypes.SALVAGE_CODEC).optionalFieldOf("salvage").forGetter(od -> Optional.of(od.salvage())), (App)VeinData.VEIN_DATA_CODEC.optionalFieldOf("vein_data").forGetter(od -> Optional.of(od.veinData()))).apply((Applicative)instance, (override, tags, reqs, nbtreqs, effects, xp, nbtXp, bonus, nbtbonus, salvage, vein) -> new ObjectData(override.orElse(false), new HashSet<String>(tags.orElse(List.of())), DataSource.clearEmptyValues(reqs.orElse(new HashMap())), DataSource.clearEmptyValues(nbtreqs.orElse(new HashMap())), DataSource.clearEmptyValues(effects.orElse(new HashMap())), DataSource.clearEmptyValues(xp.orElse(new HashMap())), DataSource.clearEmptyValues(nbtXp.orElse(new HashMap())), DataSource.clearEmptyValues(bonus.orElse(new HashMap())), DataSource.clearEmptyValues(nbtbonus.orElse(new HashMap())), DataSource.clearEmptyValues(salvage.orElse(new HashMap())), vein.orElse(VeinData.EMPTY))));

    public ObjectData() {
        this(false, new HashSet<String>(), new HashMap<ReqType, Map<String, Integer>>(), new HashMap<ReqType, List<LogicEntry>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<EventType, Map<String, Long>>(), new HashMap<EventType, List<LogicEntry>>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
    }

    public Map<ResourceLocation, CodecTypes.SalvageData> salvage() {
        return this.salvage.entrySet().stream().filter(entry -> !((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey())).equals(Items.f_41852_)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, Long> getXpValues(EventType type, CompoundTag nbt) {
        return this.nbtXpValues().get(type) == null ? (Map)this.xpValues().getOrDefault(type, new HashMap()) : NBTUtils.getExperienceAward(this.nbtXpValues().get(type), nbt);
    }

    @Override
    public void setXpValues(EventType type, Map<String, Long> award) {
        this.xpValues().put(type, award);
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.nbtBonuses().get(type) == null ? (Map)this.bonuses().getOrDefault(type, new HashMap()) : NBTUtils.getBonuses(this.nbtBonuses().get(type), nbt);
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonuses().put(type, bonuses);
    }

    @Override
    public Map<String, Integer> getReqs(ReqType type, CompoundTag nbt) {
        return this.nbtReqs().get(type) == null ? (Map)this.reqs().getOrDefault(type, new HashMap()) : NBTUtils.getRequirement(this.nbtReqs().get(type), nbt);
    }

    @Override
    public void setReqs(ReqType type, Map<String, Integer> reqs) {
        this.reqs().put(type, reqs);
    }

    @Override
    public Map<ResourceLocation, Integer> getNegativeEffect() {
        return this.negativeEffects();
    }

    @Override
    public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
        this.negativeEffects().clear();
        this.negativeEffects().putAll(neg);
    }

    @Override
    public Set<String> getTagValues() {
        return this.tagValues();
    }

    @Override
    public ObjectData combine(ObjectData two) {
        HashSet<String> tagValues = new HashSet<String>();
        HashMap<EventType, Map<String, Long>> xpValues = new HashMap<EventType, Map<String, Long>>();
        HashMap<ModifierDataType, Map<String, Double>> bonuses = new HashMap<ModifierDataType, Map<String, Double>>();
        HashMap<ReqType, Map<String, Integer>> reqs = new HashMap<ReqType, Map<String, Integer>>();
        HashMap<ResourceLocation, Integer> reqEffects = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, CodecTypes.SalvageData> salvage = new HashMap<ResourceLocation, CodecTypes.SalvageData>();
        VeinData[] combinedVein = new VeinData[]{this.veinData()};
        BiConsumer<ObjectData, ObjectData> bothOrNeither = (o, t) -> {
            tagValues.addAll(o.tagValues());
            t.tagValues.forEach(rl -> {
                if (!tagValues.contains(rl)) {
                    tagValues.add((String)rl);
                }
            });
            xpValues.putAll(o.xpValues());
            t.xpValues().forEach((event, map) -> xpValues.merge((EventType)event, (Map<String, Long>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            bonuses.putAll(o.bonuses());
            t.bonuses().forEach((event, map) -> bonuses.merge((ModifierDataType)event, (Map<String, Double>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            reqs.putAll(o.reqs());
            t.reqs().forEach((event, map) -> reqs.merge((ReqType)event, (Map<String, Integer>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            reqEffects.putAll(o.negativeEffects());
            t.negativeEffects().forEach((skill, level) -> reqEffects.merge((ResourceLocation)skill, (Integer)level, (o1, n1) -> o1 > n1 ? o1 : n1));
            salvage.putAll(o.salvage());
            t.salvage().forEach((rl, data) -> salvage.merge((ResourceLocation)rl, (CodecTypes.SalvageData)data, (oD, nD) -> CodecTypes.SalvageData.combine(oD, nD, o.override(), t.override())));
            combinedVein[0] = combinedVein[0].combine(t.veinData());
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            tagValues.addAll(o.tagValues().isEmpty() ? t.tagValues() : o.tagValues());
            xpValues.putAll(o.xpValues().isEmpty() ? t.xpValues() : o.xpValues());
            bonuses.putAll(o.bonuses().isEmpty() ? t.bonuses() : o.bonuses());
            reqs.putAll(o.reqs().isEmpty() ? t.reqs() : o.reqs());
            reqEffects.putAll(o.negativeEffects().isEmpty() ? t.negativeEffects() : o.negativeEffects());
            salvage.putAll(o.salvage().isEmpty() ? t.salvage() : o.salvage());
            combinedVein[0] = o.veinData().isUnconfigured() ? t.veinData() : o.veinData();
        }, bothOrNeither, bothOrNeither);
        return new ObjectData(this.override() || two.override(), tagValues, reqs, two.nbtReqs(), reqEffects, xpValues, two.nbtXpValues(), bonuses, two.nbtBonuses(), salvage, combinedVein[0]);
    }

    @Override
    public boolean isUnconfigured() {
        return this.reqs().values().stream().allMatch(map -> map.isEmpty()) && this.nbtReqs().values().stream().allMatch(map -> map.isEmpty()) && this.negativeEffects().isEmpty() && this.xpValues().values().stream().allMatch(map -> map.isEmpty()) && this.nbtXpValues().values().stream().allMatch(map -> map.isEmpty()) && this.bonuses().values().stream().allMatch(map -> map.isEmpty()) && this.nbtBonuses().values().stream().allMatch(map -> map.isEmpty()) && this.salvage().keySet().stream().allMatch(rl -> rl.equals((Object)new ResourceLocation("item"))) && this.veinData().isUnconfigured();
    }
}

