/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.commands.CommandFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.function.TriFunction;

public class FeaturePerks {
    private static final CompoundTag NONE = new CompoundTag();
    private static final Map<String, Attribute> attributeCache = new HashMap<String, Attribute>();
    public static final Perk ATTRIBUTE = Perk.begin().addDefaults(TagBuilder.start().withDouble("max_boost", 0.0).withDouble("per_level", 0.0).withDouble("base", 0.0).withBool("multiplicative", false).build()).setStart((player, nbt) -> {
        double perLevel = nbt.m_128459_("per_level");
        double maxBoost = nbt.m_128459_("max_boost");
        AttributeInstance instance = player.m_21051_(FeaturePerks.getAttribute(nbt));
        double boost = Math.min(perLevel * (double)nbt.m_128451_("level"), maxBoost) + nbt.m_128459_("base");
        AttributeModifier.Operation operation = nbt.m_128471_("multiplicative") ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
        UUID attributeID = Functions.getReliableUUID(nbt.m_128461_("attribute") + "/" + nbt.m_128461_("skill"));
        AttributeModifier modifier = new AttributeModifier(attributeID, "PMMO-modifier based on user skill", boost, operation);
        instance.m_22120_(attributeID);
        instance.m_22125_(modifier);
        return NONE;
    }).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
        double perLevel = settings.m_128459_("per_level");
        String skillname = settings.m_128461_("skill");
        int skillLevel = settings.m_128451_("level");
        return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(Component.m_237115_((String)FeaturePerks.getAttribute(settings).m_22087_())), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(perLevel, Component.m_237115_((String)("pmmo." + skillname))), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(perLevel * (double)skillLevel));
    }).build();
    public static final Perk TEMP_ATTRIBUTE = Perk.begin().addDefaults(TagBuilder.start().withDouble("max_boost", 0.0).withDouble("per_level", 0.0).withDouble("base", 0.0).withBool("multiplicative", false).build()).setStart((player, nbt) -> {
        double perLevel = nbt.m_128459_("per_level");
        double maxBoost = nbt.m_128459_("max_boost");
        AttributeInstance instance = player.m_21051_(FeaturePerks.getAttribute(nbt));
        double boost = Math.min(perLevel * (double)nbt.m_128451_("level"), maxBoost) + nbt.m_128459_("base");
        AttributeModifier.Operation operation = nbt.m_128471_("multiplicative") ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
        UUID attributeID = Functions.getReliableUUID(nbt.m_128461_("attribute") + "/" + nbt.m_128461_("skill"));
        AttributeModifier modifier = new AttributeModifier(attributeID, "PMMO-modifier based on user skill", boost, operation);
        instance.m_22120_(attributeID);
        instance.m_22118_(modifier);
        return NONE;
    }).setStop((player, nbt) -> {
        UUID attributeID = Functions.getReliableUUID(nbt.m_128461_("attribute") + "/" + nbt.m_128461_("skill"));
        player.m_21051_(FeaturePerks.getAttribute(nbt)).m_22120_(attributeID);
        return NONE;
    }).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
        double perLevel = settings.m_128459_("per_level");
        String skillname = settings.m_128461_("skill");
        int skillLevel = settings.m_128451_("level");
        return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(Component.m_237115_((String)FeaturePerks.getAttribute(settings).m_22087_())), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(perLevel, Component.m_237115_((String)("pmmo." + skillname))), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(perLevel * (double)skillLevel));
    }).build();
    public static BiFunction<Player, CompoundTag, CompoundTag> EFFECT_SETTER = (player, nbt) -> {
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_("effect")));
        if (effect != null) {
            int configDuration = nbt.m_128451_("duration");
            int duration = player.m_21023_(effect) && player.m_21124_(effect).m_19557_() > configDuration ? player.m_21124_(effect).m_19557_() : configDuration;
            int perLevel = nbt.m_128451_("per_level");
            int amplifier = nbt.m_128451_("modifier");
            boolean ambient = nbt.m_128471_("ambient");
            boolean visible = nbt.m_128471_("visible");
            player.m_7292_(new MobEffectInstance(effect, perLevel * duration, amplifier, ambient, visible));
        }
        return NONE;
    };
    public static final Perk EFFECT = Perk.begin().addDefaults(TagBuilder.start().withString("effect", "modid:effect").withInt("duration", 100).withInt("per_level", 1).withInt("modifier", 0).withBool("ambient", false).withBool("visible", true).build()).setStart(EFFECT_SETTER).setTick((TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(player, nbt, ticks) -> EFFECT_SETTER.apply((Player)player, (CompoundTag)nbt))).setDescription(LangProvider.PERK_EFFECT_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_EFFECT_STATUS_1.asComponent(Component.m_237115_((String)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_("effect")))).m_19481_())), LangProvider.PERK_EFFECT_STATUS_2.asComponent(nbt.m_128451_("modifier"), nbt.m_128451_("duration")))).build();
    private static BiFunction<Player, CompoundTag, List<MutableComponent>> JUMP_LINES = (player, nbt) -> List.of(LangProvider.PERK_JUMP_BOOST_STATUS_1.asComponent(nbt.m_128451_("per_level") * nbt.m_128451_("level")));
    private static CompoundTag JUMP_DEFAULTS = TagBuilder.start().withDouble("per_level", 5.0E-4).withDouble("max_boost", 0.25).build();
    public static final Perk JUMP_CLIENT = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.m_128459_("max_boost"), -0.011 + (double)nbt.m_128451_("level") * nbt.m_128459_("per_level"));
        player.m_20256_(player.m_20184_().m_82520_(0.0, jumpBoost, 0.0));
        player.f_19864_ = true;
        return NONE;
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk JUMP_SERVER = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.m_128459_("max_boost"), -0.011 + (double)nbt.m_128451_("level") * nbt.m_128459_("per_level"));
        return TagBuilder.start().withDouble("jump_boost_output", player.m_20184_().f_82480_ + jumpBoost).build();
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk BREATH = Perk.begin().addConditions((player, nbt) -> player.m_20146_() < 2).addDefaults(TagBuilder.start().withLong("cooldown", 600L).withDouble("per_level", 1.0).build()).setStart((player, nbt) -> {
        int perLevel = Math.max(1, (int)((double)nbt.m_128451_("level") * nbt.m_128459_("per_level")));
        player.m_20301_(player.m_20146_() + perLevel);
        player.m_213846_((Component)LangProvider.PERK_BREATH_REFRESH.asComponent());
        return NONE;
    }).setDescription(LangProvider.PERK_BREATH_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_BREATH_STATUS_1.asComponent((int)((double)nbt.m_128451_("level") * nbt.m_128459_("per_level"))), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.m_128451_("cooldown") / 20))).build();
    public static final Perk FALL_SAVE = Perk.begin().addDefaults(TagBuilder.start().withDouble("per_level", 0.025).withFloat("damageIn", 0.0f).build()).setStart((player, nbt) -> {
        float saved = (int)(nbt.m_128459_("per_level") * (double)nbt.m_128451_("level"));
        return TagBuilder.start().withFloat("damage", Math.max(nbt.m_128457_("damageIn") - saved, 0.0f)).build();
    }).setDescription(LangProvider.PERK_FALL_SAVE_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_FALL_SAVE_STATUS_1.asComponent((double)nbt.m_128451_("level") * nbt.m_128459_("per_level")), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.m_128451_("cooldown") / 20))).build();
    public static final String APPLICABLE_TO = "applies_to";
    public static final Perk DAMAGE_BOOST = Perk.begin().addConditions((player, nbt) -> {
        List<String> type = nbt.m_128437_(APPLICABLE_TO, 8).stream().map(tag -> tag.m_7916_()).toList();
        for (String key : type) {
            if (key.startsWith("#") && ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(key.substring(1)))).stream().anyMatch(item -> player.m_21205_().m_41720_().equals(item))) {
                return true;
            }
            if (key.endsWith(":*") && ForgeRegistries.ITEMS.getValues().stream().anyMatch(item -> player.m_21205_().m_41720_().equals(item))) {
                return true;
            }
            if (!key.equals(RegistryUtil.getId(player.m_21205_()).toString())) continue;
            return true;
        }
        return false;
    }).addDefaults(TagBuilder.start().withFloat("damageIn", 0.0f).withList("applies_to", new Tag[]{StringTag.m_129297_((String)"weapon:id")}).withDouble("per_level", 0.05).withDouble("base", 1.0).withBool("multiplicative", true).build()).setStart((player, nbt) -> {
        float damageModification = (float)(nbt.m_128459_("base") + nbt.m_128459_("per_level") * (double)nbt.m_128451_("level"));
        float damage = nbt.m_128471_("multiplicative") ? nbt.m_128457_("damageIn") * damageModification : nbt.m_128457_("damageIn") + damageModification;
        return TagBuilder.start().withFloat("damage", damage).build();
    }).setDescription(LangProvider.PERK_DAMAGE_BOOST_DESC.asComponent()).setStatus((player, nbt) -> {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        MutableComponent line1 = LangProvider.PERK_DAMAGE_BOOST_STATUS_1.asComponent();
        for (Tag entry : nbt.m_128437_(APPLICABLE_TO, 8)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.m_7916_()));
            line1.m_7220_((Component)(item.equals(Items.f_41852_) ? Component.m_237113_((String)entry.m_7916_()) : item.m_41466_()));
            line1.m_7220_((Component)Component.m_237113_((String)", "));
        }
        lines.add(line1);
        lines.add(LangProvider.PERK_DAMAGE_BOOST_STATUS_2.asComponent(nbt.m_128471_("multiplicative") ? "x" : "+", (double)nbt.m_128451_("level") * nbt.m_128459_("per_level")));
        return lines;
    }).build();
    private static final String COMMAND = "command";
    private static final String FUNCTION = "function";
    public static final Perk RUN_COMMAND = Perk.begin().setStart((p, nbt) -> {
        if (!(p instanceof ServerPlayer)) {
            return NONE;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (nbt.m_128441_(FUNCTION)) {
            player.m_20194_().m_129890_().m_136112_((CommandFunction)player.m_20194_().m_129890_().m_136118_(new ResourceLocation(nbt.m_128461_(FUNCTION))).get(), player.m_20203_().m_81324_().m_81358_(2));
        } else if (nbt.m_128441_(COMMAND)) {
            player.m_20194_().m_129892_().m_230957_(player.m_20203_().m_81324_().m_81358_(2), nbt.m_128461_(COMMAND));
        }
        return NONE;
    }).setDescription(LangProvider.PERK_COMMAND_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_COMMAND_STATUS_1.asComponent(nbt.m_128441_(FUNCTION) ? "Function" : "Command", nbt.m_128441_(FUNCTION) ? nbt.m_128461_(FUNCTION) : nbt.m_128461_(COMMAND)))).build();

    private static Attribute getAttribute(CompoundTag nbt) {
        return attributeCache.computeIfAbsent(nbt.m_128461_("attribute"), name -> (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(name)));
    }
}

