/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageDealtHandler {
    public static void handle(LivingAttackEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            Player player = (Player)event.getSource().m_7639_();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.f_19853_);
            EventType type = DamageDealtHandler.getEventCategory(event.getSource().m_269533_(Reference.FROM_RANGED), event.getEntity());
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + type.name() + " | TargetType: " + target.m_6095_().toString(), new Object[0]);
            if (!core.isActionPermitted(ReqType.WEAPON, player.m_21205_(), player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.WEAPON, player, player.m_21205_().m_41611_());
                return;
            }
            if (!core.isActionPermitted(ReqType.KILL, (Entity)target, player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.KILL, player, target.m_5446_());
                return;
            }
            boolean serverSide = !player.f_19853_.f_46443_;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
        }
    }

    public static void handle(LivingDamageEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            Player player = (Player)event.getSource().m_7639_();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.f_19853_);
            EventType type = DamageDealtHandler.getEventCategory(event.getSource().m_269533_(Reference.FROM_RANGED), event.getEntity());
            CompoundTag perkOutput = core.getPerkRegistry().executePerk(type, player, TagBuilder.start().withFloat("damageIn", event.getAmount()).build());
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Pre-Perk Damage:" + event.getAmount(), new Object[0]);
            if (perkOutput.m_128441_("damage")) {
                event.setAmount(perkOutput.m_128457_("damage"));
            }
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + type.name() + " | Damage Out: " + event.getAmount(), new Object[0]);
            if (!player.f_19853_.f_46443_) {
                Map<String, Long> xpAward = DamageDealtHandler.getExperienceAwards(core, type, target, event.getAmount(), event.getSource(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, EventType type, LivingEntity target, float damage, DamageSource source, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Math.min(damage, target.m_21223_());
        ItemStack weapon = player.m_21205_();
        Player srcEntity = source.m_269533_(Reference.FROM_RANGED) ? source.m_7640_() : player;
        switch (type) {
            case MELEE_TO_MOBS: 
            case MELEE_TO_ANIMALS: 
            case MELEE_TO_PLAYERS: 
            case RANGED_TO_MOBS: 
            case RANGED_TO_ANIMALS: 
            case RANGED_TO_PLAYERS: {
                Functions.mergeMaps(core.getExperienceAwards(type, weapon, player, dataIn), core.getExperienceAwards(type, (Entity)srcEntity, player, dataIn), core.getExperienceAwards(type, (Entity)target, player, dataIn)).forEach((skill, value) -> mapOut.put((String)skill, (long)((float)value.longValue() * ultimateDamage)));
                break;
            }
            case DEAL_MELEE_DAMAGE: {
                Config.DEAL_MELEE_DAMAGE_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.DEAL_MELEE_DAMAGE_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case DEAL_RANGED_DAMAGE: {
                Config.DEAL_RANGED_DAMAGE_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.DEAL_RANGED_DAMAGE_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            default: {
                return new HashMap<String, Long>();
            }
        }
        return mapOut;
    }

    private static EventType getEventCategory(boolean projectileSource, LivingEntity target) {
        if (projectileSource) {
            if (target.m_6095_().m_204039_(Reference.MOB_TAG)) {
                return EventType.RANGED_TO_MOBS;
            }
            if (target.m_6095_().m_204039_(Reference.ANIMAL_TAG)) {
                return EventType.RANGED_TO_ANIMALS;
            }
            if (target.m_6095_().equals(EntityType.f_20532_)) {
                return EventType.RANGED_TO_PLAYERS;
            }
            return EventType.DEAL_RANGED_DAMAGE;
        }
        if (target.m_6095_().m_204039_(Reference.MOB_TAG)) {
            return EventType.MELEE_TO_MOBS;
        }
        if (target.m_6095_().m_204039_(Reference.ANIMAL_TAG)) {
            return EventType.MELEE_TO_ANIMALS;
        }
        if (target.m_6095_().equals(EntityType.f_20532_)) {
            return EventType.MELEE_TO_PLAYERS;
        }
        return EventType.DEAL_MELEE_DAMAGE;
    }
}

