/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageReceivedHandler {
    public static void handle(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            EventType type = DamageReceivedHandler.getSourceCategory(event.getSource());
            if (type.equals(EventType.FROM_PLAYERS) && player.equals((Object)event.getSource().m_7639_())) {
                return;
            }
            Core core = Core.get(player.m_9236_());
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + type.name() + " | Source Raw: " + event.getSource().m_19385_(), new Object[0]);
            boolean serverSide = !player.f_19853_.f_46443_;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            CompoundTag perkDataIn = eventHookOutput;
            perkDataIn.m_128350_("damageIn", event.getAmount());
            CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(type, player, perkDataIn));
            if (perkOutput.m_128441_("damage")) {
                event.setAmount(perkOutput.m_128457_("damage"));
            }
            if (serverSide) {
                Map<String, Long> xpAward = DamageReceivedHandler.getExperienceAwards(core, type, event.getSource(), event.getAmount(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, EventType type, DamageSource source, float damage, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Mth.m_14036_((float)damage, (float)0.0f, (float)player.m_21223_());
        switch (type) {
            case FROM_PLAYERS: 
            case FROM_MOBS: 
            case FROM_ANIMALS: {
                core.getExperienceAwards(type, source.m_7639_(), player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)((float)value.longValue() * ultimateDamage)));
                break;
            }
            case FROM_ENVIRONMENT: {
                Config.FROM_ENVIRONMENT_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_ENVIRONMENT_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case FROM_IMPACT: {
                Config.FROM_IMPACT_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_IMPACT_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case FROM_MAGIC: {
                Config.FROM_MAGIC_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.FROM_MAGIC_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            case RECEIVE_DAMAGE: 
            case FROM_PROJECTILES: {
                Entity uncategorizedEntity = source.m_7639_();
                if (uncategorizedEntity != null) {
                    core.getExperienceAwards(type, uncategorizedEntity, player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)((float)value.longValue() * ultimateDamage)));
                    break;
                }
                Config.RECEIVE_DAMAGE_XP.get().keySet().forEach(skill -> {
                    Double value = (double)ultimateDamage * Config.RECEIVE_DAMAGE_XP.get().getOrDefault(skill, 0.0) * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                    mapOut.put((String)skill, value.longValue());
                });
                break;
            }
            default: {
                return new HashMap<String, Long>();
            }
        }
        return mapOut;
    }

    private static EventType getSourceCategory(DamageSource source) {
        if (((DamageType)source.m_269150_().get()).f_268677_().equals("player")) {
            return EventType.FROM_PLAYERS;
        }
        if (source.m_269533_(Reference.FROM_ENVIRONMENT)) {
            return EventType.FROM_ENVIRONMENT;
        }
        if (source.m_269533_(Reference.FROM_IMPACT)) {
            return EventType.FROM_IMPACT;
        }
        if (source.m_269533_(Reference.FROM_MAGIC)) {
            return EventType.FROM_MAGIC;
        }
        if (source.m_7639_() != null) {
            if (source.m_7639_().m_6095_().m_204039_(Reference.MOB_TAG)) {
                return EventType.FROM_MOBS;
            }
            if (source.m_7639_().m_6095_().m_204039_(Reference.ANIMAL_TAG)) {
                return EventType.FROM_ANIMALS;
            }
        }
        if (source.m_269533_(Reference.FROM_RANGED)) {
            return EventType.FROM_PROJECTILES;
        }
        return EventType.RECEIVE_DAMAGE;
    }
}

