/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerClickHandler {
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.f_19853_);
        boolean bl = serverSide = !player.f_19853_.f_46443_;
        if (!core.isActionPermitted(ReqType.INTERACT, event.getPos(), player)) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (!core.isActionPermitted(ReqType.INTERACT, event.getItemStack(), player)) {
            event.setUseItem(Event.Result.DENY);
        }
        if (event.getUseBlock().equals((Object)Event.Result.DENY)) {
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide) {
            hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.HIT_BLOCK, (Event)event, hookOutput);
            if (hookOutput.m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            if (hookOutput.m_128471_("deny_block")) {
                event.setUseBlock(Event.Result.DENY);
            }
            if (hookOutput.m_128471_("deny_item")) {
                event.setUseItem(Event.Result.DENY);
            }
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.HIT_BLOCK, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.HIT_BLOCK, event.getPos(), player.m_9236_(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.f_19853_);
        boolean bl = serverSide = !player.f_19853_.f_46443_;
        if (!core.isActionPermitted(ReqType.INTERACT, event.getPos(), player)) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (!core.isActionPermitted(ReqType.INTERACT, event.getItemStack(), player)) {
            event.setUseItem(Event.Result.DENY);
        }
        if (event.getUseBlock().equals((Object)Event.Result.DENY) && !serverSide && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
            Messenger.sendDenialMsg(ReqType.INTERACT, player, event.getLevel().m_8055_(event.getPos()).m_60734_().m_49954_());
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide) {
            hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.ACTIVATE_BLOCK, (Event)event, hookOutput);
            if (hookOutput.m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            if (player.m_6047_() && RegistryUtil.getId(event.getLevel().m_8055_(event.getPos()).m_60734_()).equals((Object)new ResourceLocation((String)Config.SALVAGE_BLOCK.get()))) {
                core.getSalvage((ServerPlayer)player);
            }
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.ACTIVATE_BLOCK, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.ACTIVATE_BLOCK, event.getPos(), player.m_9236_(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.f_19853_);
        boolean bl = serverSide = !player.f_19853_.f_46443_;
        if (!core.isActionPermitted(ReqType.USE, event.getItemStack(), player)) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.USE, player, event.getItemStack());
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide && (hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.ACTIVATE_ITEM, (Event)event, hookOutput)).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            return;
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.ACTIVATE_ITEM, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.ACTIVATE_ITEM, event.getItemStack(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

