/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLootConditionKill
implements LootItemCondition {
    private String skill;
    private Integer levelMin;
    private Integer levelMax;

    public SkillLootConditionKill(Integer levelMin, Integer levelMax, String skill) {
        this.levelMin = levelMin;
        this.levelMax = levelMax;
        this.skill = skill;
    }

    public boolean test(LootContext t) {
        if (!((Boolean)Config.TREASURE_ENABLED.get()).booleanValue()) {
            return false;
        }
        Entity player = (Entity)t.m_78953_(LootContextParams.f_81458_);
        if (player == null || this.skill == null) {
            return false;
        }
        int actualLevel = Core.get(player.f_19853_).getData().getPlayerSkillLevel(this.skill, player.m_20148_());
        return !(this.levelMin != null && actualLevel < this.levelMin || this.levelMax != null && actualLevel > this.levelMax);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)GLMRegistry.SKILL_KILL.get();
    }

    public static final class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SkillLootConditionKill> {
        public void serialize(JsonObject json, SkillLootConditionKill itemCondition, @Nonnull JsonSerializationContext context) {
            json.addProperty("skill", itemCondition.skill);
            json.addProperty("level_min", (Number)itemCondition.levelMin);
            json.addProperty("level_max", (Number)itemCondition.levelMax);
        }

        @Nonnull
        public SkillLootConditionKill deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            Integer levelMin = GsonHelper.m_13927_((JsonObject)json, (String)"level_min");
            Integer levelMax = GsonHelper.m_13927_((JsonObject)json, (String)"level_max");
            String skill = GsonHelper.m_13906_((JsonObject)json, (String)"skill");
            return new SkillLootConditionKill(levelMin, levelMax, skill);
        }
    }
}

