/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TreasureLootModifier
extends LootModifier {
    public static final Codec<TreasureLootModifier> CODEC = RecordCodecBuilder.create(instance -> TreasureLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(tlm -> RegistryUtil.getId(tlm.drop)), (App)Codec.INT.fieldOf("count").forGetter(tlm -> tlm.count), (App)Codec.DOUBLE.fieldOf("chance").forGetter(tlm -> tlm.chance))).apply((Applicative)instance, TreasureLootModifier::new));
    public ItemStack drop;
    private final int count;
    public double chance;

    public TreasureLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = lootItemID.equals((Object)new ResourceLocation("air")) ? Items.f_41852_.m_7968_() : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(lootItemID));
        this.drop.m_41764_(count);
        this.count = count;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188500_() <= this.chance) {
            Entity breaker;
            BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            if (state != null && this.drop.m_41720_() == Items.f_41852_) {
                this.drop = (ItemStack)state.m_60724_(new LootContext.Builder(context)).get(0);
                this.drop.m_41764_(this.count);
            }
            if ((breaker = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof Player) {
                Player player = (Player)breaker;
                player.m_213846_((Component)LangProvider.FOUND_TREASURE.asComponent());
            }
            generatedLoot.add((Object)this.drop.m_41777_());
        }
        return generatedLoot;
    }
}

