/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.storage.ChunkDataHandler;
import harmonised.pmmo.storage.IChunkData;
import harmonised.pmmo.util.MsLoggy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChunkDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation CHUNK_CAP_ID = new ResourceLocation("pmmo", "placed_data");
    public static final Capability<IChunkData> CHUNK_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkData>(){});
    private final ChunkDataHandler backend = new ChunkDataHandler();
    private LazyOptional<IChunkData> instance = LazyOptional.of(() -> this.backend);
    private static final Codec<Map<BlockPos, UUID>> CODEC = Codec.unboundedMap(CodecTypes.BLOCKPOS_CODEC, (Codec)UUIDUtil.f_235867_);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CHUNK_CAP ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        Map<BlockPos, UUID> unserializedMap = ((IChunkData)this.getCapability(CHUNK_CAP, null).orElse((Object)this.backend)).getMap();
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.CHUNK, "Serialized Chunk Cap: " + MsLoggy.mapToString(unserializedMap), new Object[0]);
        CompoundTag nbt = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, unserializedMap).resultOrPartial(msg -> MsLoggy.ERROR.log(MsLoggy.LOG_CODE.CHUNK, (String)msg, new Object[0])).orElse(new CompoundTag());
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.CHUNK, "Serialized Chunk Cap NBT: " + nbt.toString(), new Object[0]);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        HashMap<BlockPos, UUID> deserializedMap = new HashMap<BlockPos, UUID>(CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).result().orElse(new HashMap()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.CHUNK, "Deserialized Chunk Cap: " + MsLoggy.mapToString(deserializedMap), new Object[0]);
        ((IChunkData)this.getCapability(CHUNK_CAP, null).orElse((Object)this.backend)).setMap(deserializedMap);
    }
}

