/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.events;

import com.mojang.blaze3d.platform.InputConstants;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.StatsScreen;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.ClientSetup;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipHandler {
    public static boolean tooltipOn = true;

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (!tooltipOn) {
            return;
        }
        Player player = event.getEntity();
        if (player != null) {
            Core core = Core.get(LogicalSide.CLIENT);
            ItemStack stack = event.getItemStack();
            ResourceLocation itemID = RegistryUtil.getId(stack);
            if (itemID == null) {
                return;
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)ClientSetup.OPEN_MENU.getKey().m_84873_())) {
                Minecraft.m_91087_().m_91152_((Screen)new StatsScreen(stack));
                return;
            }
            Map<String, Integer> wearReq = TooltipHandler.getReqData(core, ReqType.WEAR, stack);
            Map<String, Integer> toolReq = TooltipHandler.getReqData(core, ReqType.TOOL, stack);
            Map<String, Integer> weaponReq = TooltipHandler.getReqData(core, ReqType.WEAPON, stack);
            Map<String, Integer> useReq = TooltipHandler.getReqData(core, ReqType.USE, stack);
            Map<String, Integer> useEnchantmentReq = TooltipHandler.getReqData(core, ReqType.USE_ENCHANTMENT, stack);
            Map<String, Integer> placeReq = TooltipHandler.getReqData(core, ReqType.PLACE, stack);
            Map<String, Integer> breakReq = TooltipHandler.getReqData(core, ReqType.BREAK, stack);
            Map<String, Long> xpValueBreaking = TooltipHandler.getXpData(core, EventType.BLOCK_BREAK, player, stack);
            Map<String, Long> xpValueCrafting = TooltipHandler.getXpData(core, EventType.CRAFT, player, stack);
            Map<String, Long> xpValueSmelting = TooltipHandler.getXpData(core, EventType.SMELT, player, stack);
            Map<String, Long> xpValueBrewing = TooltipHandler.getXpData(core, EventType.BREW, player, stack);
            Map<String, Long> xpValueGrowing = TooltipHandler.getXpData(core, EventType.GROW, player, stack);
            Map<String, Long> xpValuePlacing = TooltipHandler.getXpData(core, EventType.BLOCK_PLACE, player, stack);
            Map<String, Double> heldItemXpBoost = core.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.HELD, TagUtils.stackTag(stack));
            Map<String, Double> wornItemXpBoost = core.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.WORN, TagUtils.stackTag(stack));
            VeinData veinData = VeinData.EMPTY;
            if (!core.getLoader().ITEM_LOADER.getData(itemID).veinData().isUnconfigured()) {
                veinData = core.getLoader().ITEM_LOADER.getData(itemID).veinData();
            }
            if (wearReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.WEAR).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_WEAR, event, wearReq, core);
            }
            if (toolReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.TOOL).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_TOOL, event, toolReq, core);
            }
            if (weaponReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.WEAPON).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_WEAPON, event, weaponReq, core);
            }
            if (useReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.USE).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_USE, event, useReq, core);
            }
            if (useEnchantmentReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.USE_ENCHANTMENT).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_ENCHANT, event, useEnchantmentReq, core);
            }
            if (placeReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.PLACE).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_PLACE, event, placeReq, core);
            }
            if (breakReq.size() > 0 && ((Boolean)Config.tooltipReqEnabled(ReqType.BREAK).get()).booleanValue()) {
                TooltipHandler.addRequirementTooltip(LangProvider.REQ_BREAK, event, breakReq, core);
            }
            if (xpValueBreaking.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.BLOCK_BREAK).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_BREAK, event, xpValueBreaking, core);
            }
            if (xpValueCrafting.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.CRAFT).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_CRAFT, event, xpValueCrafting, core);
            }
            if (xpValueSmelting.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.SMELT).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_SMELT, event, xpValueSmelting, core);
            }
            if (xpValueBrewing.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.BREW).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_BREW, event, xpValueBrewing, core);
            }
            if (xpValueGrowing.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.GROW).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_GROW, event, xpValueGrowing, core);
            }
            if (xpValuePlacing.size() > 0 && ((Boolean)Config.tooltipXpEnabled(EventType.BLOCK_PLACE).get()).booleanValue()) {
                TooltipHandler.addXpValueTooltip(LangProvider.XP_VALUE_PLACE, event, xpValuePlacing, core);
            }
            if (heldItemXpBoost.size() > 0 && ((Boolean)Config.tooltipBonusEnabled(ModifierDataType.HELD).get()).booleanValue()) {
                TooltipHandler.addModifierTooltip(LangProvider.BOOST_HELD, event, heldItemXpBoost, core);
            }
            if (wornItemXpBoost.size() > 0 && ((Boolean)Config.tooltipBonusEnabled(ModifierDataType.WORN).get()).booleanValue()) {
                TooltipHandler.addModifierTooltip(LangProvider.BOOST_WORN, event, wornItemXpBoost, core);
            }
            if (!veinData.equals(VeinData.EMPTY) && ((Boolean)Config.VEIN_ENABLED.get()).booleanValue()) {
                TooltipHandler.addVeinTooltip(LangProvider.VEIN_TOOLTIP, event, veinData, stack.m_41720_() instanceof BlockItem);
            }
        }
    }

    private static void addRequirementTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Integer> reqs, Core core) {
        event.getToolTip().add(header.asComponent());
        for (Map.Entry<String, Integer> req : reqs.entrySet()) {
            event.getToolTip().add(Component.m_237115_((String)("pmmo." + req.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(req.getValue())))).m_6270_(CoreUtils.getSkillStyle(req.getKey())));
        }
    }

    private static void addXpValueTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Long> values, Core core) {
        event.getToolTip().add(header.asComponent());
        values.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).forEach(value -> event.getToolTip().add(Component.m_237115_((String)("pmmo." + (String)value.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(value.getValue())))).m_6270_(CoreUtils.getSkillStyle((String)value.getKey()))));
    }

    private static void addModifierTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Double> values, Core core) {
        event.getToolTip().add(header.asComponent());
        values.entrySet().stream().filter(entry -> (Double)entry.getValue() != 0.0).forEach(modifier -> event.getToolTip().add(Component.m_237115_((String)("pmmo." + (String)modifier.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + TooltipHandler.modifierPercent((Double)modifier.getValue())))).m_6270_(CoreUtils.getSkillStyle((String)modifier.getKey()))));
    }

    private static void addVeinTooltip(LangProvider.Translation header, ItemTooltipEvent event, VeinData data, boolean isBlockItem) {
        event.getToolTip().add(header.asComponent());
        event.getToolTip().add(LangProvider.VEIN_DATA.asComponent(data.chargeCap.orElse(0), DP.dp(data.chargeRate.orElse(0.0) * 2.0)));
        if (isBlockItem) {
            event.getToolTip().add(LangProvider.VEIN_BREAK.asComponent(data.consumeAmount.orElse(0)));
        }
    }

    private static String modifierPercent(Double value) {
        return DP.dp((value - 1.0) * 100.0) + "%";
    }

    private static Map<String, Long> getXpData(Core core, EventType type, Player player, ItemStack stack) {
        Map<String, Long> map = core.getExperienceAwards(type, stack, player, new CompoundTag());
        if (stack.m_41720_() instanceof BlockItem) {
            map = core.getCommonXpAwardData(new HashMap<String, Long>(), type, RegistryUtil.getId(stack), player, ObjectType.BLOCK, TagUtils.stackTag(stack));
        }
        CoreUtils.processSkillGroupXP(map);
        return map;
    }

    private static Map<String, Integer> getReqData(Core core, ReqType type, ItemStack stack) {
        Map<String, Integer> map;
        if (!((Boolean)Config.reqEnabled(type).get()).booleanValue()) {
            return new HashMap<String, Integer>();
        }
        Map<String, Integer> map2 = map = type == ReqType.USE_ENCHANTMENT ? core.getEnchantReqs(stack) : core.getReqMap(type, stack);
        if (stack.m_41720_() instanceof BlockItem) {
            map.putAll(core.getCommonReqData(new HashMap<String, Integer>(), ObjectType.BLOCK, RegistryUtil.getId(stack), type, TagUtils.stackTag(stack)));
        }
        CoreUtils.processSkillGroupReqs(map);
        if (!((Boolean)Config.HIDE_MET_REQS.get()).booleanValue()) {
            return map;
        }
        new HashMap<String, Integer>(map).forEach((skill, level) -> {
            if (SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).isSkillGroup()) {
                int total = SkillsConfig.SKILLS.get().get(skill).getGroup().keySet().stream().map(groupskill -> core.getData().getPlayerSkillLevel((String)groupskill, null)).collect(Collectors.summingInt(Integer::intValue));
                if (level <= total) {
                    map.remove(skill);
                }
            } else if (core.getData().getPlayerSkillLevel((String)skill, null) >= level) {
                map.remove(skill);
            }
        });
        return map;
    }
}

