/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.client.events.ClientTickHandler;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.client.utils.VeinTracker;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.LogicalSide;

public class XPOverlayGUI
implements IGuiOverlay {
    private Core core = Core.get(LogicalSide.CLIENT);
    private int skillGap = 0;
    private Minecraft mc;
    private Font fontRenderer;
    private Map<String, Double> modifiers = new HashMap<String, Double>();
    private List<String> skillsKeys = new ArrayList<String>();
    private LinkedHashMap<String, SkillLine> lineRenderers = new LinkedHashMap();
    private int maxCharge = 0;
    private int currentCharge = 0;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (this.mc == null) {
            this.mc = Minecraft.m_91087_();
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.f_91062_;
        }
        if (!this.mc.f_91066_.f_92063_) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            if (((Boolean)Config.SKILL_LIST_DISPLAY.get()).booleanValue()) {
                this.renderSkillList(guiGraphics, (Double)Config.SKILL_LIST_OFFSET_X.get(), (Double)Config.SKILL_LIST_OFFSET_Y.get());
            }
            if (((Boolean)Config.VEIN_ENABLED.get()).booleanValue() && ((Boolean)Config.VEIN_GAUGE_DISPLAY.get()).booleanValue()) {
                this.renderVeinGauge(guiGraphics, (Double)Config.VEIN_GAUGE_OFFSET_X.get(), (Double)Config.VEIN_GAUGE_OFFSET_Y.get());
            }
            if (((Boolean)Config.GAIN_LIST_DISPLAY.get()).booleanValue()) {
                if (ClientTickHandler.xpGains.size() >= 1 && ClientTickHandler.xpGains.get((int)0).duration <= 0) {
                    ClientTickHandler.xpGains.remove(0);
                }
                this.renderGains(guiGraphics, (Double)Config.GAIN_LIST_OFFSET_X.get(), (Double)Config.GAIN_LIST_OFFSET_Y.get());
            }
            guiGraphics.m_280168_().m_85849_();
        }
        if (ClientTickHandler.isRefreshTick()) {
            ClientTickHandler.resetTicks();
        }
    }

    private void renderSkillList(GuiGraphics graphics, double skillListX, double skillListY) {
        int renderX = (int)((double)this.mc.m_91268_().m_85445_() * skillListX);
        int renderY = (int)((double)this.mc.m_91268_().m_85446_() * skillListY);
        if (ClientTickHandler.isRefreshTick()) {
            this.modifiers = this.core.getConsolidatedModifierMap((Player)this.mc.f_91074_);
            this.skillsKeys = this.core.getData().getXpMap(null).keySet().stream().sorted(Comparator.comparingLong(a -> this.core.getData().getXpRaw(null, (String)a)).reversed()).toList();
            LinkedHashMap<String, SkillLine> holderMap = this.lineRenderers;
            this.lineRenderers.clear();
            AtomicInteger yOffset = new AtomicInteger(0);
            this.skillGap = this.skillsKeys.stream().map(skill -> this.fontRenderer.m_92895_(Component.m_237115_((String)("pmmo." + skill)).getString())).max(Comparator.comparingInt(t -> t)).orElse(0);
            this.skillsKeys.forEach(skillKey -> {
                long xpRaw = this.core.getData().getXpRaw(null, (String)skillKey);
                this.lineRenderers.put((String)skillKey, xpRaw != holderMap.getOrDefault(skillKey, SkillLine.DEFAULT).xpValue() ? new SkillLine((String)skillKey, this.modifiers.getOrDefault(skillKey, 1.0), xpRaw, yOffset.get(), this.skillGap) : new SkillLine((SkillLine)holderMap.get(skillKey), yOffset.get()));
                yOffset.getAndIncrement();
            });
        }
        this.lineRenderers.forEach((skill, line) -> line.render(graphics, renderX, renderY, this.fontRenderer));
    }

    private void renderVeinGauge(GuiGraphics graphics, double gaugeX, double gaugeY) {
        int renderX = (int)((double)this.mc.m_91268_().m_85445_() * gaugeX);
        int renderY = (int)((double)this.mc.m_91268_().m_85446_() * gaugeY);
        if (ClientTickHandler.isRefreshTick()) {
            this.maxCharge = VeinMiningLogic.getMaxChargeFromAllItems((Player)this.mc.f_91074_);
            if (this.maxCharge > 0) {
                this.currentCharge = VeinTracker.getCurrentCharge();
            }
        }
        if (this.currentCharge > 0) {
            graphics.m_280430_(this.fontRenderer, (Component)LangProvider.VEIN_LIMIT.asComponent(Config.VEIN_LIMIT.get()), renderX, renderY - 11, 0xFFFFFF);
            graphics.m_280430_(this.fontRenderer, (Component)LangProvider.VEIN_CHARGE.asComponent(this.currentCharge, this.maxCharge), renderX, renderY, 0xFFFFFF);
        }
    }

    private void renderGains(GuiGraphics graphics, double listX, double listY) {
        int renderX = (int)((double)this.mc.m_91268_().m_85445_() * listX);
        int renderY = (int)((double)this.mc.m_91268_().m_85446_() * listY);
        for (int i = 0; i < ClientTickHandler.xpGains.size(); ++i) {
            graphics.m_280430_(this.fontRenderer, ClientTickHandler.xpGains.get((int)i).display, renderX, 3 + renderY + i * 9, i);
        }
    }

    private record SkillLine(String xpRaw, MutableComponent skillName, String bonusLine, long xpValue, int color, int yOffset, int skillGap) {
        public static SkillLine DEFAULT = new SkillLine("", Component.m_237113_((String)""), "", -1L, 0xFFFFFF, 0, 0);

        public SkillLine(String skillName, double bonus, long xpValue, int yOffset, int skillGap) {
            this(SkillLine.rawXpLine(xpValue, skillName), Component.m_237115_((String)("pmmo." + skillName)), SkillLine.bonusLine(bonus), xpValue, CoreUtils.getSkillColor(skillName), yOffset * 9, skillGap);
        }

        public SkillLine(SkillLine src, int yOffset) {
            this(src.xpRaw(), src.skillName(), src.bonusLine(), src.xpValue(), src.color, yOffset * 9, src.skillGap());
        }

        private static String rawXpLine(long xpValue, String skillKey) {
            int skillMaxLevel;
            double level = ((DataMirror)Core.get(LogicalSide.CLIENT).getData()).getXpWithPercentToNextLevel(xpValue);
            level = level > (double)(skillMaxLevel = SkillsConfig.SKILLS.get().getOrDefault(skillKey, SkillData.Builder.getDefault()).getMaxLevel()) ? (double)skillMaxLevel : level;
            return level >= (double)((Integer)Config.MAX_LEVEL.get()).intValue() ? "" + Config.MAX_LEVEL.get() : DP.dp(Math.floor(level * 100.0) / 100.0);
        }

        private static String bonusLine(double bonus) {
            if (bonus != 1.0) {
                return ((bonus = (Math.max(0.0, bonus) - 1.0) * 100.0) >= 0.0 ? "+" : "-") + DP.dp(bonus) + "%";
            }
            return "";
        }

        public void render(GuiGraphics graphics, int skillListX, int skillListY, Font fontRenderer) {
            int levelGap = fontRenderer.m_92895_(this.xpRaw());
            graphics.m_280488_(fontRenderer, this.xpRaw(), skillListX, skillListY + 3 + this.yOffset(), this.color());
            graphics.m_280488_(fontRenderer, " | " + this.skillName.getString(), skillListX + levelGap, skillListY + 3 + this.yOffset(), this.color());
            graphics.m_280488_(fontRenderer, " | " + DP.dprefix(this.xpValue()), skillListX + levelGap + this.skillGap() + 9, skillListY + 3 + this.yOffset(), this.color());
            graphics.m_280488_(fontRenderer, this.bonusLine, skillListX + levelGap + this.skillGap() + 46, skillListY + 3 + this.yOffset(), this.color());
        }
    }
}

