/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_SyncData;
import harmonised.pmmo.network.clientpackets.CP_SyncData_ClearXp;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;

public class CmdNodeAdmin {
    private static final String SKILL_ARG = "Skill Name";
    private static final String TARGET_ARG = "Target";
    private static final String TYPE_ARG = "Change Type";
    private static final String VALUE_ARG = "New Value";
    private static SuggestionProvider<CommandSourceStack> SKILL_SUGGESTIONS = new SuggestionProvider<CommandSourceStack>(){

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            return SharedSuggestionProvider.m_82970_(SkillsConfig.SKILLS.get().keySet(), (SuggestionsBuilder)builder);
        }
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(p -> p.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)TARGET_ARG, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.m_82129_((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, true))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.m_82129_((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, false))))))).then(Commands.m_82127_((String)"clear").executes(CmdNodeAdmin::adminClear))).then(Commands.m_82127_((String)"ignoreReqs").executes(CmdNodeAdmin::exemptAdmin))).then(Commands.m_82127_((String)"adminBonus").then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.m_82129_((String)VALUE_ARG, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(CmdNodeAdmin::adminBonuses))))).executes(ctx -> CmdNodeAdmin.displayPlayer((CommandContext<CommandSourceStack>)ctx)));
    }

    public static int adminSetOrAdd(CommandContext<CommandSourceStack> ctx, boolean isSet) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(ctx, (String)TARGET_ARG);
        String skillName = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        boolean isLevel = StringArgumentType.getString(ctx, (String)TYPE_ARG).equalsIgnoreCase("level");
        Long value = LongArgumentType.getLong(ctx, (String)VALUE_ARG);
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : players) {
            if (isSet) {
                if (isLevel) {
                    data.setPlayerSkillLevel(skillName, player.m_20148_(), value.intValue());
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.SET_LEVEL.asComponent(skillName, value, player.m_7755_()), true);
                    continue;
                }
                data.setXpRaw(player.m_20148_(), skillName, value);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.SET_XP.asComponent(skillName, value, player.m_7755_()), true);
                continue;
            }
            if (isLevel) {
                data.changePlayerSkillLevel(skillName, player.m_20148_(), value.intValue());
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.ADD_LEVEL.asComponent(skillName, value, player.m_7755_()), true);
                continue;
            }
            data.setXpDiff(player.m_20148_(), skillName, value);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.ADD_XP.asComponent(skillName, value, player.m_7755_()), true);
        }
        return 0;
    }

    public static int adminClear(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)TARGET_ARG)) {
            data.setXpMap(player.m_20148_(), new HashMap<String, Long>());
            Networking.sendToClient(new CP_SyncData_ClearXp(), player);
        }
        return 0;
    }

    public static int displayPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)TARGET_ARG)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> player.m_7755_(), false);
            for (Map.Entry<String, Long> skillMap : data.getXpMap(player.m_20148_()).entrySet()) {
                int level = data.getLevelFromXP(skillMap.getValue());
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)((String)skillMap.getKey() + ": " + level + " | " + skillMap.getValue())), false);
            }
        }
        return 0;
    }

    public static int exemptAdmin(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        boolean exists;
        Core core = Core.get((Level)((CommandSourceStack)ctx.getSource()).m_81372_());
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)TARGET_ARG);
        ResourceLocation playerID = new ResourceLocation(player.m_20148_().toString());
        PlayerData existing = core.getLoader().PLAYER_LOADER.getData().get(playerID);
        boolean bl = exists = existing != null;
        PlayerData updated = new PlayerData(true, exists ? !existing.ignoreReq() : true, exists ? existing.bonuses() : Map.of());
        core.getLoader().PLAYER_LOADER.getData().put(playerID, updated);
        Networking.sendToClient(new CP_SyncData(ObjectType.PLAYER, core.getLoader().PLAYER_LOADER.getData()), player);
        return 0;
    }

    public static int adminBonuses(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        double bonus = DoubleArgumentType.getDouble(ctx, (String)VALUE_ARG);
        String skill = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        Core core = Core.get((Level)((CommandSourceStack)ctx.getSource()).m_81372_());
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)TARGET_ARG);
        ResourceLocation playerID = new ResourceLocation(player.m_20148_().toString());
        PlayerData existing = core.getLoader().PLAYER_LOADER.getData().get(playerID);
        boolean exists = existing != null;
        HashMap<String, Double> bonuses = exists ? new HashMap<String, Double>(existing.bonuses()) : new HashMap();
        bonuses.put(skill, bonus);
        if (skill.equals("clear")) {
            bonuses.clear();
        }
        PlayerData updated = new PlayerData(true, exists ? !existing.ignoreReq() : true, bonuses);
        core.getLoader().PLAYER_LOADER.getData().put(playerID, updated);
        Networking.sendToClient(new CP_SyncData(ObjectType.PLAYER, core.getLoader().PLAYER_LOADER.getData()), player);
        return 0;
    }
}

