/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CmdNodeParty {
    private static final String REQUEST_ID = "requestID";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(Commands.m_82127_((String)"create").executes(c -> CmdNodeParty.partyCreate((CommandContext<CommandSourceStack>)c)))).then(Commands.m_82127_((String)"leave").executes(c -> CmdNodeParty.partyLeave((CommandContext<CommandSourceStack>)c)))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> CmdNodeParty.partyInvite((CommandContext<CommandSourceStack>)c))))).then(Commands.m_82127_((String)"uninvite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> CmdNodeParty.partyUninvite((CommandContext<CommandSourceStack>)c))))).then(Commands.m_82127_((String)"list").executes(c -> CmdNodeParty.listParty((CommandContext<CommandSourceStack>)c)))).then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)REQUEST_ID, (ArgumentType)UuidArgument.m_113850_()).executes(c -> CmdNodeParty.partyAccept((CommandContext<CommandSourceStack>)c))))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)REQUEST_ID, (ArgumentType)UuidArgument.m_113850_()).executes(c -> CmdNodeParty.partyDecline((CommandContext<CommandSourceStack>)c))))).executes(c -> {
            System.out.println(PartyUtils.isInParty((Player)((CommandSourceStack)c.getSource()).m_81375_()));
            return 0;
        });
    }

    public static int partyCreate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (PartyUtils.isInParty((Player)player)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)LangProvider.PARTY_ALREADY_IN.asComponent());
            return 1;
        }
        PartyUtils.createParty((Player)player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_CREATED.asComponent(), false);
        return 0;
    }

    public static int partyLeave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PartyUtils.removeFromParty((Player)((CommandSourceStack)ctx.getSource()).m_81375_());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_LEFT.asComponent(), false);
        return 0;
    }

    public static int partyInvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        if (!PartyUtils.isInParty((Player)((CommandSourceStack)ctx.getSource()).m_81375_())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        PartyUtils.inviteToParty((Player)((CommandSourceStack)ctx.getSource()).m_81375_(), (Player)player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_INVITE.asComponent(player.m_5446_()), false);
        return 0;
    }

    public static int partyUninvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        PartyUtils.uninviteToParty((Player)((CommandSourceStack)ctx.getSource()).m_81375_(), (Player)player);
        return 0;
    }

    public static int listParty(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!PartyUtils.isInParty((Player)((CommandSourceStack)ctx.getSource()).m_81375_())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        List<String> memberNames = PartyUtils.getPartyMembers(((CommandSourceStack)ctx.getSource()).m_81375_()).stream().map(s -> s.m_7755_().getString()).toList();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_MEMBER_TOTAL.asComponent(memberNames.size()), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_MEMBER_LIST.asComponent(memberNames), false);
        return 0;
    }

    public static int partyAccept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.m_113853_(ctx, (String)REQUEST_ID);
        PartyUtils.acceptInvite((Player)((CommandSourceStack)ctx.getSource()).m_81375_(), requestID);
        return 0;
    }

    public static int partyDecline(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.m_113853_(ctx, (String)REQUEST_ID);
        if (PartyUtils.declineInvite(requestID)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_DECLINE.asComponent(), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_NO_INVITES.asComponent(), false);
        return 0;
    }
}

