/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.compat.crafttweaker;

import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.PerkSide;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.compat.crafttweaker.CTDescriptionFunction;
import harmonised.pmmo.compat.crafttweaker.CTPerkFunction;
import harmonised.pmmo.compat.crafttweaker.CTPerkPredicate;
import harmonised.pmmo.compat.crafttweaker.CTTickFunction;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.core.Core;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.function.TriFunction;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/PMMO/CTUtils")
@ZenCodeType.Name(value="mods.pmmo.CTUtils")
public class CTUtils
implements IRuntimeAction {
    public static final String MOB_HEALTH = "health";
    public static final String MOB_SPEED = "speed";
    public static final String MOB_DAMAGE = "damage";

    public void apply() {
    }

    public String describe() {
        return "Functionality for using ZenCode to access PMMO's API.";
    }

    public String systemName() {
        return "pmmo";
    }

    @ZenCodeType.Method
    public static void setReq(ObjectType objectType, ResourceLocation objectID, ReqType type, Map<String, Integer> requirements) {
        switch (objectType) {
            case ITEM: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).reqs().put(type, requirements);
                break;
            }
            case BLOCK: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BLOCK_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).reqs().put(type, requirements);
                break;
            }
            case ENTITY: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENTITY_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).reqs().put(type, requirements);
                break;
            }
            case DIMENSION: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.travelReq().clear();
                data.travelReq().putAll(requirements);
                break;
            }
            case BIOME: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.travelReq().clear();
                data.travelReq().putAll(requirements);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void setEnchantment(ResourceLocation enchantID, int enchantLevel, Map<String, Integer> reqs) {
        EnhancementsData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENCHANTMENT_LOADER.getData().computeIfAbsent(enchantID, rl -> new EnhancementsData());
        data.skillArray().clear();
        data.skillArray().put(enchantLevel, reqs);
    }

    @ZenCodeType.Method
    public static void setXpAward(ObjectType objectType, ResourceLocation objectID, EventType type, Map<String, Long> award) {
        switch (objectType) {
            case ITEM: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).xpValues().put(type, award);
                break;
            }
            case BLOCK: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BLOCK_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).xpValues().put(type, award);
                break;
            }
            case ENTITY: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENTITY_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).xpValues().put(type, award);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void setEffectXp(ResourceLocation effectID, int effectLevel, Map<String, Integer> xpGains) {
        EnhancementsData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().EFFECT_LOADER.getData().computeIfAbsent(effectID, rl -> new EnhancementsData());
        data.skillArray().clear();
        data.skillArray().put(effectLevel, xpGains);
    }

    @ZenCodeType.Method
    public static void setBonus(ObjectType objectType, ResourceLocation objectID, ModifierDataType type, Map<String, Double> bonus) {
        switch (objectType) {
            case ITEM: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData()).bonuses().put(type, bonus);
                break;
            }
            case DIMENSION: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData()).bonusMap().put(type, bonus);
                break;
            }
            case BIOME: {
                Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData()).bonusMap().put(type, bonus);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void setNegativeEffect(ObjectType objectType, ResourceLocation objectID, Map<ResourceLocation, Integer> effects) {
        switch (objectType) {
            case ITEM: {
                ObjectData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.getData().computeIfAbsent(objectID, rl -> new ObjectData());
                data.negativeEffects().clear();
                data.negativeEffects().putAll(effects.entrySet().stream().collect(Collectors.toMap(entry -> (ResourceLocation)entry.getKey(), entry -> (Integer)entry.getValue())));
                break;
            }
            case DIMENSION: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.negative().clear();
                data.negative().putAll(effects);
                break;
            }
            case BIOME: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.negative().clear();
                data.negative().putAll(effects);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void setPositiveEffect(ObjectType objectType, ResourceLocation objectID, Map<ResourceLocation, Integer> effects) {
        switch (objectType) {
            case DIMENSION: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.positive().clear();
                data.positive().putAll(effects);
                break;
            }
            case BIOME: {
                LocationData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.getData().computeIfAbsent(objectID, rl -> new LocationData());
                data.positive().clear();
                data.positive().putAll(effects);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void setSalvage(ResourceLocation item, Map<ResourceLocation, SalvageBuilder> salvage) {
        ObjectData data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.getData().computeIfAbsent(item, rl -> new ObjectData());
        data.salvage().clear();
        data.salvage().putAll(salvage.entrySet().stream().collect(Collectors.toMap(entry -> (ResourceLocation)entry.getKey(), entry -> ((SalvageBuilder)entry.getValue()).build())));
    }

    @ZenCodeType.Method
    public static void setMobModifier(ObjectType objectType, ResourceLocation locationID, ResourceLocation mobID, Map<String, Double> modifiers) {
        switch (objectType) {
            case DIMENSION: {
                Map<ResourceLocation, Map<String, Double>> data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.getData().computeIfAbsent(locationID, rl -> new LocationData()).mobModifiers();
                data.clear();
                data.put(mobID, modifiers);
                break;
            }
            case BIOME: {
                Map<ResourceLocation, Map<String, Double>> data = Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.getData().computeIfAbsent(locationID, rl -> new LocationData()).mobModifiers();
                data.clear();
                data.put(mobID, modifiers);
                break;
            }
        }
    }

    @ZenCodeType.Method
    public static void registerPerk(ResourceLocation perkID, MapData defaults, CTPerkPredicate customConditions, CTPerkFunction onStart, CTTickFunction onTick, CTPerkFunction onStop, LiteralContents description, CTDescriptionFunction status, int side) {
        BiPredicate<Player, CompoundTag> conditions = (p, c) -> customConditions.test((Player)p, (MapData)TagToDataConverter.convert((Tag)c));
        BiFunction<Player, CompoundTag, CompoundTag> execute = (p, c) -> onStart.apply((Player)p, (MapData)TagToDataConverter.convert((Tag)c)).getInternal();
        TriFunction tick = (p, c, t) -> onTick.apply((Player)p, (MapData)TagToDataConverter.convert((Tag)c), (int)t).getInternal();
        BiFunction<Player, CompoundTag, CompoundTag> conclude = (p, c) -> onStop.apply((Player)p, (MapData)TagToDataConverter.convert((Tag)c)).getInternal();
        BiFunction<Player, CompoundTag, List<MutableComponent>> statusOut = (p, c) -> status.apply((Player)p, (MapData)TagToDataConverter.convert((Tag)c)).stream().map(MutableComponent::m_237204_).toList();
        PerkSide perkSide = PerkSide.values()[side > 2 ? 2 : side];
        Perk perk = new Perk(conditions, defaults.getInternal(), execute, (TriFunction<Player, CompoundTag, Integer, CompoundTag>)tick, conclude, MutableComponent.m_237204_((ComponentContents)description), statusOut);
        APIUtils.registerPerk(perkID, perk, perkSide);
    }

    @ZenRegister
    @Document(value="mods/PMMO/SalvageBuilder")
    @ZenCodeType.Name(value="mods.pmmo.SalvageBuilder")
    public static class SalvageBuilder {
        private Map<String, Double> chancePerLevel = new HashMap<String, Double>();
        private Map<String, Integer> levelReq = new HashMap<String, Integer>();
        private Map<String, Long> xpAward = new HashMap<String, Long>();
        private int salvageMax = 1;
        private double baseChance = 0.0;
        private double maxChance = 1.0;

        private SalvageBuilder() {
        }

        @ZenCodeType.Method
        public static SalvageBuilder start() {
            return new SalvageBuilder();
        }

        @ZenCodeType.Method
        public SalvageBuilder setChancePerLevel(Map<String, Double> chancePerLevel) {
            this.chancePerLevel = chancePerLevel;
            return this;
        }

        @ZenCodeType.Method
        public SalvageBuilder setLevelReq(Map<String, Integer> levelReq) {
            this.levelReq = levelReq;
            return this;
        }

        @ZenCodeType.Method
        public SalvageBuilder setXpAward(Map<String, Long> xpAward) {
            this.xpAward = xpAward;
            return this;
        }

        @ZenCodeType.Method
        public SalvageBuilder setSalvageMax(int max) {
            this.salvageMax = max;
            return this;
        }

        @ZenCodeType.Method
        public SalvageBuilder setBaseChance(double chance) {
            this.baseChance = chance;
            return this;
        }

        @ZenCodeType.Method
        public SalvageBuilder setMaxChance(double chance) {
            this.maxChance = chance;
            return this;
        }

        public CodecTypes.SalvageData build() {
            return new CodecTypes.SalvageData(this.chancePerLevel, this.levelReq, this.xpAward, this.salvageMax, this.baseChance, this.maxChance);
        }
    }
}

